/*
 * Decompiled with CFR 0.152.
 */
package ui.tuneinfos;

import java.io.File;
import java.util.Collection;
import java.util.stream.Collectors;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.collections.transformation.SortedList;
import javafx.fxml.FXML;
import javafx.scene.control.TableView;
import libsidplay.sidtune.SidTune;
import sidplay.Player;
import ui.common.C64Window;
import ui.entities.collection.HVSCEntry;
import ui.musiccollection.SearchCriteria;
import ui.musiccollection.TuneInfo;

public class TuneInfos
extends C64Window {
    @FXML
    private TableView<TuneInfo> tuneInfoTable;
    private ObservableList<TuneInfo> tuneInfos;

    public TuneInfos() {
    }

    public TuneInfos(Player player) {
        super(player);
    }

    @Override
    @FXML
    protected void initialize() {
        this.tuneInfos = FXCollections.observableArrayList();
        SortedList sortedList = new SortedList(this.tuneInfos);
        sortedList.comparatorProperty().bind((ObservableValue)this.tuneInfoTable.comparatorProperty());
        this.tuneInfoTable.setItems((ObservableList)sortedList);
    }

    public void showTuneInfos(File tuneFile, SidTune tune) {
        HVSCEntry entry = new HVSCEntry(() -> this.util.getPlayer().getSidDatabaseInfo(db -> db.getTuneLength(tune), 0.0), tuneFile.getName(), tuneFile.getPath(), tuneFile.length(), tuneFile.lastModified(), tune, tune.identify().stream().collect(Collectors.joining(",")));
        this.tuneInfos.setAll((Collection)SearchCriteria.getAttributeValues(entry, field -> this.util.getBundle().getString(HVSCEntry.class.getSimpleName() + "." + field.getAttribute().getName())).stream().map(info -> new TuneInfo((String)info.getKey(), (String)info.getValue())).collect(Collectors.toList()));
    }
}

