/*
 * Decompiled with CFR 0.152.
 */
package ui.virtualKeyboard;

import java.util.HashSet;
import java.util.Set;
import javafx.fxml.FXML;
import javafx.scene.control.ToggleButton;
import javafx.scene.input.MouseButton;
import javafx.scene.input.MouseEvent;
import libsidplay.C64;
import libsidplay.common.Event;
import libsidplay.common.EventScheduler;
import libsidplay.components.keyboard.KeyTableEntry;
import sidplay.Player;
import ui.common.C64Window;

public class Keyboard
extends C64Window {
    @FXML
    private ToggleButton shiftLocked;
    private final Set<KeyTableEntry> keysPressed = new HashSet<KeyTableEntry>();

    public Keyboard() {
    }

    public Keyboard(Player player) {
        super(player);
    }

    @Override
    protected void initialize() {
        this.getStage().resizableProperty().set(false);
    }

    @Override
    public void doClose() {
        for (KeyTableEntry keyTableEntry : this.getC64().getKeyboard().getKeysDown()) {
            this.releaseC64Key(keyTableEntry);
        }
    }

    @FXML
    private void keyPressed(MouseEvent mouseEvent) {
        ToggleButton button = (ToggleButton)mouseEvent.getSource();
        KeyTableEntry keyTableEntry = Enum.valueOf(KeyTableEntry.class, button.getUserData().toString());
        if (!this.shiftLocked.equals(button) && mouseEvent.getButton() == MouseButton.PRIMARY) {
            button.setSelected(true);
            this.pressC64Key(keyTableEntry);
        }
        if ((this.shiftLocked.equals(button) || mouseEvent.getButton() == MouseButton.SECONDARY) && !button.isSelected()) {
            this.keysPressed.add(keyTableEntry);
        }
    }

    @FXML
    private void keyReleased(MouseEvent mouseEvent) {
        ToggleButton button = (ToggleButton)mouseEvent.getSource();
        KeyTableEntry keyTableEntry = Enum.valueOf(KeyTableEntry.class, button.getUserData().toString());
        if (!this.shiftLocked.equals(button) && mouseEvent.getButton() == MouseButton.PRIMARY) {
            button.setSelected(false);
            this.releaseC64Key(keyTableEntry);
        }
        if (this.shiftLocked.equals(button) || mouseEvent.getButton() == MouseButton.SECONDARY) {
            if (this.keysPressed.remove((Object)keyTableEntry)) {
                button.setSelected(true);
                this.pressC64Key(keyTableEntry);
            } else {
                button.setSelected(false);
                this.releaseC64Key(keyTableEntry);
            }
        }
    }

    @FXML
    private void restore() {
        this.util.getPlayer().getC64().getKeyboard().restore();
    }

    private void pressC64Key(KeyTableEntry key) {
        EventScheduler ctx = this.getC64().getEventScheduler();
        ctx.scheduleThreadSafeKeyEvent(Event.of("Virtual Keyboard Key Pressed: " + key.name(), event -> this.getC64().getKeyboard().keyPressed(key)));
    }

    private void releaseC64Key(KeyTableEntry key) {
        EventScheduler ctx = this.getC64().getEventScheduler();
        ctx.scheduleThreadSafeKeyEvent(Event.of("Virtual Keyboard Key Released: " + key.name(), event -> this.getC64().getKeyboard().keyReleased(key)));
    }

    @FXML
    private void list() {
        this.util.getPlayer().typeInCommand("LIST\r");
    }

    @FXML
    private void run() {
        this.util.getPlayer().typeInCommand("RUN\r");
    }

    @FXML
    private void sys() {
        this.util.getPlayer().typeInCommand("SYS 49152");
    }

    @FXML
    private void reset() {
        this.util.getPlayer().typeInCommand("SYS 64738\r");
    }

    @FXML
    private void directory() {
        this.util.getPlayer().typeInCommand("LOAD\"$\",8\r");
    }

    @FXML
    private void diskLoad() {
        this.util.getPlayer().typeInCommand("LOAD\"*\",8,1\r");
    }

    @FXML
    private void tapeLoad() {
        this.util.getPlayer().typeInCommand("LOAD\r");
    }

    protected C64 getC64() {
        return this.util.getPlayer().getC64();
    }
}

