/*
 * Decompiled with CFR 0.152.
 */
package net.java.truecommons.cio;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.channels.SeekableByteChannel;
import javax.annotation.concurrent.Immutable;
import net.java.truecommons.cio.Entry;
import net.java.truecommons.cio.InputSocket;
import net.java.truecommons.cio.OutputSocket;
import net.java.truecommons.io.Sink;
import net.java.truecommons.io.Source;
import net.java.truecommons.io.Streams;

@Immutable
public final class IoSockets {
    private IoSockets() {
    }

    public static void copy(InputSocket<?> input, OutputSocket<?> output) throws IOException {
        Streams.copy((Source)new InputAdapter(input, output), (Sink)new OutputAdapter(output, input));
    }

    private static class OutputAdapter
    implements Sink {
        final OutputSocket<? extends Entry> output;
        final InputSocket<? extends Entry> input;

        OutputAdapter(OutputSocket<? extends Entry> output, InputSocket<? extends Entry> input) {
            this.output = output;
            this.input = input;
        }

        public OutputStream stream() throws IOException {
            return this.output.stream(this.input);
        }

        public SeekableByteChannel channel() throws IOException {
            return this.output.channel(this.input);
        }
    }

    private static class InputAdapter
    implements Source {
        final InputSocket<? extends Entry> input;
        final OutputSocket<? extends Entry> output;

        InputAdapter(InputSocket<? extends Entry> input, OutputSocket<? extends Entry> output) {
            this.input = input;
            this.output = output;
        }

        public InputStream stream() throws IOException {
            return this.input.stream(this.output);
        }

        public SeekableByteChannel channel() throws IOException {
            return this.input.channel(this.output);
        }
    }
}

