/*
 * Decompiled with CFR 0.152.
 */
package kickass.common.assmbleinfo;

import java.util.ArrayList;
import java.util.List;
import kickass.common.assmbleinfo.AssembleInfoType;
import kickass.common.assmbleinfo.AssembleInfoTypePool;
import kickass.common.assmbleinfo.IAssembleInfoWriter;
import kickass.common.diagnostics.IDiagnostic;
import kickass.common.syntaxinfo.SyntaxInfo;
import kickass.pass.function.Function;
import kickass.setup.KickAssemblerSetup;
import kickass.setup.features.FeatureType;
import kickass.setup.features.IFeature;
import kickass.setup.features.KickAssemblerFeatures;
import kickass.state.EvaluationState;
import kickass.state.libraries.ILibrary;
import kickass.state.libraries.LibConstant;

public class AssembleInfoManager {
    private IAssembleInfoWriter out;

    public AssembleInfoManager(IAssembleInfoWriter iAssembleInfoWriter) {
        this.out = iAssembleInfoWriter;
    }

    public void WriteInfo(EvaluationState evaluationState) {
        AssembleInfoTypePool assembleInfoTypePool = evaluationState.parameters.assembleInfos;
        if (assembleInfoTypePool.includes(AssembleInfoType.version)) {
            this.writeVersion(evaluationState);
        }
        if (assembleInfoTypePool.includes(AssembleInfoType.libraries)) {
            this.writeLibraries(evaluationState);
        }
        if (assembleInfoTypePool.includes(AssembleInfoType.directives)) {
            this.writeFeatures("directives", FeatureType.directive, evaluationState);
        }
        if (assembleInfoTypePool.includes(AssembleInfoType.preprocessorDirectives)) {
            this.writeFeatures("ppdirectives", FeatureType.preprocessorDirective, evaluationState);
        }
        if (assembleInfoTypePool.includes(AssembleInfoType.errors)) {
            this.writeErrors(evaluationState);
        }
        if (assembleInfoTypePool.includes(AssembleInfoType.syntax)) {
            this.writeSyntax(evaluationState);
        }
        if (assembleInfoTypePool.includes(AssembleInfoType.files)) {
            this.out.writeFilesSection("files");
        }
    }

    private void writeVersion(EvaluationState evaluationState) {
        this.out.addSection("version");
        this.out.addStringField(KickAssemblerSetup.versionString);
        this.out.nextLine();
    }

    private void writeSyntax(EvaluationState evaluationState) {
        this.out.addSection("syntax");
        for (SyntaxInfo syntaxInfo : evaluationState.syntaxInfoMgr.getSyntaxInfo()) {
            this.out.addStringField(syntaxInfo.getType().toString());
            this.out.addSourceRangeField(syntaxInfo.getRange());
            this.out.nextLine();
        }
    }

    private void writeLibraries(EvaluationState evaluationState) {
        this.out.addSection("libraries");
        List<ILibrary> list = KickAssemblerSetup.getStdLibararies();
        for (ILibrary iLibrary : list) {
            for (LibConstant libConstant : iLibrary.getConstants()) {
                this.out.addStringField(iLibrary.getName());
                this.out.addStringField("constant");
                this.out.addStringField(libConstant.getName());
                this.out.nextLine();
            }
            for (Function function : iLibrary.getFunctions()) {
                this.out.addStringField(iLibrary.getName());
                this.out.addStringField("function");
                this.out.addStringField(function.getName());
                this.out.addIntField(function.getNoOfArguments());
                this.out.nextLine();
            }
        }
    }

    private void writeFeatures(String string, FeatureType featureType, EvaluationState evaluationState) {
        this.out.addSection(string);
        List<IFeature> list = KickAssemblerFeatures.getFeaturesOfType(featureType);
        for (IFeature iFeature : list) {
            this.out.addStringField(iFeature.getName());
            this.out.addStringField(iFeature.getExample());
            this.out.addStringField(iFeature.getDescription());
            this.out.nextLine();
        }
    }

    private void writeErrors(EvaluationState evaluationState) {
        this.out.addSection("errors");
        ArrayList<IDiagnostic> arrayList = new ArrayList<IDiagnostic>();
        arrayList.addAll(evaluationState.diagnosticMgr.getErrors());
        arrayList.addAll(evaluationState.diagnosticMgr.getWarnings());
        for (IDiagnostic iDiagnostic : arrayList) {
            this.out.addStringField(iDiagnostic.getType().capitalizedName);
            this.out.addSourceRangeField(iDiagnostic.getRange());
            this.out.addStringField(iDiagnostic.getMessage());
            this.out.nextLine();
        }
    }
}

