/*
 * Decompiled with CFR 0.152.
 */
package kickass.common.output;

import java.util.ArrayList;

public class D64Image {
    private static final int[] sectorsPerTrack = new int[]{21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 19, 19, 19, 19, 19, 19, 19, 18, 18, 18, 18, 18, 18, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17};
    private boolean track18Split = true;
    private boolean useTrack18 = false;
    private int extraTracksBamOffset = 192;
    private int nrTracks = 35;
    private ArrayList<D64File> files = new ArrayList();
    private byte[] image;

    public D64Image() {
        this.formatImage(Format.COMMODORE, true, false);
    }

    public D64Image(Format format, boolean bl, boolean bl2) {
        this.formatImage(format, bl, bl2);
    }

    public void setName(byte[] byArray) {
        int n = this.linearSector(18, 0) * 256;
        for (int i = 0; i < 16; ++i) {
            this.image[n + 144 + i] = i < byArray.length ? byArray[i] : -96;
        }
    }

    public void setID(byte[] byArray) {
        int n = this.linearSector(18, 0) * 256;
        for (int i = 0; i < 5; ++i) {
            this.image[n + 162 + i] = i < byArray.length ? byArray[i] : -96;
        }
    }

    public D64File addFile(byte[] byArray, byte[] byArray2) {
        return this.addFile(byArray, FileType.PRG, 10, byArray2, false, true);
    }

    public D64File addFile(byte[] byArray, FileType fileType, int n, byte[] byArray2, boolean bl, boolean bl2) {
        D64File d64File = new D64File();
        d64File.name = byArray;
        d64File.type = fileType;
        d64File.interleave = n;
        d64File.data = byArray2;
        d64File.locked = bl;
        d64File.visible = bl2;
        this.files.add(d64File);
        return d64File;
    }

    public byte[] generateImage() {
        int n;
        int n2;
        int n3 = 0;
        for (D64File d64File : this.files) {
            if (!d64File.visible) continue;
            ++n3;
        }
        int n4 = 8 * sectorsPerTrack[18];
        if (n3 > n4) {
            throw new D64ImageException(String.format("Too many visible files. Got %d, max is %d.", n3, n4));
        }
        for (n2 = 0; n2 < n3 / 8 + 1; ++n2) {
            this.markSector(18, n2 + 1, false);
        }
        n2 = 1;
        int n5 = 0;
        int n6 = 0;
        int n7 = n2;
        int n8 = n5;
        int n9 = this.linearSector(n7, n8) * 256;
        for (D64File object : this.files) {
            int d64File = object.data.length;
            byte[] n17 = object.data;
            n = 0;
            int n10 = d64File;
            while (n10 > 0) {
                int n11;
                int n12;
                boolean bl = false;
                int n13 = 0;
                while (!bl) {
                    for (n12 = n5; n12 < n5 + sectorsPerTrack[n2 - 1]; ++n12) {
                        n13 = n12 % sectorsPerTrack[n2 - 1];
                        if (!this.isSectorFree(n2, n13)) continue;
                        bl = true;
                        break;
                    }
                    if (bl) continue;
                    n5 = 0;
                    if (!this.useTrack18 && ++n2 == 18) {
                        if (!this.track18Split) {
                            if (object.nrSectors > 0) {
                                n12 = object.track;
                                n11 = object.sector;
                                while (n12 != 0) {
                                    this.markSector(n12, n11, true);
                                    int n14 = this.linearSector(n12, n11) * 256;
                                    n12 = this.image[n14 + 0] & 0xFF;
                                    n11 = this.image[n14 + 1] & 0xFF;
                                    for (int i = 0; i < 256; ++i) {
                                        this.image[n14 + i] = 0;
                                    }
                                }
                            }
                            n10 = d64File;
                            n = 0;
                            object.nrSectors = 0;
                        }
                        n2 = 19;
                    }
                    if (n2 != this.nrTracks + 1) continue;
                    throw new D64ImageException("Disk is full!");
                }
                n5 = n13;
                n12 = this.linearSector(n2, n5) * 256;
                if (n10 == d64File) {
                    object.track = n2;
                    object.sector = n5;
                    n7 = n2;
                    n8 = n5;
                    n9 = n12;
                } else {
                    this.image[n9 + 0] = (byte)n2;
                    this.image[n9 + 1] = (byte)n5;
                }
                n6 = Math.min(254, n10);
                for (n11 = 0; n11 < n6; ++n11) {
                    this.image[n12 + 2 + n11] = n17[n11 + n];
                }
                n10 -= n6;
                n += n6;
                n7 = n2;
                n8 = n5;
                n9 = n12;
                this.markSector(n2, n5, false);
                n5 += object.interleave;
                ++object.nrSectors;
            }
            this.image[n9 + 0] = 0;
            this.image[n9 + 1] = (byte)(n6 + 1);
        }
        n5 = 1;
        int n16 = 0;
        for (D64File d64File : this.files) {
            if (!d64File.visible) continue;
            int n15 = this.linearSector(18, n5) * 256 + n16 * 32;
            this.markSector(18, n5, false);
            if (n16 == 0) {
                if (n3 > 8 && n5 < sectorsPerTrack[18] - 1) {
                    this.image[n15 + 0] = 18;
                    this.image[n15 + 1] = (byte)(n5 + 1);
                } else {
                    this.image[n15 + 0] = 0;
                    this.image[n15 + 1] = -1;
                }
            } else {
                this.image[n15 + 0] = 0;
                this.image[n15 + 1] = 0;
            }
            this.image[n15 + 2] = (byte)(d64File.type.id | (d64File.locked ? 64 : 0));
            this.image[n15 + 3] = (byte)d64File.track;
            this.image[n15 + 4] = (byte)d64File.sector;
            for (n = 0; n < 16; ++n) {
                this.image[n15 + 5 + n] = n < d64File.name.length ? d64File.name[n] : -96;
            }
            this.image[n15 + 30] = (byte)(d64File.nrSectors & 0xFF);
            this.image[n15 + 31] = (byte)(d64File.nrSectors >> 8);
            if (++n16 == 8) {
                ++n5;
                n16 = 0;
            }
            --n3;
        }
        return this.image;
    }

    private void formatImage(Format format, boolean bl, boolean bl2) {
        int n;
        int n2;
        switch (format) {
            case COMMODORE: {
                this.nrTracks = 35;
                break;
            }
            case SPEEDDOS: {
                this.nrTracks = 40;
                this.extraTracksBamOffset = 172;
                break;
            }
            case DOLPHINDOS: {
                this.nrTracks = 40;
                this.extraTracksBamOffset = 192;
            }
        }
        this.track18Split = bl;
        this.useTrack18 = bl2;
        int n3 = 0;
        for (n2 = 0; n2 < this.nrTracks; ++n2) {
            n3 += sectorsPerTrack[n2] * 256;
        }
        this.image = new byte[n3];
        n2 = this.linearSector(18, 0) * 256;
        this.image[n2 + 0] = 18;
        this.image[n2 + 1] = 1;
        this.image[n2 + 2] = 65;
        for (n = 1; n <= this.nrTracks; ++n) {
            for (int i = 0; i < sectorsPerTrack[n - 1]; ++i) {
                this.markSector(n, i, true);
            }
        }
        for (n = 144; n <= 170; ++n) {
            this.image[n2 + n] = -96;
        }
        this.markSector(18, 0, false);
    }

    private int linearSector(int n, int n2) {
        if (n < 1 || n > this.nrTracks) {
            throw new D64ImageException(String.format("D64Image: Tried to access track %d (Allowed range is [1..%d])", n, this.nrTracks));
        }
        if (n2 < 0 || n2 >= sectorsPerTrack[n - 1]) {
            throw new D64ImageException(String.format("D64Image: Tried to access sector %d on track %d (Allowed range for this sector is [0..%d]", n2, n, sectorsPerTrack[n - 1]));
        }
        int n3 = 0;
        for (int i = 0; i < n - 1; ++i) {
            n3 += sectorsPerTrack[i];
        }
        return n3 += n2;
    }

    private int getBamForTrack(int n) {
        int n2 = this.linearSector(18, 0) * 256;
        if (n > 35) {
            n -= 35;
            n2 = this.linearSector(18, 0) * 256 + this.extraTracksBamOffset;
        }
        return n2 + n * 4;
    }

    private boolean isSectorFree(int n, int n2) {
        int n3;
        int n4;
        int n5 = this.getBamForTrack(n);
        return (this.image[n5 + (n4 = 1 + n2 / 8)] & (n3 = 1 << (n2 & 7))) != 0;
    }

    private void markSector(int n, int n2, boolean bl) {
        if (bl == this.isSectorFree(n, n2)) {
            return;
        }
        int n3 = this.getBamForTrack(n);
        if (bl) {
            int n4 = n3;
            this.image[n4] = (byte)(this.image[n4] + 1);
        } else {
            int n5 = n3;
            this.image[n5] = (byte)(this.image[n5] - 1);
        }
        int n6 = 1 + n2 / 8;
        int n7 = 1 << (n2 & 7);
        if (bl) {
            int n8 = n3 + n6;
            this.image[n8] = (byte)(this.image[n8] | (byte)n7);
        } else {
            int n9 = n3 + n6;
            this.image[n9] = (byte)(this.image[n9] & (byte)(~n7));
        }
    }

    public static enum Format {
        COMMODORE,
        SPEEDDOS,
        DOLPHINDOS;

    }

    public static enum FileType {
        DEL(128),
        SEQ(129),
        PRG(130),
        USR(131),
        REL(132);

        private int id;

        private FileType(int n2) {
            this.id = n2;
        }
    }

    public class D64File {
        public byte[] name;
        public FileType type;
        public int interleave = 10;
        public byte[] data;
        public boolean locked;
        public boolean visible;
        public int track = 0;
        public int sector = 0;
        public int nrSectors = 0;
    }

    public class D64ImageException
    extends RuntimeException {
        public D64ImageException(String string) {
            super(string);
        }
    }
}

