/*
 * Decompiled with CFR 0.152.
 */
package kickass.pass.function.special;

import kickass.common.exceptions.AsmErrorException;
import kickass.nonasm.util.functions.Action4;
import kickass.parsing.sourcelocation.SourceRange;
import kickass.pass.function.Function;
import kickass.pass.values.NullValue;
import kickass.pass.values.Value;
import kickass.state.EvaluationState;

public class ValAction3Arg<T extends Value>
extends Function {
    private boolean failOnInvalidArgs = true;
    private Action4<T, Value, Value, SourceRange> action;

    public ValAction3Arg(String string, Action4<T, Value, Value, SourceRange> action4) {
        super(string, 3, null, true);
        this.action = action4;
    }

    public ValAction3Arg(String string, boolean bl, Action4<T, Value, Value, SourceRange> action4) {
        super(string, 3, null, true);
        this.action = action4;
        this.failOnInvalidArgs = bl;
    }

    @Override
    public Value execute(Value[] valueArray, EvaluationState evaluationState, SourceRange sourceRange) {
        if (valueArray[0].isInvalid()) {
            return NullValue.instance;
        }
        if (this.failOnInvalidArgs && valueArray[1].isInvalid()) {
            throw new AsmErrorException("Function can't be called with invalid first argument (Unresolved label, etc.)", sourceRange);
        }
        if (this.failOnInvalidArgs && valueArray[2].isInvalid()) {
            throw new AsmErrorException("Function can't be called with invalid second argument (Unresolved label, etc.)", sourceRange);
        }
        this.action.apply(valueArray[0], valueArray[1], valueArray[2], sourceRange);
        return NullValue.instance;
    }
}

