/*
 * Decompiled with CFR 0.152.
 */
package kickass.pass.values;

import kickass.common.exceptions.AsmErrorException;
import kickass.parsing.sourcelocation.SourceRange;
import kickass.pass.asmnode.output.reciever.OutputStreamType;
import kickass.pass.function.Function;
import kickass.pass.function.table.FunctionTable;
import kickass.pass.function.table.StdFunctionTable;
import kickass.pass.values.BooleanValue;
import kickass.pass.values.ImmutableValue;
import kickass.pass.values.NullValue;
import kickass.pass.values.StringValue;
import kickass.pass.values.Value;
import kickass.state.EvaluationState;

public class OutputFileValue
extends ImmutableValue {
    private static String newline = System.getProperty("line.separator");
    public static OutputFileValue invalid = new OutputFileValue();
    private String filename;
    static FunctionTable functions = new StdFunctionTable(OutputFileValue.getStandardFunctions());

    private OutputFileValue() {
        this.setInvalid();
    }

    public OutputFileValue(String string, EvaluationState evaluationState) {
        this.filename = string;
        evaluationState.sideeffectMgr.addStreamOutput(OutputStreamType.FILE, string, "");
    }

    @Override
    public FunctionTable getFunctions() {
        return functions;
    }

    @Override
    public String getType() {
        return "OutputFile";
    }

    static {
        functions.add(new Function("writeln", 2, BooleanValue.invalid){

            @Override
            public Value execute(Value[] valueArray, EvaluationState evaluationState, SourceRange sourceRange) {
                Value value;
                if (valueArray.length > 2) {
                    throw new AsmErrorException("Cannot use more than 1 argument", sourceRange);
                }
                OutputFileValue outputFileValue = (OutputFileValue)valueArray[0];
                Value value2 = value = valueArray.length == 1 ? StringValue.emptyString : valueArray[1];
                if (outputFileValue.isInvalid() || value.isInvalid()) {
                    evaluationState.sideeffectMgr.setErrorDuringFunctionEvaluation(true);
                    return NullValue.instance;
                }
                evaluationState.sideeffectMgr.addStreamOutput(OutputStreamType.FILE, outputFileValue.filename, value.getString(sourceRange) + newline);
                return NullValue.instance;
            }
        });
    }
}

