/*
 * Decompiled with CFR 0.152.
 */
package com.xuggle.xuggler.demos;

import com.xuggle.xuggler.Global;
import com.xuggle.xuggler.IAudioSamples;
import com.xuggle.xuggler.ICodec;
import com.xuggle.xuggler.IContainer;
import com.xuggle.xuggler.IPacket;
import com.xuggle.xuggler.IPixelFormat;
import com.xuggle.xuggler.IStream;
import com.xuggle.xuggler.IStreamCoder;
import com.xuggle.xuggler.IVideoPicture;
import com.xuggle.xuggler.IVideoResampler;
import com.xuggle.xuggler.Utils;
import com.xuggle.xuggler.demos.VideoImage;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.SourceDataLine;

public class DecodeAndPlayAudioAndVideo {
    private static SourceDataLine mLine;
    private static VideoImage mScreen;
    private static long mSystemVideoClockStartTime;
    private static long mFirstVideoTimestampInStream;

    public static void main(String[] args) {
        if (args.length <= 0) {
            throw new IllegalArgumentException("must pass in a filename as the first argument");
        }
        String filename = args[0];
        if (!IVideoResampler.isSupported(IVideoResampler.Feature.FEATURE_COLORSPACECONVERSION)) {
            throw new RuntimeException("you must install the GPL version of Xuggler (with IVideoResampler support) for this demo to work");
        }
        IContainer container = IContainer.make();
        if (container.open(filename, IContainer.Type.READ, null) < 0) {
            throw new IllegalArgumentException("could not open file: " + filename);
        }
        int numStreams = container.getNumStreams();
        int videoStreamId = -1;
        IStreamCoder videoCoder = null;
        int audioStreamId = -1;
        IStreamCoder audioCoder = null;
        for (int i = 0; i < numStreams; ++i) {
            IStream stream = container.getStream(i);
            IStreamCoder coder = stream.getStreamCoder();
            if (videoStreamId == -1 && coder.getCodecType() == ICodec.Type.CODEC_TYPE_VIDEO) {
                videoStreamId = i;
                videoCoder = coder;
                continue;
            }
            if (audioStreamId != -1 || coder.getCodecType() != ICodec.Type.CODEC_TYPE_AUDIO) continue;
            audioStreamId = i;
            audioCoder = coder;
        }
        if (videoStreamId == -1 && audioStreamId == -1) {
            throw new RuntimeException("could not find audio or video stream in container: " + filename);
        }
        IVideoResampler resampler = null;
        if (videoCoder != null) {
            if (videoCoder.open() < 0) {
                throw new RuntimeException("could not open audio decoder for container: " + filename);
            }
            if (videoCoder.getPixelType() != IPixelFormat.Type.BGR24 && (resampler = IVideoResampler.make(videoCoder.getWidth(), videoCoder.getHeight(), IPixelFormat.Type.BGR24, videoCoder.getWidth(), videoCoder.getHeight(), videoCoder.getPixelType())) == null) {
                throw new RuntimeException("could not create color space resampler for: " + filename);
            }
            DecodeAndPlayAudioAndVideo.openJavaVideo();
        }
        if (audioCoder != null) {
            if (audioCoder.open() < 0) {
                throw new RuntimeException("could not open audio decoder for container: " + filename);
            }
            try {
                DecodeAndPlayAudioAndVideo.openJavaSound(audioCoder);
            }
            catch (LineUnavailableException ex) {
                throw new RuntimeException("unable to open sound device on your system when playing back container: " + filename);
            }
        }
        IPacket packet = IPacket.make();
        mFirstVideoTimestampInStream = Global.NO_PTS;
        mSystemVideoClockStartTime = 0L;
        while (container.readNextPacket(packet) >= 0) {
            int bytesDecoded;
            if (packet.getStreamIndex() == videoStreamId) {
                IVideoPicture picture = IVideoPicture.make(videoCoder.getPixelType(), videoCoder.getWidth(), videoCoder.getHeight());
                int bytesDecoded2 = videoCoder.decodeVideo(picture, packet, 0);
                if (bytesDecoded2 < 0) {
                    throw new RuntimeException("got error decoding audio in: " + filename);
                }
                if (!picture.isComplete()) continue;
                IVideoPicture newPic = picture;
                if (resampler != null && resampler.resample(newPic = IVideoPicture.make(resampler.getOutputPixelFormat(), picture.getWidth(), picture.getHeight()), picture) < 0) {
                    throw new RuntimeException("could not resample video from: " + filename);
                }
                if (newPic.getPixelType() != IPixelFormat.Type.BGR24) {
                    throw new RuntimeException("could not decode video as BGR 24 bit data in: " + filename);
                }
                long delay = DecodeAndPlayAudioAndVideo.millisecondsUntilTimeToDisplay(newPic);
                try {
                    if (delay > 0L) {
                        Thread.sleep(delay);
                    }
                }
                catch (InterruptedException e) {
                    return;
                }
                mScreen.setImage(Utils.videoPictureToImage(newPic));
                continue;
            }
            if (packet.getStreamIndex() != audioStreamId) continue;
            IAudioSamples samples = IAudioSamples.make(1024L, audioCoder.getChannels());
            for (int offset = 0; offset < packet.getSize(); offset += bytesDecoded) {
                bytesDecoded = audioCoder.decodeAudio(samples, packet, offset);
                if (bytesDecoded >= 0) continue;
                throw new RuntimeException("got error decoding audio in: " + filename);
            }
        }
        if (videoCoder != null) {
            videoCoder.close();
            videoCoder = null;
        }
        if (audioCoder != null) {
            audioCoder.close();
            audioCoder = null;
        }
        if (container != null) {
            container.close();
            container = null;
        }
        DecodeAndPlayAudioAndVideo.closeJavaSound();
        DecodeAndPlayAudioAndVideo.closeJavaVideo();
    }

    private static long millisecondsUntilTimeToDisplay(IVideoPicture picture) {
        long millisecondsToSleep = 0L;
        if (mFirstVideoTimestampInStream == Global.NO_PTS) {
            mFirstVideoTimestampInStream = picture.getTimeStamp();
            mSystemVideoClockStartTime = System.currentTimeMillis();
            millisecondsToSleep = 0L;
        } else {
            long systemClockCurrentTime = System.currentTimeMillis();
            long millisecondsClockTimeSinceStartofVideo = systemClockCurrentTime - mSystemVideoClockStartTime;
            long millisecondsStreamTimeSinceStartOfVideo = (picture.getTimeStamp() - mFirstVideoTimestampInStream) / 1000L;
            long millisecondsTolerance = 50L;
            millisecondsToSleep = millisecondsStreamTimeSinceStartOfVideo - (millisecondsClockTimeSinceStartofVideo + 50L);
        }
        return millisecondsToSleep;
    }

    private static void openJavaVideo() {
        mScreen = new VideoImage();
    }

    private static void closeJavaVideo() {
        System.exit(0);
    }

    private static void openJavaSound(IStreamCoder aAudioCoder) throws LineUnavailableException {
        AudioFormat audioFormat = new AudioFormat(aAudioCoder.getSampleRate(), (int)IAudioSamples.findSampleBitDepth(aAudioCoder.getSampleFormat()), aAudioCoder.getChannels(), true, false);
        DataLine.Info info = new DataLine.Info(SourceDataLine.class, audioFormat);
        mLine = (SourceDataLine)AudioSystem.getLine(info);
        mLine.open(audioFormat);
        mLine.start();
    }

    private static void playJavaSound(IAudioSamples aSamples) {
        byte[] rawBytes = aSamples.getData().getByteArray(0, aSamples.getSize());
        mLine.write(rawBytes, 0, aSamples.getSize());
    }

    private static void closeJavaSound() {
        if (mLine != null) {
            mLine.drain();
            mLine.close();
            mLine = null;
        }
    }

    static {
        mScreen = null;
    }
}

