/*
 * Decompiled with CFR 0.152.
 */
package mp3;

import java.util.Arrays;
import mp3.GainAnalysis;
import mp3.GrInfo;
import mp3.HuffCodeTab;
import mp3.IIISideInfo;
import mp3.LameGlobalFlags;
import mp3.LameInternalFlags;
import mp3.Tables;
import mp3.Takehiro;
import mp3.VBRTag;
import mp3.Version;
import mpg.MPGLib;

public class BitStream {
    private static final int CRC16_POLYNOMIAL = 32773;
    private static final int MAX_LENGTH = 32;
    GainAnalysis ga;
    MPGLib mpg;
    VBRTag vbr;
    private Version version = new Version();
    private byte[] buf;
    private int totbit;
    private int bufByteIdx;
    private int bufBitIdx;

    public final void setModules(GainAnalysis ga, MPGLib mpg, VBRTag vbr) {
        this.ga = ga;
        this.mpg = mpg;
        this.vbr = vbr;
    }

    public final int getframebits(LameGlobalFlags gfp) {
        LameInternalFlags gfc = gfp.internal_flags;
        int bit_rate = gfc.bitrate_index != 0 ? Tables.bitrate_table[gfp.getMpegVersion()][gfc.bitrate_index] : gfp.getBitRate();
        assert (8 <= bit_rate && bit_rate <= 640);
        return 8 * ((gfp.getMpegVersion() + 1) * 72000 * bit_rate / gfp.getOutSampleRate() + gfc.padding);
    }

    private void putheader_bits(LameInternalFlags gfc) {
        System.arraycopy(gfc.header[gfc.w_ptr].buf, 0, this.buf, this.bufByteIdx, gfc.sideinfo_len);
        this.bufByteIdx += gfc.sideinfo_len;
        this.totbit += gfc.sideinfo_len * 8;
        gfc.w_ptr = gfc.w_ptr + 1 & 0xFF;
    }

    private void putbits2(LameInternalFlags gfc, int val, int j) {
        assert (j < 30);
        while (j > 0) {
            if (this.bufBitIdx == 0) {
                this.bufBitIdx = 8;
                ++this.bufByteIdx;
                assert (this.bufByteIdx < 147456);
                assert (gfc.header[gfc.w_ptr].write_timing >= this.totbit);
                if (gfc.header[gfc.w_ptr].write_timing == this.totbit) {
                    this.putheader_bits(gfc);
                }
                this.buf[this.bufByteIdx] = 0;
            }
            int k = Math.min(j, this.bufBitIdx);
            this.bufBitIdx -= k;
            assert ((j -= k) < 32);
            assert (this.bufBitIdx < 32);
            int n = this.bufByteIdx;
            this.buf[n] = (byte)(this.buf[n] | val >> j << this.bufBitIdx);
            this.totbit += k;
        }
    }

    private void putbits_noheaders(LameInternalFlags gfc, int val, int j) {
        assert (j < 30);
        while (j > 0) {
            if (this.bufBitIdx == 0) {
                this.bufBitIdx = 8;
                ++this.bufByteIdx;
                assert (this.bufByteIdx < 147456);
                this.buf[this.bufByteIdx] = 0;
            }
            int k = Math.min(j, this.bufBitIdx);
            this.bufBitIdx -= k;
            assert ((j -= k) < 32);
            assert (this.bufBitIdx < 32);
            int n = this.bufByteIdx;
            this.buf[n] = (byte)(this.buf[n] | val >> j << this.bufBitIdx);
            this.totbit += k;
        }
    }

    private void drain_into_ancillary(LameGlobalFlags gfp, int remainingBits) {
        LameInternalFlags gfc = gfp.internal_flags;
        assert (remainingBits >= 0);
        if (remainingBits >= 8) {
            this.putbits2(gfc, 76, 8);
            remainingBits -= 8;
        }
        if (remainingBits >= 8) {
            this.putbits2(gfc, 65, 8);
            remainingBits -= 8;
        }
        if (remainingBits >= 8) {
            this.putbits2(gfc, 77, 8);
            remainingBits -= 8;
        }
        if (remainingBits >= 8) {
            this.putbits2(gfc, 69, 8);
            remainingBits -= 8;
        }
        if (remainingBits >= 32) {
            String versionStr = this.version.getLameShortVersion();
            if (remainingBits >= 32) {
                for (int i = 0; i < versionStr.length() && remainingBits >= 8; remainingBits -= 8, ++i) {
                    this.putbits2(gfc, versionStr.charAt(i), 8);
                }
            }
        }
        while (remainingBits >= 1) {
            this.putbits2(gfc, gfc.ancillary_flag, 1);
            gfc.ancillary_flag = gfc.ancillary_flag ^ (!gfp.disable_reservoir ? 1 : 0);
            --remainingBits;
        }
        assert (remainingBits == 0);
    }

    private void writeheader(LameInternalFlags gfc, int val, int j) {
        int ptr = gfc.header[gfc.h_ptr].ptr;
        while (j > 0) {
            int k = Math.min(j, 8 - (ptr & 7));
            assert ((j -= k) < 32);
            int n = ptr >> 3;
            gfc.header[gfc.h_ptr].buf[n] = (byte)(gfc.header[gfc.h_ptr].buf[n] | val >> j << 8 - (ptr & 7) - k);
            ptr += k;
        }
        gfc.header[gfc.h_ptr].ptr = ptr;
    }

    private int CRC_update(int value, int crc) {
        value <<= 8;
        for (int i = 0; i < 8; ++i) {
            if ((((crc <<= 1) ^ (value <<= 1)) & 0x10000) == 0) continue;
            crc ^= 0x8005;
        }
        return crc;
    }

    public final void CRC_writeheader(LameInternalFlags gfc, byte[] header) {
        int crc = 65535;
        crc = this.CRC_update(header[2] & 0xFF, crc);
        crc = this.CRC_update(header[3] & 0xFF, crc);
        for (int i = 6; i < gfc.sideinfo_len; ++i) {
            crc = this.CRC_update(header[i] & 0xFF, crc);
        }
        header[4] = (byte)(crc >> 8);
        header[5] = (byte)(crc & 0xFF);
    }

    private void encodeSideInfo2(LameGlobalFlags gfp, int bitsPerFrame) {
        LameInternalFlags gfc = gfp.internal_flags;
        IIISideInfo l3_side = gfc.l3_side;
        gfc.header[gfc.h_ptr].ptr = 0;
        Arrays.fill(gfc.header[gfc.h_ptr].buf, 0, gfc.sideinfo_len, (byte)0);
        if (gfp.getOutSampleRate() < 16000) {
            this.writeheader(gfc, 4094, 12);
        } else {
            this.writeheader(gfc, 4095, 12);
        }
        this.writeheader(gfc, gfp.getMpegVersion(), 1);
        this.writeheader(gfc, 1, 2);
        this.writeheader(gfc, !gfp.error_protection ? 1 : 0, 1);
        this.writeheader(gfc, gfc.bitrate_index, 4);
        this.writeheader(gfc, gfc.samplerate_index, 2);
        this.writeheader(gfc, gfc.padding, 1);
        this.writeheader(gfc, gfp.extension, 1);
        this.writeheader(gfc, gfp.getMode().getNumMode(), 2);
        this.writeheader(gfc, gfc.mode_ext, 2);
        this.writeheader(gfc, gfp.copyright, 1);
        this.writeheader(gfc, gfp.original, 1);
        this.writeheader(gfc, gfp.emphasis, 2);
        if (gfp.error_protection) {
            this.writeheader(gfc, 0, 16);
        }
        if (gfp.getMpegVersion() == 1) {
            int ch;
            assert (l3_side.main_data_begin >= 0);
            this.writeheader(gfc, l3_side.main_data_begin, 9);
            if (gfc.channels_out == 2) {
                this.writeheader(gfc, l3_side.private_bits, 3);
            } else {
                this.writeheader(gfc, l3_side.private_bits, 5);
            }
            for (ch = 0; ch < gfc.channels_out; ++ch) {
                for (int band = 0; band < 4; ++band) {
                    this.writeheader(gfc, l3_side.scfsi[ch][band], 1);
                }
            }
            for (int gr = 0; gr < 2; ++gr) {
                for (ch = 0; ch < gfc.channels_out; ++ch) {
                    GrInfo gi = l3_side.tt[gr][ch];
                    this.writeheader(gfc, gi.part2_3_length + gi.part2_length, 12);
                    this.writeheader(gfc, gi.big_values / 2, 9);
                    this.writeheader(gfc, gi.global_gain, 8);
                    this.writeheader(gfc, gi.scalefac_compress, 4);
                    if (gi.block_type != 0) {
                        this.writeheader(gfc, 1, 1);
                        this.writeheader(gfc, gi.block_type, 2);
                        this.writeheader(gfc, gi.mixed_block_flag, 1);
                        if (gi.table_select[0] == 14) {
                            gi.table_select[0] = 16;
                        }
                        this.writeheader(gfc, gi.table_select[0], 5);
                        if (gi.table_select[1] == 14) {
                            gi.table_select[1] = 16;
                        }
                        this.writeheader(gfc, gi.table_select[1], 5);
                        this.writeheader(gfc, gi.subblock_gain[0], 3);
                        this.writeheader(gfc, gi.subblock_gain[1], 3);
                        this.writeheader(gfc, gi.subblock_gain[2], 3);
                    } else {
                        this.writeheader(gfc, 0, 1);
                        if (gi.table_select[0] == 14) {
                            gi.table_select[0] = 16;
                        }
                        this.writeheader(gfc, gi.table_select[0], 5);
                        if (gi.table_select[1] == 14) {
                            gi.table_select[1] = 16;
                        }
                        this.writeheader(gfc, gi.table_select[1], 5);
                        if (gi.table_select[2] == 14) {
                            gi.table_select[2] = 16;
                        }
                        this.writeheader(gfc, gi.table_select[2], 5);
                        assert (0 <= gi.region0_count && gi.region0_count < 16);
                        assert (0 <= gi.region1_count && gi.region1_count < 8);
                        this.writeheader(gfc, gi.region0_count, 4);
                        this.writeheader(gfc, gi.region1_count, 3);
                    }
                    this.writeheader(gfc, gi.preflag, 1);
                    this.writeheader(gfc, gi.scalefac_scale, 1);
                    this.writeheader(gfc, gi.count1table_select, 1);
                }
            }
        } else {
            assert (l3_side.main_data_begin >= 0);
            this.writeheader(gfc, l3_side.main_data_begin, 8);
            this.writeheader(gfc, l3_side.private_bits, gfc.channels_out);
            int gr = 0;
            for (int ch = 0; ch < gfc.channels_out; ++ch) {
                GrInfo gi = l3_side.tt[gr][ch];
                this.writeheader(gfc, gi.part2_3_length + gi.part2_length, 12);
                this.writeheader(gfc, gi.big_values / 2, 9);
                this.writeheader(gfc, gi.global_gain, 8);
                this.writeheader(gfc, gi.scalefac_compress, 9);
                if (gi.block_type != 0) {
                    this.writeheader(gfc, 1, 1);
                    this.writeheader(gfc, gi.block_type, 2);
                    this.writeheader(gfc, gi.mixed_block_flag, 1);
                    if (gi.table_select[0] == 14) {
                        gi.table_select[0] = 16;
                    }
                    this.writeheader(gfc, gi.table_select[0], 5);
                    if (gi.table_select[1] == 14) {
                        gi.table_select[1] = 16;
                    }
                    this.writeheader(gfc, gi.table_select[1], 5);
                    this.writeheader(gfc, gi.subblock_gain[0], 3);
                    this.writeheader(gfc, gi.subblock_gain[1], 3);
                    this.writeheader(gfc, gi.subblock_gain[2], 3);
                } else {
                    this.writeheader(gfc, 0, 1);
                    if (gi.table_select[0] == 14) {
                        gi.table_select[0] = 16;
                    }
                    this.writeheader(gfc, gi.table_select[0], 5);
                    if (gi.table_select[1] == 14) {
                        gi.table_select[1] = 16;
                    }
                    this.writeheader(gfc, gi.table_select[1], 5);
                    if (gi.table_select[2] == 14) {
                        gi.table_select[2] = 16;
                    }
                    this.writeheader(gfc, gi.table_select[2], 5);
                    assert (0 <= gi.region0_count && gi.region0_count < 16);
                    assert (0 <= gi.region1_count && gi.region1_count < 8);
                    this.writeheader(gfc, gi.region0_count, 4);
                    this.writeheader(gfc, gi.region1_count, 3);
                }
                this.writeheader(gfc, gi.scalefac_scale, 1);
                this.writeheader(gfc, gi.count1table_select, 1);
            }
        }
        if (gfp.error_protection) {
            this.CRC_writeheader(gfc, gfc.header[gfc.h_ptr].buf);
        }
        int old = gfc.h_ptr;
        assert (gfc.header[old].ptr == gfc.sideinfo_len * 8);
        gfc.h_ptr = old + 1 & 0xFF;
        gfc.header[gfc.h_ptr].write_timing = gfc.header[old].write_timing + bitsPerFrame;
        if (gfc.h_ptr == gfc.w_ptr) {
            System.err.println("Error: MAX_HEADER_BUF too small in bitstream.c \n");
        }
    }

    private int huffman_coder_count1(LameInternalFlags gfc, GrInfo gi) {
        HuffCodeTab h = Tables.ht[gi.count1table_select + 32];
        int bits = 0;
        int ix = gi.big_values;
        int xr = gi.big_values;
        assert (gi.count1table_select < 2);
        for (int i = (gi.count1 - gi.big_values) / 4; i > 0; --i) {
            int huffbits = 0;
            int p = 0;
            int v = gi.l3_enc[ix + 0];
            if (v != 0) {
                p += 8;
                if (gi.xr[xr + 0] < 0.0f) {
                    ++huffbits;
                }
                assert (v <= 1);
            }
            if ((v = gi.l3_enc[ix + 1]) != 0) {
                p += 4;
                huffbits *= 2;
                if (gi.xr[xr + 1] < 0.0f) {
                    ++huffbits;
                }
                assert (v <= 1);
            }
            if ((v = gi.l3_enc[ix + 2]) != 0) {
                p += 2;
                huffbits *= 2;
                if (gi.xr[xr + 2] < 0.0f) {
                    ++huffbits;
                }
                assert (v <= 1);
            }
            if ((v = gi.l3_enc[ix + 3]) != 0) {
                ++p;
                huffbits *= 2;
                if (gi.xr[xr + 3] < 0.0f) {
                    ++huffbits;
                }
                assert (v <= 1);
            }
            ix += 4;
            xr += 4;
            this.putbits2(gfc, huffbits + h.table[p], h.hlen[p]);
            bits += h.hlen[p];
        }
        return bits;
    }

    private int Huffmancode(LameInternalFlags gfc, int tableindex, int start, int end, GrInfo gi) {
        HuffCodeTab h = Tables.ht[tableindex];
        int bits = 0;
        assert (tableindex < 32);
        if (0 == tableindex) {
            return bits;
        }
        for (int i = start; i < end; i += 2) {
            int cbits = 0;
            int xbits = 0;
            int linbits = h.xlen;
            int xlen = h.xlen;
            int ext = 0;
            int x1 = gi.l3_enc[i];
            int x2 = gi.l3_enc[i + 1];
            if (x1 != 0) {
                if (gi.xr[i] < 0.0f) {
                    ++ext;
                }
                --cbits;
            }
            if (tableindex > 15) {
                if (x1 > 14) {
                    int linbits_x1 = x1 - 15;
                    assert (linbits_x1 <= h.linmax);
                    ext |= linbits_x1 << 1;
                    xbits = linbits;
                    x1 = 15;
                }
                if (x2 > 14) {
                    int linbits_x2 = x2 - 15;
                    assert (linbits_x2 <= h.linmax);
                    ext <<= linbits;
                    ext |= linbits_x2;
                    xbits += linbits;
                    x2 = 15;
                }
                xlen = 16;
            }
            if (x2 != 0) {
                ext <<= 1;
                if (gi.xr[i + 1] < 0.0f) {
                    ++ext;
                }
                --cbits;
            }
            assert ((x1 | x2) < 16);
            x1 = x1 * xlen + x2;
            xbits -= cbits;
            assert ((cbits += h.hlen[x1]) <= 32);
            assert (xbits <= 32);
            this.putbits2(gfc, h.table[x1], cbits);
            this.putbits2(gfc, ext, xbits);
            bits += cbits + xbits;
        }
        return bits;
    }

    private int ShortHuffmancodebits(LameInternalFlags gfc, GrInfo gi) {
        int region1Start = 3 * gfc.scalefac_band.s[3];
        if (region1Start > gi.big_values) {
            region1Start = gi.big_values;
        }
        int bits = this.Huffmancode(gfc, gi.table_select[0], 0, region1Start, gi);
        return bits += this.Huffmancode(gfc, gi.table_select[1], region1Start, gi.big_values, gi);
    }

    private int LongHuffmancodebits(LameInternalFlags gfc, GrInfo gi) {
        int bigvalues = gi.big_values;
        assert (0 <= bigvalues && bigvalues <= 576);
        int i = gi.region0_count + 1;
        assert (0 <= i);
        assert (i < gfc.scalefac_band.l.length);
        int region1Start = gfc.scalefac_band.l[i];
        assert (0 <= (i += gi.region1_count + 1));
        assert (i < gfc.scalefac_band.l.length);
        int region2Start = gfc.scalefac_band.l[i];
        if (region1Start > bigvalues) {
            region1Start = bigvalues;
        }
        if (region2Start > bigvalues) {
            region2Start = bigvalues;
        }
        int bits = this.Huffmancode(gfc, gi.table_select[0], 0, region1Start, gi);
        bits += this.Huffmancode(gfc, gi.table_select[1], region1Start, region2Start, gi);
        return bits += this.Huffmancode(gfc, gi.table_select[2], region2Start, bigvalues, gi);
    }

    private int writeMainData(LameGlobalFlags gfp) {
        int tot_bits = 0;
        LameInternalFlags gfc = gfp.internal_flags;
        IIISideInfo l3_side = gfc.l3_side;
        if (gfp.getMpegVersion() == 1) {
            for (int gr = 0; gr < 2; ++gr) {
                for (int ch = 0; ch < gfc.channels_out; ++ch) {
                    int sfb;
                    GrInfo gi = l3_side.tt[gr][ch];
                    int slen1 = Takehiro.slen1_tab[gi.scalefac_compress];
                    int slen2 = Takehiro.slen2_tab[gi.scalefac_compress];
                    int data_bits = 0;
                    for (sfb = 0; sfb < gi.sfbdivide; ++sfb) {
                        if (gi.scalefac[sfb] == -1) continue;
                        this.putbits2(gfc, gi.scalefac[sfb], slen1);
                        data_bits += slen1;
                    }
                    while (sfb < gi.sfbmax) {
                        if (gi.scalefac[sfb] != -1) {
                            this.putbits2(gfc, gi.scalefac[sfb], slen2);
                            data_bits += slen2;
                        }
                        ++sfb;
                    }
                    assert (data_bits == gi.part2_length);
                    data_bits = gi.block_type == 2 ? (data_bits += this.ShortHuffmancodebits(gfc, gi)) : (data_bits += this.LongHuffmancodebits(gfc, gi));
                    assert ((data_bits += this.huffman_coder_count1(gfc, gi)) == gi.part2_3_length + gi.part2_length);
                    tot_bits += data_bits;
                }
            }
        } else {
            int gr = 0;
            for (int ch = 0; ch < gfc.channels_out; ++ch) {
                int i;
                int slen;
                int sfbs;
                int sfb_partition;
                GrInfo gi = l3_side.tt[gr][ch];
                int scale_bits = 0;
                assert (gi.sfb_partition_table != null);
                int data_bits = 0;
                int sfb = 0;
                if (gi.block_type == 2) {
                    for (sfb_partition = 0; sfb_partition < 4; ++sfb_partition) {
                        sfbs = gi.sfb_partition_table[sfb_partition] / 3;
                        slen = gi.slen[sfb_partition];
                        i = 0;
                        while (i < sfbs) {
                            this.putbits2(gfc, Math.max(gi.scalefac[sfb * 3 + 0], 0), slen);
                            this.putbits2(gfc, Math.max(gi.scalefac[sfb * 3 + 1], 0), slen);
                            this.putbits2(gfc, Math.max(gi.scalefac[sfb * 3 + 2], 0), slen);
                            scale_bits += 3 * slen;
                            ++i;
                            ++sfb;
                        }
                    }
                    data_bits += this.ShortHuffmancodebits(gfc, gi);
                } else {
                    while (sfb_partition < 4) {
                        sfbs = gi.sfb_partition_table[sfb_partition];
                        slen = gi.slen[sfb_partition];
                        i = 0;
                        while (i < sfbs) {
                            this.putbits2(gfc, Math.max(gi.scalefac[sfb], 0), slen);
                            scale_bits += slen;
                            ++i;
                            ++sfb;
                        }
                        ++sfb_partition;
                    }
                    data_bits += this.LongHuffmancodebits(gfc, gi);
                }
                assert ((data_bits += this.huffman_coder_count1(gfc, gi)) == gi.part2_3_length);
                assert (scale_bits == gi.part2_length);
                tot_bits += scale_bits + data_bits;
            }
        }
        return tot_bits;
    }

    private int compute_flushbits(LameGlobalFlags gfp, TotalBytes total_bytes_output) {
        int flushbits;
        LameInternalFlags gfc = gfp.internal_flags;
        int first_ptr = gfc.w_ptr;
        int last_ptr = gfc.h_ptr - 1;
        if (last_ptr == -1) {
            last_ptr = 255;
        }
        total_bytes_output.total = flushbits = gfc.header[last_ptr].write_timing - this.totbit;
        if (flushbits >= 0) {
            int remaining_headers = 1 + last_ptr - first_ptr;
            if (last_ptr < first_ptr) {
                remaining_headers = 1 + last_ptr - first_ptr + 256;
            }
            flushbits -= remaining_headers * 8 * gfc.sideinfo_len;
        }
        int bitsPerFrame = this.getframebits(gfp);
        total_bytes_output.total += bitsPerFrame;
        total_bytes_output.total = total_bytes_output.total % 8 != 0 ? 1 + total_bytes_output.total / 8 : (total_bytes_output.total /= 8);
        total_bytes_output.total += this.bufByteIdx + 1;
        if ((flushbits += bitsPerFrame) < 0) {
            System.err.println("strange error flushing buffer ... \n");
        }
        return flushbits;
    }

    public final void flush_bitstream(LameGlobalFlags gfp) {
        LameInternalFlags gfc = gfp.internal_flags;
        int last_ptr = gfc.h_ptr - 1;
        if (last_ptr == -1) {
            last_ptr = 255;
        }
        IIISideInfo l3_side = gfc.l3_side;
        int flushbits = this.compute_flushbits(gfp, new TotalBytes());
        if (flushbits < 0) {
            return;
        }
        this.drain_into_ancillary(gfp, flushbits);
        assert (gfc.header[last_ptr].write_timing + this.getframebits(gfp) == this.totbit);
        gfc.ResvSize = 0;
        l3_side.main_data_begin = 0;
        if (gfc.findReplayGain) {
            float RadioGain = this.ga.GetTitleGain(gfc.rgdata);
            assert (BitStream.NEQ(RadioGain, -24601.0f));
            gfc.RadioGain = (int)Math.floor((double)RadioGain * 10.0 + 0.5);
        }
        if (gfc.findPeakSample) {
            gfc.noclipGainChange = (int)Math.ceil(Math.log10((double)gfc.PeakSample / 32767.0) * 20.0 * 10.0);
            gfc.noclipScale = gfc.noclipGainChange > 0 ? (BitStream.EQ(gfp.scale, 1.0f) || BitStream.EQ(gfp.scale, 0.0f) ? (float)(Math.floor(32767.0 / (double)gfc.PeakSample * 100.0) / 100.0) : -1.0f) : -1.0f;
        }
    }

    public final void add_dummy_byte(LameGlobalFlags gfp, int val, int n) {
        LameInternalFlags gfc = gfp.internal_flags;
        while (n-- > 0) {
            this.putbits_noheaders(gfc, val, 8);
            for (int i = 0; i < 256; ++i) {
                gfc.header[i].write_timing += 8;
            }
        }
    }

    public final int format_bitstream(LameGlobalFlags gfp) {
        LameInternalFlags gfc = gfp.internal_flags;
        IIISideInfo l3_side = gfc.l3_side;
        int bitsPerFrame = this.getframebits(gfp);
        this.drain_into_ancillary(gfp, l3_side.resvDrain_pre);
        this.encodeSideInfo2(gfp, bitsPerFrame);
        int bits = 8 * gfc.sideinfo_len;
        bits += this.writeMainData(gfp);
        this.drain_into_ancillary(gfp, l3_side.resvDrain_post);
        l3_side.main_data_begin += (bitsPerFrame - (bits += l3_side.resvDrain_post)) / 8;
        if (this.compute_flushbits(gfp, new TotalBytes()) != gfc.ResvSize) {
            System.err.println("Internal buffer inconsistency. flushbits <> ResvSize");
        }
        if (l3_side.main_data_begin * 8 != gfc.ResvSize) {
            System.err.printf("bit reservoir error: \nl3_side.main_data_begin: %d \nResvoir size:             %d \nresv drain (post)         %d \nresv drain (pre)          %d \nheader and sideinfo:      %d \ndata bits:                %d \ntotal bits:               %d (remainder: %d) \nbitsperframe:             %d \n", 8 * l3_side.main_data_begin, gfc.ResvSize, l3_side.resvDrain_post, l3_side.resvDrain_pre, 8 * gfc.sideinfo_len, bits - l3_side.resvDrain_post - 8 * gfc.sideinfo_len, bits, bits % 8, bitsPerFrame);
            System.err.println("This is a fatal error.  It has several possible causes:");
            System.err.println("90%%  LAME compiled with buggy version of gcc using advanced optimizations");
            System.err.println(" 9%%  Your system is overclocked");
            System.err.println(" 1%%  bug in LAME encoding library");
            gfc.ResvSize = l3_side.main_data_begin * 8;
        }
        assert (this.totbit % 8 == 0);
        if (this.totbit > 1000000000) {
            for (int i = 0; i < 256; ++i) {
                gfc.header[i].write_timing -= this.totbit;
            }
            this.totbit = 0;
        }
        return 0;
    }

    public final int copy_buffer(LameInternalFlags gfc, byte[] buffer, int bufferPos, int size, int mp3data) {
        int minimum = this.bufByteIdx + 1;
        if (minimum <= 0) {
            return 0;
        }
        if (size != 0 && minimum > size) {
            return -1;
        }
        System.arraycopy(this.buf, 0, buffer, bufferPos, minimum);
        this.bufByteIdx = -1;
        this.bufBitIdx = 0;
        if (mp3data != 0) {
            int[] crc = new int[]{gfc.nMusicCRC};
            this.vbr.updateMusicCRC(crc, buffer, bufferPos, minimum);
            gfc.nMusicCRC = crc[0];
            if (minimum > 0) {
                gfc.VBR_seek_table.nBytesWritten += minimum;
            }
            if (gfc.decode_on_the_fly) {
                float[][] pcm_buf = new float[2][1152];
                int mp3_in = minimum;
                int samples_out = -1;
                while (samples_out != 0) {
                    samples_out = this.mpg.hip_decode1_unclipped(gfc.hip, buffer, bufferPos, mp3_in, pcm_buf[0], pcm_buf[1]);
                    mp3_in = 0;
                    if (samples_out == -1) {
                        samples_out = 0;
                    }
                    if (samples_out <= 0) continue;
                    assert (samples_out <= 1152);
                    if (gfc.findPeakSample) {
                        int i;
                        for (i = 0; i < samples_out; ++i) {
                            if (pcm_buf[0][i] > gfc.PeakSample) {
                                gfc.PeakSample = pcm_buf[0][i];
                                continue;
                            }
                            if (!(-pcm_buf[0][i] > gfc.PeakSample)) continue;
                            gfc.PeakSample = -pcm_buf[0][i];
                        }
                        if (gfc.channels_out > 1) {
                            for (i = 0; i < samples_out; ++i) {
                                if (pcm_buf[1][i] > gfc.PeakSample) {
                                    gfc.PeakSample = pcm_buf[1][i];
                                    continue;
                                }
                                if (!(-pcm_buf[1][i] > gfc.PeakSample)) continue;
                                gfc.PeakSample = -pcm_buf[1][i];
                            }
                        }
                    }
                    if (!gfc.findReplayGain || this.ga.AnalyzeSamples(gfc.rgdata, pcm_buf[0], 0, pcm_buf[1], 0, samples_out, gfc.channels_out) != 0) continue;
                    return -6;
                }
            }
        }
        return minimum;
    }

    public final void init_bit_stream_w(LameInternalFlags gfc) {
        this.buf = new byte[147456];
        gfc.w_ptr = 0;
        gfc.h_ptr = 0;
        gfc.header[gfc.h_ptr].write_timing = 0;
        this.bufByteIdx = -1;
        this.bufBitIdx = 0;
        this.totbit = 0;
    }

    public static boolean EQ(float a, float b) {
        return Math.abs(a) > Math.abs(b) ? Math.abs(a - b) <= Math.abs(a) * 1.0E-6f : Math.abs(a - b) <= Math.abs(b) * 1.0E-6f;
    }

    public static boolean NEQ(float a, float b) {
        return !BitStream.EQ(a, b);
    }

    public static class TotalBytes {
        public int total;
    }
}

