/*
 * Decompiled with CFR 0.152.
 */
package mp3;

import mp3.GrInfo;
import mp3.IIISideInfo;
import mp3.III_psy_ratio;
import mp3.IIterationLoop;
import mp3.LameGlobalFlags;
import mp3.LameInternalFlags;
import mp3.MeanBits;
import mp3.Quantize;

public final class VBRNewIterationLoop
implements IIterationLoop {
    private final Quantize quantize;

    VBRNewIterationLoop(Quantize quantize) {
        this.quantize = quantize;
    }

    @Override
    public final void iteration_loop(LameGlobalFlags gfp, float[][] pe, float[] ms_ener_ratio, III_psy_ratio[][] ratio) {
        int mean_bits;
        LameInternalFlags gfc = gfp.internal_flags;
        float[][][] l3_xmin = new float[2][2][39];
        float[][][] xrpow = new float[2][2][576];
        int[] frameBits = new int[15];
        int[][] max_bits = new int[2][2];
        IIISideInfo l3_side = gfc.l3_side;
        int analog_silence = this.quantize.VBR_new_prepare(gfp, pe, ratio, l3_xmin, frameBits, max_bits);
        for (int gr = 0; gr < gfc.mode_gr; ++gr) {
            for (int ch = 0; ch < gfc.channels_out; ++ch) {
                GrInfo cod_info = l3_side.tt[gr][ch];
                if (this.quantize.init_xrpow(gfc, cod_info, xrpow[gr][ch])) continue;
                max_bits[gr][ch] = 0;
            }
        }
        int used_bits = this.quantize.vbr.VBR_encode_frame(gfc, xrpow, l3_xmin, max_bits);
        if (!gfp.free_format) {
            gfc.bitrate_index = analog_silence != 0 && 0 == gfp.VBR_hard_min ? 1 : gfc.VBR_min_bitrate;
            while (gfc.bitrate_index < gfc.VBR_max_bitrate && used_bits > frameBits[gfc.bitrate_index]) {
                ++gfc.bitrate_index;
            }
            if (gfc.bitrate_index > gfc.VBR_max_bitrate) {
                gfc.bitrate_index = gfc.VBR_max_bitrate;
            }
        } else {
            gfc.bitrate_index = 0;
        }
        if (used_bits <= frameBits[gfc.bitrate_index]) {
            mean_bits = 0;
            MeanBits mb = new MeanBits(mean_bits);
            int fullframebits = this.quantize.rv.ResvFrameBegin(gfp, mb);
            mean_bits = mb.bits;
            assert (used_bits <= fullframebits);
            for (int gr = 0; gr < gfc.mode_gr; ++gr) {
                for (int ch = 0; ch < gfc.channels_out; ++ch) {
                    GrInfo cod_info = l3_side.tt[gr][ch];
                    this.quantize.rv.ResvAdjust(gfc, cod_info);
                }
            }
        } else {
            throw new RuntimeException("INTERNAL ERROR IN VBR NEW CODE, please send bug report");
        }
        this.quantize.rv.ResvFrameEnd(gfc, mean_bits);
    }
}

