/*
 * Decompiled with CFR 0.152.
 */
package net.java.truevfs.comp.zipdriver;

import edu.umd.cs.findbugs.annotations.CleanupObligation;
import edu.umd.cs.findbugs.annotations.CreatesObligation;
import edu.umd.cs.findbugs.annotations.DischargesObligation;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collections;
import java.util.Iterator;
import java.util.Objects;
import java.util.zip.CRC32;
import java.util.zip.CheckedOutputStream;
import javax.annotation.CheckForNull;
import javax.annotation.WillNotClose;
import javax.annotation.concurrent.NotThreadSafe;
import net.java.truecommons.cio.AbstractOutputSocket;
import net.java.truecommons.cio.Entry;
import net.java.truecommons.cio.InputSocket;
import net.java.truecommons.cio.IoBuffer;
import net.java.truecommons.cio.IoBufferPool;
import net.java.truecommons.cio.OutputBusyException;
import net.java.truecommons.cio.OutputService;
import net.java.truecommons.cio.OutputSocket;
import net.java.truecommons.io.DecoratingOutputStream;
import net.java.truecommons.io.DisconnectingOutputStream;
import net.java.truecommons.io.Sink;
import net.java.truecommons.io.Streams;
import net.java.truecommons.shed.CompoundIterator;
import net.java.truevfs.comp.zip.AbstractZipOutputStream;
import net.java.truevfs.comp.zip.ZipCryptoParameters;
import net.java.truevfs.comp.zip.ZipEntry;
import net.java.truevfs.comp.zipdriver.AbstractZipDriver;
import net.java.truevfs.comp.zipdriver.AbstractZipDriverEntry;
import net.java.truevfs.comp.zipdriver.ZipInputService;
import net.java.truevfs.kernel.spec.FsAccessOption;
import net.java.truevfs.kernel.spec.FsModel;
import net.java.truevfs.kernel.spec.FsOutputSocketSink;

@NotThreadSafe
public final class ZipOutputService<E extends AbstractZipDriverEntry>
extends AbstractZipOutputStream<E>
implements OutputService<E> {
    private final FsModel model;
    private final AbstractZipDriver<E> driver;
    @CheckForNull
    private IoBuffer postamble;
    @CheckForNull
    private E bufferedEntry;
    private ZipCryptoParameters param;

    @CreatesObligation
    public ZipOutputService(FsModel model, FsOutputSocketSink sink, @CheckForNull @WillNotClose ZipInputService<E> source, AbstractZipDriver<E> driver) throws IOException {
        block19: {
            super((Sink)sink, null != source && sink.getOptions().get((Enum)FsAccessOption.GROW) ? source : null, driver);
            this.driver = driver;
            try {
                this.model = Objects.requireNonNull(model);
                if (null == source) break block19;
                if (!sink.getOptions().get((Enum)FsAccessOption.GROW)) {
                    super.setComment(source.getComment());
                    if (0L < source.getPreambleLength()) {
                        try (InputStream in = source.getPreambleInputStream();){
                            Streams.cat((InputStream)in, (OutputStream)(source.offsetsConsiderPreamble() ? this : this.out));
                        }
                    }
                }
                if (0L < source.getPostambleLength()) {
                    this.postamble = (IoBuffer)this.getPool().allocate();
                    Streams.copy((InputStream)source.getPostambleInputStream(), (OutputStream)this.postamble.output().stream(null));
                }
            }
            catch (Throwable ex) {
                try {
                    super.close();
                }
                catch (Throwable ex2) {
                    ex.addSuppressed(ex2);
                }
                throw ex;
            }
        }
    }

    public FsModel getModel() {
        return this.model;
    }

    private IoBufferPool getPool() {
        return this.driver.getPool();
    }

    protected ZipCryptoParameters getCryptoParameters() {
        ZipCryptoParameters param = this.param;
        if (null == param) {
            this.param = param = this.driver.zipCryptoParameters(this);
        }
        return param;
    }

    public int size() {
        return super.size() + (null != this.bufferedEntry ? 1 : 0);
    }

    public Iterator<E> iterator() {
        E bufferedEntry = this.bufferedEntry;
        if (null == bufferedEntry) {
            return super.iterator();
        }
        return new CompoundIterator(super.iterator(), Collections.singletonList(bufferedEntry).iterator());
    }

    @CheckForNull
    public E entry(String name) {
        AbstractZipDriverEntry entry = (AbstractZipDriverEntry)super.entry(name);
        if (null != entry) {
            return (E)((Object)entry);
        }
        entry = this.bufferedEntry;
        return (E)((Object)(null != entry && name.equals(entry.getName()) ? entry : null));
    }

    public OutputSocket<E> output(E local) {
        Objects.requireNonNull(local);
        final class Output
        extends AbstractOutputSocket<E> {
            final /* synthetic */ AbstractZipDriverEntry val$local;

            Output() {
                this.val$local = abstractZipDriverEntry;
            }

            public E target() {
                return (Object)this.val$local;
            }

            public OutputStream stream(InputSocket<? extends Entry> peer) throws IOException {
                if (ZipOutputService.this.isBusy()) {
                    throw new OutputBusyException(this.val$local.getName());
                }
                if (this.val$local.isDirectory()) {
                    ZipOutputService.this.updateProperties(this.val$local, DirectoryTemplate.INSTANCE);
                    return new EntryOutputStream(ZipOutputService.this, this.val$local, false);
                }
                boolean rdc = ZipOutputService.this.updateProperties(this.val$local, Output.target(peer));
                if (0 == this.val$local.getMethod() && (-1L == this.val$local.getCrc() || -1L == this.val$local.getSize() || -1L == this.val$local.getCompressedSize())) {
                    assert (!rdc) : "The CRC-32, size and compressed size properties must be set when using RDC!";
                    return new BufferedEntryOutputStream(ZipOutputService.this, this.val$local);
                }
                return new EntryOutputStream(ZipOutputService.this, this.val$local, rdc);
            }
        }
        return new Output();
    }

    boolean updateProperties(E local, @CheckForNull Entry peer) {
        boolean rdc = false;
        if (-1L == local.getTime()) {
            local.setTime(System.currentTimeMillis());
        }
        if (null != peer) {
            AbstractZipDriverEntry zpeer;
            if (-1L == local.getSize()) {
                local.setSize(peer.getSize(Entry.Size.DATA));
            }
            if (peer instanceof AbstractZipDriverEntry && (rdc = this.driver.rdc(this, local, zpeer = (AbstractZipDriverEntry)peer))) {
                local.setPlatform(zpeer.getPlatform());
                local.setEncrypted(zpeer.isEncrypted());
                local.setMethod(zpeer.getMethod());
                local.setCrc(zpeer.getCrc());
                local.setSize(zpeer.getSize());
                local.setCompressedSize(zpeer.getCompressedSize());
                local.setExtra(zpeer.getExtra());
            }
        }
        if (0L == local.getSize()) {
            rdc = false;
            local.clearEncryption();
            local.setMethod(0);
            local.setCrc(0L);
            local.setCompressedSize(0L);
        }
        return rdc;
    }

    public boolean isBusy() {
        return super.isBusy() || null != this.bufferedEntry;
    }

    public void close() throws IOException {
        super.finish();
        IoBuffer postamble = this.postamble;
        if (null != postamble) {
            this.postamble = null;
            InputSocket input = postamble.input();
            Throwable ex = null;
            try (InputStream in = input.stream(null);){
                long ol = this.length();
                long ipl = input.target().getSize(Entry.Size.DATA);
                if ((ol + ipl) % 4L != 0L) {
                    this.write(new byte[4 - (int)(ol % 4L)]);
                }
                Streams.cat((InputStream)in, (OutputStream)((Object)this));
            }
            catch (Throwable ex2) {
                ex = ex2;
                throw ex2;
            }
            finally {
                try {
                    postamble.release();
                }
                catch (Throwable ex2) {
                    if (null == ex) {
                        throw ex2;
                    }
                    ex.addSuppressed(ex2);
                }
            }
        }
        super.close();
    }

    @CleanupObligation
    private static final class BufferedEntryOutputStream
    extends DecoratingOutputStream {
        final IoBuffer buffer;
        final E local;
        boolean closed;
        final /* synthetic */ ZipOutputService this$0;

        @CreatesObligation
        BufferedEntryOutputStream(E local) throws IOException {
            this.this$0 = var1_1;
            assert (0 == local.getMethod());
            this.local = local;
            IoBuffer buffer = this.buffer = (IoBuffer)((ZipOutputService)var1_1).getPool().allocate();
            try {
                this.out = new CheckedOutputStream(buffer.output().stream(null), new CRC32());
            }
            catch (Throwable ex) {
                try {
                    buffer.release();
                }
                catch (Throwable ex2) {
                    ex.addSuppressed(ex2);
                }
                throw ex;
            }
            ((ZipOutputService)var1_1).bufferedEntry = local;
        }

        @DischargesObligation
        public void close() throws IOException {
            if (this.closed) {
                return;
            }
            this.closed = true;
            this.this$0.bufferedEntry = null;
            this.out.close();
            this.updateProperties();
            this.storeBuffer();
        }

        void updateProperties() {
            Object local = this.local;
            IoBuffer buffer = this.buffer;
            local.setCrc(((CheckedOutputStream)this.out).getChecksum().getValue());
            long length = buffer.getSize(Entry.Size.DATA);
            local.setSize(length);
            local.setCompressedSize(length);
            this.this$0.updateProperties(local, (Entry)buffer);
        }

        void storeBuffer() throws IOException {
            IoBuffer buffer = this.buffer;
            Throwable t1 = null;
            try (InputStream in = buffer.input().stream(null);){
                ZipOutputService zos = this.this$0;
                zos.putNextEntry((ZipEntry)this.local, true);
                Streams.cat((InputStream)in, (OutputStream)((Object)zos));
                zos.closeEntry();
            }
            catch (Throwable t2) {
                t1 = t2;
                throw t2;
            }
            finally {
                try {
                    buffer.release();
                }
                catch (Throwable t2) {
                    if (null == t1) {
                        throw t2;
                    }
                    t1.addSuppressed(t2);
                }
            }
        }
    }

    @CleanupObligation
    private final class EntryOutputStream
    extends DisconnectingOutputStream {
        boolean closed;
        final /* synthetic */ ZipOutputService this$0;

        /*
         * WARNING - Possible parameter corruption
         */
        @CreatesObligation
        EntryOutputStream(E local, boolean rdc) throws IOException {
            this.this$0 = (ZipOutputService)n;
            super((OutputStream)n);
            n.putNextEntry(local, !rdc);
        }

        public boolean isOpen() {
            return !this.closed;
        }

        @DischargesObligation
        public void close() throws IOException {
            if (this.closed) {
                return;
            }
            this.closed = true;
            this.this$0.closeEntry();
        }
    }

    private static final class DirectoryTemplate
    implements Entry {
        static final DirectoryTemplate INSTANCE = new DirectoryTemplate();

        private DirectoryTemplate() {
        }

        public String getName() {
            return "/";
        }

        public long getSize(Entry.Size type) {
            return 0L;
        }

        public long getTime(Entry.Access type) {
            return -1L;
        }

        @SuppressFBWarnings(value={"NP_BOOLEAN_RETURN_NULL"})
        public Boolean isPermitted(Entry.Access type, Entry.Entity entity) {
            return null;
        }
    }
}

