/*
 * Decompiled with CFR 0.152.
 */
package kickass.nonasm.tools;

import java.util.HashMap;
import java.util.Map;

public class StringUtil {
    private static String spaces = "                                                                                                                ";
    private static String minuses = "---------------------------------------------------------------------------------------------------------------";
    private static Map<Character, String> xmlEscapes;

    public static String centerPad(int n, String string) {
        int n2 = n - string.length();
        if (n2 < 0) {
            return string;
        }
        int n3 = n2 / 2;
        int n4 = n2 - n3;
        return StringUtil.repeat(n3, ' ') + string + StringUtil.repeat(n4, ' ');
    }

    public static String repeat(int n, char c) {
        if (c == ' ' && n <= spaces.length()) {
            return spaces.substring(0, n);
        }
        if (c == '-' && n <= minuses.length()) {
            return minuses.substring(0, n);
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < n; ++i) {
            stringBuffer.append(c);
        }
        return stringBuffer.toString();
    }

    public static String toHex(int n) {
        return String.format("$%04x", n);
    }

    public static String escapeXml(String string) {
        int n;
        for (n = 0; n < string.length() && StringUtil.replaceXmlChar(string.charAt(n)) == null; ++n) {
        }
        if (n >= string.length()) {
            return string;
        }
        StringBuilder stringBuilder = new StringBuilder();
        int n2 = 0;
        while (n < string.length()) {
            String string2 = StringUtil.replaceXmlChar(string.charAt(n));
            if (string2 != null) {
                if (n2 < n) {
                    stringBuilder.append(string.substring(n2, n));
                }
                stringBuilder.append(string2);
                n2 = n + 1;
            }
            ++n;
        }
        if (n2 < n) {
            stringBuilder.append(string.substring(n2, n));
        }
        return stringBuilder.toString();
    }

    private static String replaceXmlChar(char c) {
        String string = xmlEscapes.get(Character.valueOf(c));
        return string;
    }

    static {
        HashMap<Character, String> hashMap = new HashMap<Character, String>();
        hashMap.put(Character.valueOf('\"'), "&quot;");
        hashMap.put(Character.valueOf('&'), "&amp;");
        hashMap.put(Character.valueOf('<'), "&lt;");
        hashMap.put(Character.valueOf('>'), "&gt;");
        hashMap.put(Character.valueOf('\''), "&apos;");
        hashMap.put(Character.valueOf('\u0000'), "");
        hashMap.put(Character.valueOf('\u000b'), "&#11;");
        hashMap.put(Character.valueOf('\f'), "&#12;");
        hashMap.put(Character.valueOf('\ufffe'), "");
        hashMap.put(Character.valueOf('\uffff'), "");
        xmlEscapes = hashMap;
    }
}

