/*
 * Decompiled with CFR 0.152.
 */
package sidplay.audio.processors.reverb;

public class CombFilter {
    private int sampleBufferSize;
    private int sampleRate;
    private int numberOfChannels;
    private double delayInMs;
    private double sustainTimeInMs;
    private double gain;
    private int sustainSampleCount;
    private double[] delayBuffer;
    private int delayBufferSize;
    private int writeIndex;
    private int readIndex;

    public CombFilter(int sampleRate, int numberOfChannels, double delayInMs, int sampleBufferSize) {
        this.sampleRate = sampleRate;
        this.numberOfChannels = numberOfChannels;
        this.sampleBufferSize = sampleBufferSize;
        this.gain = 0.0;
        this.sustainTimeInMs = 500.0;
        this.setDelayInMs(delayInMs);
    }

    public double getDelayInMs() {
        return this.delayInMs;
    }

    public void setDelayInMs(double delayInMs) {
        this.delayInMs = delayInMs;
        int delayOffset = (int)((delayInMs + 0.5) * (double)this.sampleRate * (double)this.numberOfChannels) / 1000;
        this.delayBufferSize = this.sampleBufferSize + delayOffset;
        this.delayBuffer = new double[this.delayBufferSize];
        this.writeIndex = 0;
        this.readIndex = this.sampleBufferSize;
        this.calcGain();
    }

    public void calcGain() {
        this.gain = Math.pow(0.001, this.delayInMs / this.sustainTimeInMs);
    }

    public double getSustainTimeInMs() {
        return this.sustainTimeInMs;
    }

    public void setSustainTimeInMs(double sustainTimeInMs) {
        this.sustainTimeInMs = sustainTimeInMs;
        this.sustainSampleCount = (int)(sustainTimeInMs * (double)this.sampleRate * (double)this.numberOfChannels / 1000.0);
        this.calcGain();
    }

    public int doFilter(short[] inBuf, double[] outBuf, int length) {
        if (length != -1) {
            for (int i = 0; i < length; ++i) {
                double sample = inBuf[i];
                double delaySample = this.delayBuffer[this.readIndex++];
                int n = i;
                outBuf[n] = outBuf[n] + delaySample;
                this.delayBuffer[this.writeIndex++] = sample += delaySample * this.gain;
                if (this.readIndex == this.delayBufferSize) {
                    this.readIndex = 0;
                }
                if (this.writeIndex != this.delayBufferSize) continue;
                this.writeIndex = 0;
            }
            return length;
        }
        int samplesToMove = Math.min(outBuf.length, this.sustainSampleCount);
        if (samplesToMove <= 0) {
            return -1;
        }
        for (int i = 0; i < samplesToMove; ++i) {
            double delaySample = this.delayBuffer[this.readIndex++];
            int n = i;
            outBuf[n] = outBuf[n] + delaySample;
            this.delayBuffer[this.writeIndex++] = delaySample *= this.gain;
            if (this.readIndex == this.delayBufferSize) {
                this.readIndex = 0;
            }
            if (this.writeIndex == this.delayBufferSize) {
                this.writeIndex = 0;
            }
            --this.sustainSampleCount;
        }
        return samplesToMove;
    }
}

