/*
 * Decompiled with CFR 0.152.
 */
package kickass.pass.expressions.refexpr;

import kickass.common.diagnostics.AsmError;
import kickass.parsing.sourcelocation.SourceRange;
import kickass.pass.expressions.refexpr.IReferenceExpr;
import kickass.pass.expressions.refexpr.ReferenceOperation;
import kickass.pass.valueholder.IValueHolder;
import kickass.state.EvaluationState;
import kickass.state.ScopePosition;
import kickass.state.scope.symboltable.ISymbolPageIdx;
import kickass.state.scope.symboltable.SymbolStatus;

public class SymbolReferenceExpr
implements IReferenceExpr {
    private boolean isRootScope;
    private String name;
    private SourceRange range;
    private ISymbolPageIdx symbolPageIdx;

    public SymbolReferenceExpr(String string, SourceRange sourceRange) {
        this.range = sourceRange;
        this.isRootScope = string.startsWith("@");
        this.name = this.isRootScope ? string.substring(1) : string;
    }

    @Override
    public SourceRange getSourceRange() {
        return this.range;
    }

    @Override
    public void executePrepass(EvaluationState evaluationState, ReferenceOperation referenceOperation) {
        this.symbolPageIdx = evaluationState.scopeMgr.getRootOrCurrentScope(this.isRootScope).get(this.name);
        if (this.symbolPageIdx == null) {
            evaluationState.diagnosticMgr.add(new AsmError("Unknown symbol '" + this.name + "'", this.range));
        } else if (this.symbolPageIdx.getStatus() == SymbolStatus.undefined) {
            boolean bl;
            ScopePosition scopePosition = this.symbolPageIdx.getScopePosition();
            ScopePosition scopePosition2 = evaluationState.scopeMgr.getCurrentScope().getScopePosition();
            boolean bl2 = bl = scopePosition2 != ScopePosition.inNamespace && scopePosition != scopePosition2;
            if (!bl) {
                evaluationState.diagnosticMgr.add(new AsmError("Reference to not yet defined symbol '" + this.name + "'", this.range));
            }
        }
    }

    @Override
    public IValueHolder getValueHolder(EvaluationState evaluationState) {
        return this.symbolPageIdx.getValueHolder();
    }
}

