/*
 * Decompiled with CFR 0.152.
 */
package kickass.parsing.mainparse.tailparsers;

import java.io.IOException;
import java.util.List;
import java.util.function.BiFunction;
import kickass.common.diagnostics.AsmError;
import kickass.parsing.baselang.tokens.IToken;
import kickass.parsing.baselang.tokenstreams.ITokenStream;
import kickass.parsing.baselang.tokenstreams.TokenStreamList;
import kickass.parsing.mainparse.tailparsers.ITailParser;
import kickass.parsing.script.ExprParser;
import kickass.parsing.sourcelocation.SourceRange;
import kickass.pass.expressions.expr.ExprNode;
import kickass.state.EvaluationState;

public class ExprListTailParser<NODE>
implements ITailParser<NODE> {
    private Integer fixedNoOfArgs = null;
    private BiFunction<List<ExprNode>, SourceRange, NODE> nodeCreator;

    public ExprListTailParser(BiFunction<List<ExprNode>, SourceRange, NODE> biFunction) {
        this.nodeCreator = biFunction;
    }

    public ExprListTailParser<NODE> setFixedNoOfArgs(Integer n) {
        this.fixedNoOfArgs = n;
        return this;
    }

    @Override
    public NODE parse(IToken iToken, SourceRange sourceRange, ITokenStream iTokenStream, EvaluationState evaluationState) throws IOException {
        boolean bl;
        TokenStreamList tokenStreamList = iTokenStream.getUntilSemiOrNlSkipWs();
        List<ExprNode> list = ExprParser.parseOptExprList(tokenStreamList, evaluationState);
        if (list == null) {
            return null;
        }
        boolean bl2 = bl = this.fixedNoOfArgs != null && list.size() != this.fixedNoOfArgs.intValue();
        if (bl) {
            evaluationState.diagnosticMgr.add(new AsmError("Invalid number of arguments.", sourceRange));
            return null;
        }
        return this.nodeCreator.apply(list, sourceRange);
    }
}

