/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene.control;

import javafx.beans.property.ReadOnlyIntegerProperty;
import javafx.beans.property.ReadOnlyIntegerWrapper;
import javafx.css.PseudoClass;
import javafx.scene.control.Cell;

public class IndexedCell<T>
extends Cell<T> {
    private int oldIndex = -1;
    private ReadOnlyIntegerWrapper index = new ReadOnlyIntegerWrapper(this, "index", -1){

        protected void invalidated() {
            int n = this.get();
            boolean bl = n % 2 == 0;
            IndexedCell.this.pseudoClassStateChanged(PSEUDO_CLASS_EVEN, bl);
            IndexedCell.this.pseudoClassStateChanged(PSEUDO_CLASS_ODD, !bl);
            IndexedCell.this.indexChanged(IndexedCell.this.oldIndex, n);
        }
    };
    private static final String DEFAULT_STYLE_CLASS = "indexed-cell";
    private static final PseudoClass PSEUDO_CLASS_ODD = PseudoClass.getPseudoClass((String)"odd");
    private static final PseudoClass PSEUDO_CLASS_EVEN = PseudoClass.getPseudoClass((String)"even");

    public IndexedCell() {
        this.getStyleClass().addAll((Object[])new String[]{DEFAULT_STYLE_CLASS});
    }

    public final int getIndex() {
        return this.index.get();
    }

    public final ReadOnlyIntegerProperty indexProperty() {
        return this.index.getReadOnlyProperty();
    }

    public void updateIndex(int n) {
        this.oldIndex = this.index.get();
        if (this.oldIndex == n) {
            this.indexChanged(this.oldIndex, n);
        } else {
            this.index.set(n);
        }
    }

    void indexChanged(int n, int n2) {
    }
}

