/*
 * Decompiled with CFR 0.152.
 */
package server.restful.common.parameter;

import com.beust.jcommander.Parameter;
import com.beust.jcommander.Parameters;
import com.beust.jcommander.ParametersDelegate;
import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.introspect.ClassIntrospector;
import com.fasterxml.jackson.databind.ser.FilterProvider;
import com.fasterxml.jackson.databind.ser.PropertyWriter;
import com.fasterxml.jackson.databind.ser.impl.SimpleBeanPropertyFilter;
import com.fasterxml.jackson.databind.ser.impl.SimpleFilterProvider;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CodingErrorAction;
import java.nio.charset.StandardCharsets;
import java.util.AbstractMap;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import libsidplay.common.ChipModel;
import libsidplay.common.Emulation;
import libsidutils.IOUtils;
import org.hibernate.type.descriptor.java.LocaleTypeDescriptor;
import server.restful.servlets.ConvertServlet;
import sidplay.ini.IniDefaults;

public class ServletParameterHelper {
    private static final Logger LOG = Logger.getLogger(ServletParameterHelper.class.getName());
    private static final ResourceBundle ERRORS = ResourceBundle.getBundle("server.restful.common.parameter.ServletParameterHelper");
    public static final List<Locale> SUPPORTED_LOCALES = Collections.unmodifiableList(Arrays.asList(Locale.ROOT, Locale.GERMAN));
    public static final String CONVERT_OPTIONS;
    public static final String FILTER_NAMES_RESID_MOS6581;
    public static final String FILTER_NAMES_RESID_MOS8580;
    public static final String FILTER_NAMES_RESIDFP_MOS6581;
    public static final String FILTER_NAMES_RESIDFP_MOS8580;
    public static final Map<Locale, String> CONVERT_MESSAGES;
    public static final int OPTION_MAX_LENGTH = 1;
    public static final int GNU_OPTION_MIN_LENGTH = 2;
    private static final String FILTER_NAME = "localizer";

    public static void check(Class<?> servletParameterClass, boolean servletParameter) throws ExceptionInInitializerError {
        try {
            LOG.info(servletParameterClass.getName());
            Optional.ofNullable(servletParameterClass.getAnnotation(Parameters.class)).orElseThrow(() -> new IllegalAccessException(String.format(ERRORS.getString("CHECKED_CLASS_MUST_BE_ANNOTATED_WITH_PARAMETERS"), servletParameterClass)));
            if (servletParameterClass.getAnnotation(Parameters.class).resourceBundle().isEmpty()) {
                throw new IllegalAccessException(String.format(ERRORS.getString("RESOURCE_BUNDLE_ATTR_MISSING"), servletParameterClass));
            }
            Constructor<?> declaredConstructor = servletParameterClass.getDeclaredConstructor(new Class[0]);
            declaredConstructor.setAccessible(true);
            BeanParameterChecker beanParameterChecker = new BeanParameterChecker(servletParameter);
            ServletParameterHelper.createObjectMapper(beanParameterChecker).writeValueAsString(declaredConstructor.newInstance(new Object[0]));
            if (servletParameterClass.getAnnotation(Parameters.class).commandDescriptionKey() == null && !beanParameterChecker.hasUsage) {
                throw new ExceptionInInitializerError(String.format(ERRORS.getString("CHECKED_CLASS_IS_MISSING_A_USAGE"), servletParameterClass));
            }
        }
        catch (JsonProcessingException | IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            throw new ExceptionInInitializerError(e);
        }
    }

    private static ObjectMapper createObjectMapper(SimpleBeanPropertyFilter filter) {
        return new ObjectMapper().setMixInResolver(new ClassIntrospector.MixInResolver(){

            public Class<?> findMixInClassFor(Class<?> cls) {
                return FilteredMixIn.class;
            }

            public ClassIntrospector.MixInResolver copy() {
                return this;
            }
        }).setFilterProvider((FilterProvider)new SimpleFilterProvider().addFilter(FILTER_NAME, filter));
    }

    static {
        try {
            ObjectMapper objectMapper = new ObjectMapper();
            CONVERT_OPTIONS = objectMapper.writeValueAsString((Object)new ConvertServlet.ConvertServletParameters());
            FILTER_NAMES_RESID_MOS6581 = objectMapper.writeValueAsString(IniDefaults.DEFAULTS.getFilterNames(Emulation.RESID, ChipModel.MOS6581));
            FILTER_NAMES_RESID_MOS8580 = objectMapper.writeValueAsString(IniDefaults.DEFAULTS.getFilterNames(Emulation.RESID, ChipModel.MOS8580));
            FILTER_NAMES_RESIDFP_MOS6581 = objectMapper.writeValueAsString(IniDefaults.DEFAULTS.getFilterNames(Emulation.RESIDFP, ChipModel.MOS6581));
            FILTER_NAMES_RESIDFP_MOS8580 = objectMapper.writeValueAsString(IniDefaults.DEFAULTS.getFilterNames(Emulation.RESIDFP, ChipModel.MOS8580));
            HashMap<Locale, String> convertMessages = new HashMap<Locale, String>();
            for (Locale locale : SUPPORTED_LOCALES) {
                convertMessages.put(locale, ServletParameterHelper.createObjectMapper(new BeanParameterLocalizer(locale)).writeValueAsString((Object)new ConvertServlet.ConvertServletParameters()));
            }
            CONVERT_MESSAGES = Collections.unmodifiableMap(convertMessages);
        }
        catch (JsonProcessingException e) {
            throw new ExceptionInInitializerError(e);
        }
    }

    private static final class BeanParameterChecker
    extends SimpleBeanPropertyFilter {
        private static final LocaleTypeDescriptor.LocaleComparator LOCALE_COMPARATOR = new LocaleTypeDescriptor.LocaleComparator();
        private static final ResourceBundle.Control CONTROL = ResourceBundle.Control.getControl(ResourceBundle.Control.FORMAT_PROPERTIES);
        private static final CharsetDecoder US_ASCII_DECODER = StandardCharsets.US_ASCII.newDecoder().onMalformedInput(CodingErrorAction.REPORT);
        private final Set<Integer> orders = new HashSet<Integer>();
        private final Set<String> checkedResourceBundles = new HashSet<String>();
        private final boolean servletParameter;
        private boolean hasUsage;

        private BeanParameterChecker(boolean servletParameter) {
            this.servletParameter = servletParameter;
        }

        public void serializeAsField(Object pojo, JsonGenerator jgen, SerializerProvider prov, PropertyWriter writer) throws Exception {
            Parameters parameters = pojo.getClass().getAnnotation(Parameters.class);
            Parameter parameter = (Parameter)writer.getAnnotation(Parameter.class);
            if (parameter != null) {
                if (parameter.help()) {
                    this.hasUsage = true;
                }
                if (!this.orders.add(parameter.order())) {
                    throw JsonMappingException.from((SerializerProvider)prov, (String)String.format(ERRORS.getString("AMBIGUOUS_ORDER"), parameter.order()));
                }
                if (this.servletParameter) {
                    for (String name : parameter.names()) {
                        if (name.startsWith("--")) {
                            if (name.length() >= "--".length() + 2) continue;
                            throw JsonMappingException.from((SerializerProvider)prov, (String)ERRORS.getString("GNU_OPTION_MIN_LENGTH_ERROR"));
                        }
                        if (name.startsWith("-")) {
                            if (name.length() <= "-".length() + 1) continue;
                            throw JsonMappingException.from((SerializerProvider)prov, (String)ERRORS.getString("OPTION_MAX_LENGTH_ERROR"));
                        }
                        throw JsonMappingException.from((SerializerProvider)prov, (String)ERRORS.getString("OPTION_PREFIX_ERROR"));
                    }
                    if (Stream.of(Boolean.class, Boolean.TYPE).anyMatch(writer.getType().getRawClass()::equals) && parameter.arity() != 1) {
                        throw JsonMappingException.from((SerializerProvider)prov, (String)String.format(ERRORS.getString("BOOLEAN_ARITY_ERROR"), parameter.arity()));
                    }
                }
                ResourceBundle rootResourceBundle = null;
                for (Locale locale : SUPPORTED_LOCALES.stream().sorted(LOCALE_COMPARATOR).collect(Collectors.toList())) {
                    this.checkEncoding(parameters.resourceBundle(), locale);
                    ResourceBundle resourceBundle = ResourceBundle.getBundle(parameters.resourceBundle(), locale);
                    if (locale == Locale.ROOT) {
                        rootResourceBundle = resourceBundle;
                    }
                    if (parameter.descriptionKey().isEmpty()) {
                        throw JsonMappingException.from((SerializerProvider)prov, (String)String.format(ERRORS.getString("DESCRIPTION_KEY_ATTR_MISSING"), pojo.getClass()));
                    }
                    this.throwIfLocalizationMissing(prov, resourceBundle, rootResourceBundle, parameter.descriptionKey());
                    if (!this.servletParameter) continue;
                    if (parameter.help()) {
                        this.throwIfLocalizationMissing(prov, resourceBundle, rootResourceBundle, "USAGE_DESCRIPTION");
                        if (locale == Locale.ROOT) {
                            this.throwIfLocalizationMissing(prov, resourceBundle, rootResourceBundle, "USAGE_LONG_DESCRIPTION");
                            this.throwIfLocalizationMissing(prov, resourceBundle, rootResourceBundle, "EXAMPLE_REQUEST_SERVLET_PATH");
                            this.throwIfLocalizationMissing(prov, resourceBundle, rootResourceBundle, "EXAMPLE_REQUEST_PATH");
                        }
                    }
                    if (parameter.names().length != 0) continue;
                    this.throwIfLocalizationMissing(prov, resourceBundle, rootResourceBundle, "EXAMPLE_REQUEST_PATH");
                }
            } else if (writer.getAnnotation(ParametersDelegate.class) != null) {
                super.serializeAsField(pojo, jgen, prov, writer);
            }
        }

        private void throwIfLocalizationMissing(SerializerProvider prov, ResourceBundle resourceBundle, ResourceBundle rootResourceBundle, String key) throws JsonMappingException {
            String bundleName = CONTROL.toBundleName(resourceBundle.getBaseBundleName(), resourceBundle.getLocale());
            if (!this.isKeyOfBundle(resourceBundle, rootResourceBundle, key)) {
                throw JsonMappingException.from((SerializerProvider)prov, (String)String.format(ERRORS.getString("LOCALIZATION_MISSING"), bundleName, key));
            }
        }

        private boolean isKeyOfBundle(ResourceBundle resourceBundle, ResourceBundle rootResourceBundle, String key) {
            return resourceBundle.getLocale() == Locale.ROOT ? resourceBundle.containsKey(key) : resourceBundle.getString(key) != rootResourceBundle.getString(key);
        }

        private void checkEncoding(String resourceBundleName, Locale locale) throws IOException, Exception {
            String bundleName = CONTROL.toBundleName(resourceBundleName, locale);
            String resourceName = CONTROL.toResourceName(bundleName, "properties");
            if (this.checkedResourceBundles.add(resourceName)) {
                LOG.fine(String.format("Check encoding of %s", resourceName));
                Buffer byteBuffer = null;
                byte[] byteArray = null;
                try {
                    InputStream resourceAsStream = ((Object)((Object)this)).getClass().getResourceAsStream("/" + resourceName);
                    if (resourceAsStream == null) {
                        throw new FileNotFoundException(resourceName);
                    }
                    byteArray = IOUtils.readAllBytes(resourceAsStream);
                    byteBuffer = ByteBuffer.wrap(byteArray);
                    US_ASCII_DECODER.decode((ByteBuffer)byteBuffer);
                }
                catch (CharacterCodingException e) {
                    Map.Entry<Integer, Integer> lineColumn = this.getLineColumn(byteArray, byteBuffer.position());
                    LOG.log(Level.SEVERE, String.format(ERRORS.getString("ILLEGAL_CHARACTERS_IN_RESOURCE_NAME"), resourceName, lineColumn.getKey(), lineColumn.getValue()), e);
                    throw e;
                }
                catch (IOException e) {
                    LOG.log(Level.SEVERE, String.format(ERRORS.getString("CHECK_ENCODING_FAILED"), resourceName), e);
                    throw e;
                }
            }
        }

        private Map.Entry<Integer, Integer> getLineColumn(byte[] byteArray, int bytePosition) {
            int currentPos = 0;
            int colNo = 1;
            int lineNo = 1;
            for (byte b : byteArray) {
                if (currentPos == bytePosition) break;
                if (b == 10) {
                    ++lineNo;
                    colNo = 0;
                }
                ++colNo;
                ++currentPos;
            }
            return new AbstractMap.SimpleEntry<Integer, Integer>(lineNo, colNo);
        }
    }

    private static final class BeanParameterLocalizer
    extends SimpleBeanPropertyFilter {
        private final Locale locale;

        private BeanParameterLocalizer(Locale locale) {
            this.locale = locale;
        }

        public void serializeAsField(Object pojo, JsonGenerator jgen, SerializerProvider prov, PropertyWriter writer) throws Exception {
            Parameters parameters = pojo.getClass().getAnnotation(Parameters.class);
            Parameter parameter = (Parameter)writer.getAnnotation(Parameter.class);
            if (parameters != null && parameter != null && !parameters.resourceBundle().isEmpty()) {
                ResourceBundle resBundle = ResourceBundle.getBundle(parameters.resourceBundle(), this.locale);
                jgen.writeStringField(writer.getName(), resBundle.getString(parameter.descriptionKey()));
            } else if (writer.getAnnotation(ParametersDelegate.class) != null) {
                super.serializeAsField(pojo, jgen, prov, writer);
            }
        }
    }

    @JsonFilter(value="localizer")
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY, getterVisibility=JsonAutoDetect.Visibility.ANY, setterVisibility=JsonAutoDetect.Visibility.ANY)
    private final class FilteredMixIn {
        private FilteredMixIn() {
        }
    }
}

