/*
 * Decompiled with CFR 0.152.
 */
package sidplay.fingerprinting;

import builder.resid.resample.Resampler;
import java.io.IOException;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Random;
import libsidplay.common.SamplingMethod;
import libsidplay.common.SamplingRate;
import libsidutils.fingerprinting.IFingerprintMatcher;
import libsidutils.fingerprinting.rest.beans.MusicInfoWithConfidenceBean;
import libsidutils.fingerprinting.rest.beans.WAVBean;
import sidplay.audio.wav.WAVHeader;

public final class WhatsSidSupport {
    private static final int CHANNELS = 1;
    private final Resampler downSampler;
    private final Random RANDOM = new Random();
    private int oldRandomValue;
    private ByteBuffer whatsSidBuffer;
    private int whatsSidBufferSize;
    private volatile MusicInfoWithConfidenceBean lastWhatsSidMatch;
    private double minimumRelativeConfidence;

    public WhatsSidSupport(double cpuFrequency, int captureTimeInS, double minimumRelativeConfidence) {
        this.downSampler = Resampler.createResampler(cpuFrequency, SamplingMethod.RESAMPLE, SamplingRate.VERY_LOW.getFrequency(), SamplingRate.VERY_LOW.getMiddleFrequency());
        this.whatsSidBufferSize = 2 * SamplingRate.VERY_LOW.getFrequency() * captureTimeInS;
        this.whatsSidBuffer = ByteBuffer.allocateDirect(this.whatsSidBufferSize).order(ByteOrder.LITTLE_ENDIAN);
        this.minimumRelativeConfidence = minimumRelativeConfidence;
    }

    public boolean output(int valL, int valR) {
        int dither = this.triangularDithering();
        if (this.downSampler.input(valL + valR >> 1) && !this.whatsSidBuffer.putShort((short)Math.max(Math.min(this.downSampler.output() + dither, Short.MAX_VALUE), Short.MIN_VALUE)).hasRemaining()) {
            ((Buffer)this.whatsSidBuffer).clear();
            return true;
        }
        return false;
    }

    public MusicInfoWithConfidenceBean match(IFingerprintMatcher matcher) throws IOException {
        MusicInfoWithConfidenceBean result;
        byte[] wav = this.createWAV();
        if (wav.length > 0 && (result = matcher.match(new WAVBean(wav))) != null && !result.equals(this.lastWhatsSidMatch) && result.getRelativeConfidence() > this.minimumRelativeConfidence) {
            this.lastWhatsSidMatch = result;
            return result;
        }
        return null;
    }

    public void reset() {
        ((Buffer)this.whatsSidBuffer).clear();
        ((Buffer)this.whatsSidBuffer.put(new byte[this.whatsSidBufferSize])).clear();
        this.lastWhatsSidMatch = null;
    }

    private int triangularDithering() {
        int prevValue = this.oldRandomValue;
        this.oldRandomValue = this.RANDOM.nextInt() & 1;
        return this.oldRandomValue - prevValue;
    }

    public byte[] createWAV() {
        ByteBuffer result = ByteBuffer.allocate(44 + this.whatsSidBufferSize).order(ByteOrder.LITTLE_ENDIAN);
        WAVHeader wavHeader = new WAVHeader(1, SamplingRate.VERY_LOW.getFrequency());
        wavHeader.advance(this.whatsSidBufferSize);
        result.put(wavHeader.getBytes());
        ByteBuffer copy = this.whatsSidBuffer.asReadOnlyBuffer();
        ((Buffer)copy).mark();
        result.put(copy);
        ((Buffer)copy).reset();
        ((Buffer)copy).flip();
        result.put(copy);
        return result.array();
    }
}

