/*
 * Decompiled with CFR 0.152.
 */
package builder.resid.residfp;

import builder.resid.residfp.Filter;
import builder.resid.residfp.SID;

public final class Filter6581
extends Filter {
    private float attenuation;
    private float nonlinearity;
    private float baseresistance;
    private float offset;
    private float steepness;
    private float minimumfetresistance;
    private float voiceNonlinearity;
    private static final double SIDCAPS_6581 = 4.7E-10;
    private static final float OSC_TO_FC = 0.001953125f;
    private float[][] type3_w0s = new float[1024][];
    private float[] type3_w0;
    private static final float TYPE3_W0S_RESOLUTION = 2.0E-4f;

    protected Filter6581() {
        for (int i = 0; i < 1024; ++i) {
            this.type3_w0s[i] = new float[256];
        }
        this.setCurveAndDistortionDefaults();
    }

    private float type3_w0(float dist) {
        if (dist < 0.0f) {
            return this.type3_w0[0];
        }
        int index = (int)(dist * 2.0E-4f);
        return this.type3_w0[index < 256 ? index : 255];
    }

    private float waveshaper1(float value) {
        if (value > this.nonlinearity) {
            value -= (value - this.nonlinearity) * 0.5f;
        }
        return value;
    }

    public float estimateCurrentDistortion() {
        return this.type3_w0(this.Vhp) + this.type3_w0(this.Vbp) - 2.0f * this.type3_w0(0.0f);
    }

    @Override
    protected float clock(float voice1, float voice2, float voice3, float ext_in) {
        float Vi = 0.0f;
        float Vf = 0.0f;
        if (this.filt1) {
            Vi += voice1;
        } else {
            Vf += voice1;
        }
        if (this.filt2) {
            Vi += voice2;
        } else {
            Vf += voice2;
        }
        if (this.filt3) {
            Vi += voice3;
        } else if (this.voice3off) {
            Vf += voice3;
        }
        if (this.filtE) {
            Vi += ext_in;
        } else {
            Vf += ext_in;
        }
        this.Vlp -= this.Vbp * this.type3_w0(this.Vbp);
        this.Vbp -= this.Vhp * this.type3_w0(this.Vhp);
        this.Vhp = (this.Vbp * this._1_div_Q - this.Vlp - Vi) * this.attenuation;
        if (this.lp) {
            Vf += this.Vlp;
        }
        if (this.bp) {
            Vf += this.Vbp;
        }
        if (this.hp) {
            Vf += this.Vhp;
        }
        return this.waveshaper1(Vf * this.vol);
    }

    public void setNonLinearity(float nl) {
        this.voiceNonlinearity = nl;
        this.recalculate();
        this.updatedCenterFrequency();
    }

    @Override
    public void setCurveAndDistortionDefaults() {
        this.setDistortionProperties(0.64f, 3300000.0f, 1.0f);
        this.setCurveProperties(1147036.5f, 2.742288E8f, 1.0066634f, 16125.155f);
        this.setNonLinearity(0.96131605f);
    }

    @Override
    protected void setClockFrequency(double clock) {
        super.setClockFrequency(clock);
        this.recalculate();
        this.updatedCenterFrequency();
    }

    @Override
    public float[] getDistortionProperties() {
        return new float[]{this.attenuation, this.nonlinearity, this.resonanceFactor};
    }

    @Override
    public void setDistortionProperties(float a, float nl, float rf) {
        this.attenuation = a;
        this.nonlinearity = nl;
        this.resonanceFactor = rf;
        this.updatedResonance();
    }

    @Override
    public float[] getCurveProperties() {
        return new float[]{this.baseresistance, this.offset, this.steepness, this.minimumfetresistance};
    }

    @Override
    public void setCurveProperties(float br, float o, float s, float mfr) {
        this.baseresistance = br;
        this.offset = o;
        this.steepness = s;
        this.minimumfetresistance = mfr;
        this.recalculate();
        this.updatedCenterFrequency();
    }

    @Override
    protected void updatedCenterFrequency() {
        this.type3_w0 = this.type3_w0s[this.fc >> 1];
    }

    private void recalculate() {
        float[] fcBase = new float[1024];
        for (int j = 0; j < fcBase.length; ++j) {
            float type3_fc_kink = SID.kinkedDac(j << 1, this.voiceNonlinearity, 11);
            fcBase[j] = this.offset / (float)Math.pow(this.steepness, type3_fc_kink);
        }
        float[] distBase = new float[256];
        for (int i = 0; i < distBase.length; ++i) {
            float dist = i > 0 ? ((float)i + 0.5f) / 2.0E-4f : 0.0f;
            distBase[i] = 1.0f / (float)Math.pow(this.steepness, dist * 0.001953125f);
        }
        float _1_div_caps_freq = (float)(1.0 / (4.7E-10 * this.clockFrequency));
        for (int j = 0; j < fcBase.length; ++j) {
            float fcBaseValue = fcBase[j];
            for (int i = 0; i < distBase.length; ++i) {
                float fetresistance = fcBaseValue * distBase[i];
                float dynamic_resistance = this.minimumfetresistance + fetresistance;
                float _1_div_resistance = (this.baseresistance + dynamic_resistance) / (this.baseresistance * dynamic_resistance);
                this.type3_w0s[j][i] = _1_div_caps_freq * _1_div_resistance;
            }
        }
    }

    @Override
    protected void updatedResonance() {
        this._1_div_Q = 1.0f / (0.5f + this.resonanceFactor * (float)this.res / 18.0f);
    }
}

