/*
 * Decompiled with CFR 0.152.
 */
package libsidplay.components.ram;

import java.util.Arrays;
import libsidplay.components.pla.Bank;

public final class SystemRAMBank
extends Bank {
    private final byte[] ram = new byte[65536];

    public void reset() {
        Arrays.fill(this.ram, (byte)0);
        for (int i = 1984; i < 65536; i += 128) {
            Arrays.fill(this.ram, i, i + 64, (byte)-1);
        }
    }

    @Override
    public byte read(int address) {
        return this.ram[address];
    }

    @Override
    public void write(int address, byte value) {
        this.ram[address] = value;
    }

    public byte[] array() {
        return this.ram;
    }
}

