/*
 * Decompiled with CFR 0.152.
 */
package libsidplay.components.c1541;

public enum DOSErrorCodes {
    CBMDOS_IPE_OK(0),
    CBMDOS_IPE_FILES_SCRATCHED(1),
    CBMDOS_IPE_READ_ERROR_BNF(20),
    CBMDOS_IPE_READ_ERROR_SYNC(21),
    CBMDOS_IPE_READ_ERROR_DATA(22),
    CBMDOS_IPE_READ_ERROR_CHK(23),
    CBMDOS_IPE_READ_ERROR_GCR(24),
    CBMDOS_IPE_WRITE_ERROR_VER(25),
    CBMDOS_IPE_WRITE_PROTECT_ON(26),
    CBMDOS_IPE_READ_ERROR_BCHK(27),
    CBMDOS_IPE_WRITE_ERROR_BIG(28),
    CBMDOS_IPE_DISK_ID_MISMATCH(29),
    CBMDOS_IPE_COMMON_SYNTAX_ERROR(30),
    CBMDOS_IPE_INVALID_COMMAND(31),
    CBMDOS_IPE_COMMAND_LINE_TOO_LONG(32),
    CBMDOS_IPE_INVALID_USE_OF_A_JOKER(33),
    CBMDOS_IPE_FILENAME_NOT_FOUND(34),
    CBMDOS_IPE_INVALID_COMMAND2(39),
    CBMDOS_IPE_RECORD_NOT_PRESENT(50),
    CBMDOS_IPE_OVERFLOW_IN_RECORD(51),
    CBMDOS_IPE_FILE_TOO_LARGE(52),
    CBMDOS_IPE_WRITE_FILE_OPEN(60),
    CBMDOS_IPE_FILE_NOT_OPEN(61),
    CBMDOS_IPE_FILE_NOT_FOUND(62),
    CBMDOS_IPE_FILE_EXISTS(63),
    CBMDOS_IPE_FILE_TYPE_MISMATCH(64),
    CBMDOS_IPE_NO_NLOCK(65),
    CBMDOS_IPE_ILLEGAL_TRACK(66),
    CBMDOS_IPE_ILLEGAL_TRACK_OR_SECTOR(67),
    CBMDOS_IPE_NO_CHANNEL(70),
    CBMDOS_IPE_DIR_ERROR(71),
    CBMDOS_IPE_DISK_FULL(72),
    CBMDOS_IPE_STARTUP_MESSAGE(73),
    CBMDOS_IPE_NOT_READY(74);

    private int errorCode;

    private DOSErrorCodes(int rc) {
        this.errorCode = rc;
    }

    public static final DOSErrorCodes valueOf(int d64ErrorCode) {
        switch (d64ErrorCode) {
            case 0: 
            case 1: {
                return CBMDOS_IPE_OK;
            }
            case 2: {
                return CBMDOS_IPE_READ_ERROR_BNF;
            }
            case 3: {
                return CBMDOS_IPE_READ_ERROR_SYNC;
            }
            case 4: {
                return CBMDOS_IPE_READ_ERROR_DATA;
            }
            case 5: {
                return CBMDOS_IPE_READ_ERROR_CHK;
            }
            case 7: {
                return CBMDOS_IPE_WRITE_ERROR_VER;
            }
            case 8: {
                return CBMDOS_IPE_WRITE_PROTECT_ON;
            }
            case 9: {
                return CBMDOS_IPE_READ_ERROR_BCHK;
            }
            case 10: {
                return CBMDOS_IPE_WRITE_ERROR_BIG;
            }
            case 11: {
                return CBMDOS_IPE_DISK_ID_MISMATCH;
            }
            case 15: {
                return CBMDOS_IPE_NOT_READY;
            }
            case 16: {
                return CBMDOS_IPE_READ_ERROR_GCR;
            }
        }
        return CBMDOS_IPE_OK;
    }

    public int getErrorCode() {
        return this.errorCode;
    }
}

