/*
 * Decompiled with CFR 0.152.
 */
package kickass.pass.values;

import kickass.common.exceptions.AsmErrorException;
import kickass.parsing.sourcelocation.SourceRange;
import kickass.pass.function.Function;
import kickass.pass.function.table.FunctionTable;
import kickass.pass.valueholder.IValueHolder;
import kickass.pass.values.LockableValue;
import kickass.pass.values.Value;
import kickass.state.EvaluationState;

public class InvalidUnlockedSideEffectValue
extends LockableValue {
    private SourceRange setRange;

    public InvalidUnlockedSideEffectValue(SourceRange sourceRange) {
        this.setInvalid();
        this.setRange = sourceRange;
    }

    @Override
    public boolean isInvalid() {
        return true;
    }

    @Override
    public String getType() {
        this.throwException(null);
        return null;
    }

    @Override
    protected IValueHolder localGetVariable(String string, SourceRange sourceRange) {
        this.throwException(sourceRange);
        return null;
    }

    @Override
    public FunctionTable getFunctions() {
        return new InvalidValueFunctionTable();
    }

    @Override
    public void lock(SourceRange sourceRange) {
    }

    public void throwException(SourceRange sourceRange) {
        String string = "(" + this.setRange.getFileName() + ":" + this.setRange.getStartLineNo() + ")";
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("You are trying to use an unlocked value accross passes. This is not supported. ");
        stringBuffer.append("Try locking the variable " + string + " with the .define directive or .lock() method before assigning it.");
        throw new AsmErrorException(stringBuffer.toString(), sourceRange);
    }

    class InvalidValueFunctionTable
    extends FunctionTable {
        InvalidValueFunctionTable() {
        }

        @Override
        public Function get(String string, int n) {
            return new Function(string, null, null, true){

                @Override
                public Value execute(Value[] valueArray, EvaluationState evaluationState, SourceRange sourceRange) {
                    InvalidUnlockedSideEffectValue.this.throwException(sourceRange);
                    return null;
                }
            };
        }
    }
}

