/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import org.hsqldb.ColumnBase;
import org.hsqldb.ColumnSchema;
import org.hsqldb.HsqlException;
import org.hsqldb.HsqlNameManager;
import org.hsqldb.RangeGroup;
import org.hsqldb.RangeVariable;
import org.hsqldb.Routine;
import org.hsqldb.Session;
import org.hsqldb.Statement;
import org.hsqldb.StatementCursor;
import org.hsqldb.StatementExpression;
import org.hsqldb.StatementHandler;
import org.hsqldb.StatementQuery;
import org.hsqldb.StatementSimple;
import org.hsqldb.Table;
import org.hsqldb.error.Error;
import org.hsqldb.lib.HashSet;
import org.hsqldb.lib.OrderedHashMap;
import org.hsqldb.lib.OrderedHashSet;
import org.hsqldb.lib.OrderedIntHashSet;
import org.hsqldb.result.Result;
import org.hsqldb.types.Type;

public class StatementCompound
extends Statement
implements RangeGroup {
    final boolean isLoop;
    HsqlNameManager.HsqlName label;
    StatementHandler[] handlers = StatementHandler.emptyExceptionHandlerArray;
    boolean hasUndoHandler;
    StatementQuery loopCursor;
    Statement[] statements;
    StatementExpression condition;
    boolean isAtomic;
    ColumnSchema[] variables = ColumnSchema.emptyArray;
    StatementCursor[] cursors = StatementCursor.emptyArray;
    OrderedHashMap scopeVariables = new OrderedHashMap();
    RangeVariable[] rangeVariables = RangeVariable.emptyArray;
    Table[] tables = Table.emptyArray;
    OrderedHashMap scopeTables;
    int variablesOffset;
    public static final StatementCompound[] emptyStatementArray = new StatementCompound[0];

    StatementCompound(int n, HsqlNameManager.HsqlName hsqlName, StatementCompound statementCompound) {
        super(n, 2007);
        this.label = hsqlName;
        this.isTransactionStatement = false;
        switch (n) {
            case 101: 
            case 105: 
            case 107: 
            case 110: {
                this.isLoop = true;
                break;
            }
            case 99: 
            case 102: {
                this.isLoop = false;
                break;
            }
            default: {
                throw Error.runtimeError(201, "StatementCompound");
            }
        }
        this.parent = statementCompound;
    }

    @Override
    public String getSQL() {
        return this.sql;
    }

    String describe(Session session, int n) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append('\n');
        for (int i = 0; i < n; ++i) {
            stringBuilder.append(' ');
        }
        stringBuilder.append("STATEMENT");
        return stringBuilder.toString();
    }

    boolean isLoop() {
        return this.isLoop;
    }

    void setLocalDeclarations(Object[] objectArray) {
        int n;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        for (n = 0; n < objectArray.length; ++n) {
            if (objectArray[n] instanceof ColumnSchema) {
                ++n2;
                continue;
            }
            if (objectArray[n] instanceof StatementHandler) {
                ++n3;
                continue;
            }
            if (objectArray[n] instanceof Table) {
                ++n5;
                continue;
            }
            ++n4;
        }
        if (n2 > 0) {
            this.variables = new ColumnSchema[n2];
        }
        if (n3 > 0) {
            this.handlers = new StatementHandler[n3];
        }
        if (n5 > 0) {
            this.tables = new Table[n5];
        }
        if (n4 > 0) {
            this.cursors = new StatementCursor[n4];
        }
        n2 = 0;
        n3 = 0;
        n5 = 0;
        n4 = 0;
        for (n = 0; n < objectArray.length; ++n) {
            Object object;
            if (objectArray[n] instanceof StatementCursor) {
                object = (StatementCursor)objectArray[n];
                this.cursors[n4++] = object;
                continue;
            }
            if (objectArray[n] instanceof ColumnSchema) {
                this.variables[n2++] = (ColumnSchema)objectArray[n];
                continue;
            }
            if (objectArray[n] instanceof StatementHandler) {
                object = (StatementHandler)objectArray[n];
                ((Statement)object).setParent(this);
                this.handlers[n3++] = object;
                if (((StatementHandler)object).handlerType != 7) continue;
                this.hasUndoHandler = true;
                continue;
            }
            if (!(objectArray[n] instanceof Table)) continue;
            object = (Table)objectArray[n];
            this.tables[n5++] = object;
        }
        this.setVariables();
        this.setHandlers();
        this.setTables();
        this.setCursors();
    }

    void setLoopStatement(HsqlNameManager.HsqlName hsqlName, StatementQuery statementQuery) {
        this.loopCursor = statementQuery;
        HsqlNameManager.HsqlName[] hsqlNameArray = statementQuery.queryExpression.getResultColumnNames();
        Type[] typeArray = statementQuery.queryExpression.getColumnTypes();
        Object[] objectArray = new ColumnSchema[hsqlNameArray.length];
        for (int i = 0; i < hsqlNameArray.length; ++i) {
            objectArray[i] = new ColumnSchema(hsqlNameArray[i], typeArray[i], false, false, null);
            ((ColumnBase)objectArray[i]).setParameterMode((byte)1);
        }
        this.setLocalDeclarations(objectArray);
    }

    void setStatements(Statement[] statementArray) {
        for (int i = 0; i < statementArray.length; ++i) {
            statementArray[i].setParent(this);
        }
        this.statements = statementArray;
    }

    void setCondition(StatementExpression statementExpression) {
        this.condition = statementExpression;
    }

    @Override
    public Result execute(Session session) {
        Result result;
        switch (this.type) {
            case 99: {
                this.initialiseVariables(session);
                result = this.executeBlock(session);
                break;
            }
            case 101: {
                result = this.executeForLoop(session);
                break;
            }
            case 105: 
            case 107: 
            case 110: {
                result = this.executeLoop(session);
                break;
            }
            case 102: {
                result = this.executeIf(session);
                break;
            }
            default: {
                throw Error.runtimeError(201, "StatementCompound");
            }
        }
        if (result.isError()) {
            result.getException().setStatementType(this.group, this.type);
        }
        return result;
    }

    private Result executeBlock(Session session) {
        boolean bl;
        Result result = Result.updateZeroResult;
        boolean bl2 = bl = !this.root.isTrigger();
        if (bl) {
            session.sessionContext.push();
            if (this.hasUndoHandler) {
                String string = HsqlNameManager.getAutoSavepointNameString(session.actionTimestamp, session.sessionContext.depth);
                session.savepoint(string);
            }
        }
        for (int i = 0; i < this.statements.length; ++i) {
            result = this.executeProtected(session, this.statements[i]);
            if ((result = this.handleCondition(session, result)).isError() || result.getType() == 42 || result.getType() == 3) break;
        }
        if (result.getType() == 42 && result.getErrorCode() == 104) {
            if (result.getMainString() == null) {
                result = Result.updateZeroResult;
            } else if (this.label != null && this.label.name.equals(result.getMainString())) {
                result = Result.updateZeroResult;
            }
        }
        if (bl) {
            session.sessionContext.pop();
        }
        return result;
    }

    private Result handleCondition(Session session, Result result) {
        String string = null;
        if (result.isError()) {
            string = result.getSubString();
        } else if (session.getLastWarning() != null) {
            string = session.getLastWarning().getSQLState();
        } else {
            return result;
        }
        if (string != null) {
            for (int i = 0; i < this.handlers.length; ++i) {
                StatementHandler statementHandler = this.handlers[i];
                session.clearWarnings();
                if (!statementHandler.handlesCondition(string)) continue;
                String string2 = this.label == null ? null : this.label.name;
                switch (statementHandler.handlerType) {
                    case 5: {
                        result = Result.updateZeroResult;
                        break;
                    }
                    case 7: {
                        if (session.sessionContext.savepoints.size() > 0) {
                            session.rollbackToSavepoint();
                        }
                        result = Result.newPSMResult(104, string2, null);
                        break;
                    }
                    case 6: {
                        result = Result.newPSMResult(104, string2, null);
                    }
                }
                Result result2 = this.executeProtected(session, statementHandler);
                if (result2.isError()) {
                    result = result2;
                    continue;
                }
                if (result2.getType() != 42) continue;
                result = result2;
            }
            if (result.isError() && this.parent != null) {
                return this.parent.handleCondition(session, result);
            }
        }
        return result;
    }

    private Result executeForLoop(Session session) {
        Result result = this.loopCursor.execute(session);
        if (result.isError()) {
            return result;
        }
        Result result2 = Result.updateZeroResult;
        while (result.navigator.next()) {
            Object[] objectArray = result.navigator.getCurrent();
            this.initialiseVariables(session, objectArray, result.metaData.getColumnCount());
            for (int i = 0; i < this.statements.length; ++i) {
                result2 = this.executeProtected(session, this.statements[i]);
                if ((result2 = this.handleCondition(session, result2)).isError() || result2.getType() == 42 || result2.getType() == 3) break;
            }
            if (result2.isError()) break;
            if (result2.getType() == 42) {
                if (result2.getErrorCode() == 103) {
                    if (result2.getMainString() != null && (this.label == null || !this.label.name.equals(result2.getMainString()))) break;
                    continue;
                }
                if (result2.getErrorCode() != 104) break;
                break;
            }
            if (result2.getType() != 3) continue;
            break;
        }
        result.navigator.release();
        return result2;
    }

    private Result executeLoop(Session session) {
        Result result;
        block9: {
            result = Result.updateZeroResult;
            while (true) {
                if (this.type == 110) {
                    result = this.condition.execute(session);
                    if (result.isError()) break block9;
                    if (!Boolean.TRUE.equals(result.getValueObject())) {
                        result = Result.updateZeroResult;
                        break block9;
                    }
                }
                for (int i = 0; i < this.statements.length; ++i) {
                    result = this.executeProtected(session, this.statements[i]);
                    if ((result = this.handleCondition(session, result)).getType() == 42 || result.getType() == 3) break;
                }
                if (result.isError()) break block9;
                if (result.getType() == 42) {
                    if (result.getErrorCode() == 103) {
                        if (result.getMainString() == null || this.label != null && this.label.name.equals(result.getMainString())) {
                            continue;
                        }
                        break block9;
                    }
                    if (result.getErrorCode() != 104) break block9;
                    if (result.getMainString() == null) {
                        result = Result.updateZeroResult;
                    }
                    if (this.label != null && this.label.name.equals(result.getMainString())) {
                        result = Result.updateZeroResult;
                    }
                    break block9;
                }
                if (result.getType() == 3) break block9;
                if (this.type != 107) continue;
                result = this.condition.execute(session);
                if (result.isError()) break block9;
                if (Boolean.TRUE.equals(result.getValueObject())) break;
            }
            result = Result.updateZeroResult;
        }
        return result;
    }

    private Result executeIf(Session session) {
        Result result = Result.updateZeroResult;
        boolean bl = false;
        for (int i = 0; i < this.statements.length; ++i) {
            if (this.statements[i].getType() == 1211) {
                if (bl || (result = this.executeProtected(session, this.statements[i])).isError()) break;
                Object object = result.getValueObject();
                bl = Boolean.TRUE.equals(object);
                ++i;
            }
            result = Result.updateZeroResult;
            if (!bl) continue;
            result = this.executeProtected(session, this.statements[i]);
            if ((result = this.handleCondition(session, result)).isError() || result.getType() == 42) break;
        }
        return result;
    }

    private Result executeProtected(Session session, Statement statement) {
        long l;
        int n = session.rowActionList.size();
        session.actionTimestamp = l = session.database.txManager.getNextGlobalChangeTimestamp();
        Result result = statement.execute(session);
        if (result.isError()) {
            session.rollbackAction(n, l);
        }
        return result;
    }

    @Override
    public void resolve(Session session) {
        int n;
        int n2;
        for (n2 = 0; n2 < this.statements.length; ++n2) {
            if (this.statements[n2].getType() == 104 || this.statements[n2].getType() == 103) {
                if (this.findLabel((StatementSimple)this.statements[n2])) continue;
                throw Error.error(5508, ((StatementSimple)this.statements[n2]).label.name);
            }
            if (this.statements[n2].getType() != 62 || this.root.isFunction()) continue;
            throw Error.error(5602, "RETURN");
        }
        for (n2 = 0; n2 < this.statements.length; ++n2) {
            this.statements[n2].resolve(session);
        }
        for (n2 = 0; n2 < this.handlers.length; ++n2) {
            this.handlers[n2].resolve(session);
        }
        OrderedHashSet<HsqlNameManager.HsqlName> orderedHashSet = new OrderedHashSet<HsqlNameManager.HsqlName>();
        OrderedHashSet<HsqlNameManager.HsqlName> orderedHashSet2 = new OrderedHashSet<HsqlNameManager.HsqlName>();
        OrderedHashSet orderedHashSet3 = new OrderedHashSet();
        for (n = 0; n < this.variables.length; ++n) {
            OrderedHashSet orderedHashSet4 = this.variables[n].getReferences();
            if (orderedHashSet4 == null) continue;
            orderedHashSet3.addAll(orderedHashSet4);
        }
        if (this.loopCursor != null) {
            orderedHashSet3.addAll(this.loopCursor.getReferences());
            orderedHashSet2.addAll(this.loopCursor.getTableNamesForRead());
        }
        if (this.condition != null) {
            orderedHashSet3.addAll(this.condition.getReferences());
            orderedHashSet2.addAll(this.condition.getTableNamesForRead());
        }
        for (n = 0; n < this.statements.length; ++n) {
            orderedHashSet3.addAll(this.statements[n].getReferences());
            orderedHashSet2.addAll(this.statements[n].getTableNamesForRead());
            orderedHashSet.addAll(this.statements[n].getTableNamesForWrite());
        }
        for (n = 0; n < this.handlers.length; ++n) {
            orderedHashSet3.addAll(this.handlers[n].getReferences());
            orderedHashSet2.addAll(this.handlers[n].getTableNamesForRead());
            orderedHashSet.addAll(this.handlers[n].getTableNamesForWrite());
        }
        orderedHashSet2.removeAll(orderedHashSet);
        this.readTableNames = new HsqlNameManager.HsqlName[orderedHashSet2.size()];
        orderedHashSet2.toArray(this.readTableNames);
        this.writeTableNames = new HsqlNameManager.HsqlName[orderedHashSet.size()];
        orderedHashSet.toArray(this.writeTableNames);
        this.references = orderedHashSet3;
    }

    @Override
    public void setRoot(Routine routine) {
        this.root = routine;
    }

    @Override
    public String describe(Session session) {
        return "";
    }

    @Override
    public OrderedHashSet getReferences() {
        return this.references;
    }

    public void setAtomic(boolean bl) {
        this.isAtomic = bl;
    }

    private void setVariables() {
        int n;
        Object object;
        int n2;
        OrderedHashMap orderedHashMap = new OrderedHashMap();
        if (this.parent != null && this.parent.scopeVariables != null) {
            for (n2 = 0; n2 < this.parent.scopeVariables.size(); ++n2) {
                orderedHashMap.add(this.parent.scopeVariables.getKeyAt(n2), this.parent.scopeVariables.get(n2));
            }
        }
        this.variablesOffset = orderedHashMap.size();
        for (n2 = 0; n2 < this.variables.length; ++n2) {
            object = this.variables[n2].getName().name;
            n = orderedHashMap.add(object, this.variables[n2]);
            if (n == 0) {
                throw Error.error(5606, (String)object);
            }
            if (this.root.getParameterIndex((String)object) == -1) continue;
            throw Error.error(5606, (String)object);
        }
        this.scopeVariables = orderedHashMap;
        RangeVariable[] rangeVariableArray = this.root.getRangeVariables();
        object = new RangeVariable(orderedHashMap, null, true, 4);
        this.rangeVariables = new RangeVariable[rangeVariableArray.length + 1];
        for (n = 0; n < rangeVariableArray.length; ++n) {
            this.rangeVariables[n] = rangeVariableArray[n];
        }
        this.rangeVariables[rangeVariableArray.length] = object;
        if (orderedHashMap.size() > this.root.variableCount) {
            this.root.variableCount = orderedHashMap.size();
        }
    }

    private void setHandlers() {
        if (this.handlers.length == 0) {
            return;
        }
        HashSet<String> hashSet = new HashSet<String>();
        OrderedIntHashSet orderedIntHashSet = new OrderedIntHashSet();
        for (int i = 0; i < this.handlers.length; ++i) {
            int[] nArray = this.handlers[i].getConditionTypes();
            for (int j = 0; j < nArray.length; ++j) {
                if (orderedIntHashSet.add(nArray[j])) continue;
                throw Error.error(5601);
            }
            String[] stringArray = this.handlers[i].getConditionStates();
            for (int j = 0; j < stringArray.length; ++j) {
                if (hashSet.add(stringArray[j])) continue;
                throw Error.error(5601);
            }
        }
    }

    private void setTables() {
        int n;
        if (this.tables.length == 0) {
            return;
        }
        OrderedHashMap orderedHashMap = new OrderedHashMap();
        if (this.parent != null && this.parent.scopeTables != null) {
            for (n = 0; n < this.parent.scopeTables.size(); ++n) {
                orderedHashMap.add(this.parent.scopeTables.getKeyAt(n), this.parent.scopeTables.get(n));
            }
        }
        for (n = 0; n < this.tables.length; ++n) {
            String string = this.tables[n].getName().name;
            boolean bl = orderedHashMap.add(string, this.tables[n]);
            if (bl) continue;
            throw Error.error(5606, string);
        }
        this.scopeTables = orderedHashMap;
    }

    private void setCursors() {
        if (this.cursors.length == 0) {
            return;
        }
        HashSet<String> hashSet = new HashSet<String>();
        for (int i = 0; i < this.cursors.length; ++i) {
            StatementCursor statementCursor = this.cursors[i];
            boolean bl = hashSet.add(statementCursor.getCursorName().name);
            if (bl) continue;
            throw Error.error(5606, statementCursor.getCursorName().name);
        }
    }

    private boolean findLabel(StatementSimple statementSimple) {
        if (this.label != null && statementSimple.label.name.equals(this.label.name)) {
            return this.isLoop || statementSimple.getType() != 103;
        }
        if (this.parent == null) {
            return false;
        }
        return this.parent.findLabel(statementSimple);
    }

    private void initialiseVariables(Session session) {
        Object[] objectArray = session.sessionContext.routineVariables;
        for (int i = 0; i < this.variables.length; ++i) {
            try {
                objectArray[this.variablesOffset + i] = this.variables[i].getDefaultValue(session);
                continue;
            }
            catch (HsqlException hsqlException) {
                // empty catch block
            }
        }
    }

    private void initialiseVariables(Session session, Object[] objectArray, int n) {
        Object[] objectArray2 = session.sessionContext.routineVariables;
        for (int i = 0; i < n; ++i) {
            objectArray2[this.variablesOffset + i] = objectArray[i];
        }
    }

    @Override
    public RangeVariable[] getRangeVariables() {
        return this.rangeVariables;
    }

    @Override
    public void setCorrelated() {
    }

    @Override
    public boolean isVariable() {
        return true;
    }
}

