/*
 * Decompiled with CFR 0.152.
 */
package server.restful.servlets;

import com.beust.jcommander.Parameter;
import com.beust.jcommander.Parameters;
import jakarta.servlet.AsyncContext;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.annotation.HttpConstraint;
import jakarta.servlet.annotation.ServletSecurity;
import jakarta.servlet.annotation.WebServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javafx.util.Pair;
import libsidplay.sidtune.SidTune;
import server.restful.common.ContentTypeAndFileExtensions;
import server.restful.common.IServletSystemProperties;
import server.restful.common.JSIDPlay2Servlet;
import server.restful.common.ServletUtil;
import server.restful.common.async.DefaultThreadFactory;
import server.restful.common.async.HttpAsyncContextRunnable;
import server.restful.common.parameter.ServletParameterParser;
import server.restful.common.parameter.requestpath.FileRequestPathServletParameters;
import ui.entities.collection.HVSCEntry;
import ui.musiccollection.SearchCriteria;

@WebServlet(name="TuneInfoServlet", displayName="TuneInfoServlet", asyncSupported=true, urlPatterns={"/jsidplay2service/JSIDPlay2REST/info/*"}, description="Get SID tune infos")
@ServletSecurity(value=@HttpConstraint(rolesAllowed={"user", "admin"}))
public class TuneInfoServlet
extends JSIDPlay2Servlet {
    private ExecutorService executorService;

    public void init() throws ServletException {
        this.executorService = Executors.newFixedThreadPool(IServletSystemProperties.TuneInfoServlet.MAX_TUNE_INFO_IN_PARALLEL, new DefaultThreadFactory("/tuneinfo"));
    }

    public void destroy() {
        this.executorService.shutdown();
    }

    @Override
    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        AsyncContext asyncContext = request.startAsync((ServletRequest)request, (ServletResponse)response);
        asyncContext.setTimeout((long)IServletSystemProperties.TuneInfoServlet.TUNE_INFO_ASYNC_TIMEOUT);
        this.executorService.execute(new HttpAsyncContextRunnable(asyncContext, this.getServletContext()){

            @Override
            public void run(HttpServletRequest request, HttpServletResponse response) throws IOException {
                block4: {
                    try {
                        TuneInfoServletParameters servletParameters = new TuneInfoServletParameters();
                        ServletParameterParser parser = new ServletParameterParser(request, response, servletParameters);
                        File file = servletParameters.fetchFile(TuneInfoServlet.this.configuration, TuneInfoServlet.this.directoryProperties, parser, TuneInfoServlet.this.hasAdminAccess(request));
                        if (file == null || servletParameters.getHelp().booleanValue() || parser.hasException()) {
                            parser.usage();
                            return;
                        }
                        Boolean list = servletParameters.getList();
                        Object tuneInfos = TuneInfoServlet.this.getTuneInfos(file, list);
                        if (!this.isComplete()) {
                            TuneInfoServlet.this.setOutput(ContentTypeAndFileExtensions.MIME_TYPE_JSON, response, tuneInfos);
                        }
                    }
                    catch (Throwable t) {
                        ServletUtil.error(TuneInfoServlet.this.getServletContext(), t, this.parentThread);
                        if (this.isComplete()) break block4;
                        response.setStatus(500);
                        TuneInfoServlet.this.setOutput(response, t);
                    }
                }
            }
        });
    }

    private Object getTuneInfos(File file, boolean asList) throws Exception {
        HVSCEntry hvscEntry = this.createHVSCEntry(file);
        return asList ? this.hvscEntry2SortedList(hvscEntry) : this.hvscEntry2SortedMap(hvscEntry);
    }

    private HVSCEntry createHVSCEntry(File tuneFile) throws Exception {
        SidTune tune = SidTune.load(tuneFile);
        return new HVSCEntry(() -> this.sidDatabase != null ? this.sidDatabase.getTuneLength(tune) : 0.0, tuneFile.getName(), this.getCollectionName(tuneFile), tuneFile.length(), tuneFile.lastModified(), tune, tune.identify().stream().collect(Collectors.joining(",")));
    }

    private List<Map<String, String>> hvscEntry2SortedList(HVSCEntry hvscEntry) {
        return this.hvscEntry2SortedMap(hvscEntry).entrySet().stream().map(entry -> {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("Name", (String)entry.getKey());
            map.put("Value", (String)entry.getValue());
            return map;
        }).collect(Collectors.toList());
    }

    private TreeMap<String, String> hvscEntry2SortedMap(HVSCEntry hvscEntry) {
        List<Pair<String, String>> attributeValues = SearchCriteria.getAttributeValues(hvscEntry, field -> field.getAttribute().getDeclaringType().getJavaType().getSimpleName() + "." + field.getAttribute().getName());
        return attributeValues.stream().collect(Collectors.toMap(Pair::getKey, Pair::getValue, (o1, o2) -> {
            throw new RuntimeException(String.format("Duplicate key for values %s and %s, I will not merge!", o1, o2));
        }, () -> new TreeMap((o1, o2) -> this.index(attributeValues, (String)o1) - this.index(attributeValues, (String)o2))));
    }

    private int index(List<Pair<String, String>> attributeValues, String o) {
        return IntStream.range(0, attributeValues.size()).filter(index -> Objects.equals(((Pair)attributeValues.get(index)).getKey(), o)).findFirst().getAsInt();
    }

    @Parameters(resourceBundle="server.restful.servlets.TuneInfoServletParameters")
    public static class TuneInfoServletParameters
    extends FileRequestPathServletParameters {
        @Parameter(names={"--list"}, arity=1, descriptionKey="LIST", order=-2147483645)
        private Boolean list = Boolean.FALSE;

        public Boolean getList() {
            return this.list;
        }
    }
}

