/*
 * Decompiled with CFR 0.152.
 */
package ui;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.text.DateFormat;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.ResourceBundle;
import javafx.application.Platform;
import javafx.beans.property.ObjectProperty;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.ButtonType;
import javafx.scene.control.SingleSelectionModel;
import javafx.scene.control.Tab;
import javafx.scene.control.TabPane;
import javafx.scene.input.Dragboard;
import javafx.scene.input.TransferMode;
import javafx.stage.Stage;
import libsidplay.components.c1541.ExtendImagePolicy;
import libsidplay.components.c1541.IExtendImageListener;
import libsidplay.sidtune.MP3Tune;
import libsidplay.sidtune.SidTune;
import libsidplay.sidtune.SidTuneError;
import libsidutils.IOUtils;
import sidplay.Player;
import sidplay.audio.Audio;
import sidplay.player.State;
import ui.asm.Asm;
import ui.assembly64.Assembly64;
import ui.common.C64Window;
import ui.common.Convenience;
import ui.console.Console;
import ui.disassembler.Disassembler;
import ui.diskcollection.DiskCollection;
import ui.diskcollection.DiskCollectionType;
import ui.entities.config.SidPlay2Section;
import ui.entities.config.ViewEntity;
import ui.favorites.Favorites;
import ui.favorites.PlaybackType;
import ui.gamebase.GameBase;
import ui.musiccollection.MusicCollection;
import ui.musiccollection.MusicCollectionType;
import ui.oscilloscope.Oscilloscope;
import ui.printer.Printer;
import ui.siddump.SidDump;
import ui.sidreg.SidReg;
import ui.videoplayer.VideoPlayer;
import ui.videoscreen.Video;
import ui.webview.WebView;
import ui.webview.WebViewType;

public class JSidPlay2
extends C64Window
implements IExtendImageListener {
    @FXML
    protected TabPane tabbedPane;
    private StateChangeListener propertyChangeListener;

    public JSidPlay2() {
    }

    public JSidPlay2(Stage primaryStage, Player player) {
        super(primaryStage, player);
    }

    @Override
    @FXML
    protected void initialize() {
        Platform.runLater(() -> {
            String date = DateFormat.getDateInstance(2).format(Player.LAST_MODIFIED.getTime());
            this.getStage().setTitle(this.util.getBundle().getString("TITLE") + String.format(", %s: %s %s", this.util.getBundle().getString("RELEASE"), date, this.util.getBundle().getString("AUTHOR")));
        });
        Platform.runLater(() -> {
            this.tabbedPane.getScene().setOnDragOver(event -> {
                Dragboard db = event.getDragboard();
                if (db.hasFiles()) {
                    event.acceptTransferModes(new TransferMode[]{TransferMode.COPY});
                } else {
                    event.consume();
                }
            });
            this.tabbedPane.getScene().setOnDragDropped(event -> {
                Dragboard db = event.getDragboard();
                boolean success = false;
                if (db.hasFiles()) {
                    success = true;
                    List files = db.getFiles();
                    try {
                        this.addView("VIDEO");
                        this.util.setPlayingTab(this.tabbedPane.getTabs().stream().filter(tab -> tab.getId().equals("VIDEO")).findFirst().get().getContent(), new ObjectProperty[0]);
                        new Convenience(this.util.getPlayer()).autostart((File)files.get(0), Convenience.LEXICALLY_FIRST_MEDIA, null);
                    }
                    catch (IOException | SidTuneError e) {
                        this.openErrorDialog(String.format(this.util.getBundle().getString("ERR_IO_ERROR"), e.getMessage()));
                    }
                }
                event.setDropCompleted(success);
                event.consume();
            });
            this.tabbedPane.requestFocus();
        });
        ((ObservableList)this.util.getConfig().getViews()).addListener(c -> {
            while (c.next()) {
                if (!c.wasAdded()) continue;
                c.getAddedSubList().forEach(view -> this.addAndSelectTab(view.getFxId()));
            }
        });
        this.util.getConfig().getViews().forEach(view -> Platform.runLater(() -> this.addAndSelectTab(view.getFxId())));
        this.propertyChangeListener = new StateChangeListener();
        this.util.getPlayer().stateProperty().addListener(this.propertyChangeListener);
        this.util.getPlayer().setExtendImagePolicy(this);
        this.util.getPlayer().startC64();
    }

    @Override
    public void doClose() {
        this.util.getPlayer().stateProperty().removeListener(this.propertyChangeListener);
        this.util.getPlayer().quit();
        Platform.exit();
    }

    @Override
    public boolean isAllowed() {
        if (this.util.getConfig().getC1541Section().getExtendImagePolicy() == ExtendImagePolicy.EXTEND_ASK) {
            String msg = this.util.getBundle().getString("EXTEND_DISK_IMAGE_TO_40_TRACKS");
            Alert alert = new Alert(Alert.AlertType.CONFIRMATION, msg, new ButtonType[0]);
            alert.setTitle(this.util.getBundle().getString("EXTEND_DISK_IMAGE"));
            Optional result = alert.showAndWait();
            return result.isPresent() && result.get() == ButtonType.OK;
        }
        return this.util.getConfig().getC1541Section().getExtendImagePolicy() == ExtendImagePolicy.EXTEND_ACCESS;
    }

    private void addAndSelectTab(String fxId) {
        ResourceBundle bundle = this.util.getBundle();
        C64Window window = this.util.getWindow();
        Player player = this.util.getPlayer();
        if (!this.tabAlreadyOpen(fxId)) {
            if ("VIDEOPLAYER".equals(fxId)) {
                this.addTab(new Tab(bundle.getString(fxId), (Node)new VideoPlayer(window, player)), fxId);
            } else if ("VIDEO".equals(fxId)) {
                this.addTab(new Tab(bundle.getString(fxId), (Node)new Video(window, player)), fxId);
            } else if ("OSCILLOSCOPE".equals(fxId)) {
                this.addTab(new Tab(bundle.getString(fxId), (Node)new Oscilloscope(window, player)), fxId);
            } else if ("FAVORITES".equals(fxId)) {
                this.addTab(new Tab(bundle.getString(fxId), (Node)new Favorites(window, player)), fxId);
            } else if (MusicCollectionType.HVSC.name().equals(fxId)) {
                MusicCollection collection = new MusicCollection(window, player);
                collection.setType(MusicCollectionType.HVSC);
                this.addTab(new Tab(bundle.getString(fxId), (Node)collection), fxId);
            } else if (MusicCollectionType.CGSC.name().equals(fxId)) {
                MusicCollection collection = new MusicCollection(window, player);
                collection.setType(MusicCollectionType.CGSC);
                this.addTab(new Tab(bundle.getString(fxId), (Node)collection), fxId);
            } else if (DiskCollectionType.HVMEC.name().equals(fxId)) {
                DiskCollection collection = new DiskCollection(window, player);
                collection.setType(DiskCollectionType.HVMEC);
                this.addTab(new Tab(bundle.getString(fxId), (Node)collection), fxId);
            } else if (DiskCollectionType.DEMOS.name().equals(fxId)) {
                DiskCollection collection = new DiskCollection(window, player);
                collection.setType(DiskCollectionType.DEMOS);
                this.addTab(new Tab(bundle.getString(fxId), (Node)collection), fxId);
            } else if (DiskCollectionType.MAGS.name().equals(fxId)) {
                DiskCollection collection = new DiskCollection(window, player);
                collection.setType(DiskCollectionType.MAGS);
                this.addTab(new Tab(bundle.getString(fxId), (Node)collection), fxId);
            } else if ("SIDDUMP".equals(fxId)) {
                this.addTab(new Tab(bundle.getString(fxId), (Node)new SidDump(window, player)), fxId);
            } else if ("SIDREGISTERS".equals(fxId)) {
                this.addTab(new Tab(bundle.getString(fxId), (Node)new SidReg(window, player)), fxId);
            } else if ("ASM".equals(fxId)) {
                this.addTab(new Tab(bundle.getString(fxId), (Node)new Asm(window, player)), fxId);
            } else if ("DISASSEMBLER".equals(fxId)) {
                this.addTab(new Tab(bundle.getString(fxId), (Node)new Disassembler(window, player)), fxId);
            } else if ("ASSEMBLY64".equals(fxId)) {
                this.addTab(new Tab(bundle.getString(fxId), (Node)new Assembly64(window, player)), fxId);
            } else if (WebViewType.CSDB.name().equals(fxId)) {
                WebView collection = new WebView(window, player);
                collection.setType(WebViewType.CSDB);
                this.addTab(new Tab(bundle.getString(fxId), (Node)collection), fxId);
            } else if (WebViewType.REMIX_KWED_ORG.name().equals(fxId)) {
                WebView collection = new WebView(window, player);
                collection.setType(WebViewType.REMIX_KWED_ORG);
                this.addTab(new Tab(bundle.getString(fxId), (Node)collection), fxId);
            } else if (WebViewType.LEMON64_COM.name().equals(fxId)) {
                WebView collection = new WebView(window, player);
                collection.setType(WebViewType.LEMON64_COM);
                this.addTab(new Tab(bundle.getString(fxId), (Node)collection), fxId);
            } else if (WebViewType.FORUM64_DE.name().equals(fxId)) {
                WebView collection = new WebView(window, player);
                collection.setType(WebViewType.FORUM64_DE);
                this.addTab(new Tab(bundle.getString(fxId), (Node)collection), fxId);
            } else if (WebViewType.SOASC.name().equals(fxId)) {
                WebView collection = new WebView(window, player);
                collection.setType(WebViewType.SOASC);
                this.addTab(new Tab(bundle.getString(fxId), (Node)collection), fxId);
            } else if (WebViewType.CODEBASE64.name().equals(fxId)) {
                WebView collection = new WebView(window, player);
                collection.setType(WebViewType.CODEBASE64);
                this.addTab(new Tab(bundle.getString(fxId), (Node)collection), fxId);
            } else if ("GAMEBASE".equals(fxId)) {
                this.addTab(new Tab(bundle.getString(fxId), (Node)new GameBase(window, player)), fxId);
            } else if (WebViewType.JSIDPLAY2_SRC.name().equals(fxId)) {
                WebView collection = new WebView(window, player);
                collection.setType(WebViewType.JSIDPLAY2_SRC);
                this.addTab(new Tab(bundle.getString(fxId), (Node)collection), fxId);
            } else if ("PRINTER".equals(fxId)) {
                this.addTab(new Tab(bundle.getString(fxId), (Node)new Printer(window, player)), fxId);
            } else if ("CONSOLE".equals(fxId)) {
                this.addTab(new Tab(bundle.getString(fxId), (Node)new Console(window, player)), fxId);
            } else if (WebViewType.USERGUIDE.name().equals(fxId)) {
                WebView collection = new WebView(window, player);
                collection.setType(WebViewType.USERGUIDE);
                this.addTab(new Tab(bundle.getString(fxId), (Node)collection), fxId);
            } else if (WebViewType.JSIDPLAY2_JAVADOC.name().equals(fxId)) {
                WebView collection = new WebView(window, player);
                collection.setType(WebViewType.JSIDPLAY2_JAVADOC);
                this.addTab(new Tab(bundle.getString(fxId), (Node)collection), fxId);
            } else {
                throw new RuntimeException("Unknown view ID: " + fxId);
            }
        }
        this.selectTab(fxId);
    }

    private boolean tabAlreadyOpen(String fxId) {
        return this.tabbedPane.getTabs().stream().map(Tab::getId).filter(fxId::equals).findFirst().isPresent();
    }

    private void addTab(Tab tab, String fxId) {
        tab.setId(fxId);
        tab.setOnClosed(evt -> {
            this.util.getWindow().close(tab.getContent());
            this.util.getConfig().getViews().removeIf(view -> view.getFxId().equals(tab.getId()));
        });
        this.tabbedPane.getTabs().add((Object)tab);
    }

    private void selectTab(String fxId) {
        this.tabbedPane.getTabs().stream().filter(tab -> tab.getId().equals(fxId)).findFirst().ifPresent(arg_0 -> ((SingleSelectionModel)this.tabbedPane.getSelectionModel()).select(arg_0));
    }

    private void playNextRandomHVSC() {
        SidPlay2Section sidPlay2Section = this.util.getConfig().getSidplay2Section();
        String rndPath = this.util.getPlayer().getSidDatabaseInfo(db -> db.getRandomPath(), null);
        if (rndPath != null) {
            File file = IOUtils.getFile(rndPath, sidPlay2Section.getHvsc(), sidPlay2Section.getCgsc());
            this.addView(MusicCollectionType.HVSC.name());
            this.util.setPlayingTab(this.tabbedPane.getTabs().stream().filter(tab -> tab.getId().equals(MusicCollectionType.HVSC.name())).findFirst().get().getContent(), new ObjectProperty[0]);
            try {
                this.util.getPlayer().play(SidTune.load(file));
            }
            catch (IOException | SidTuneError e) {
                this.openErrorDialog(String.format(this.util.getBundle().getString("ERR_IO_ERROR"), e.getMessage()));
            }
        }
    }

    private void addView(String fxId) {
        if (!this.util.getConfig().getViews().stream().map(ViewEntity::getFxId).filter(fxId::equals).findFirst().isPresent()) {
            this.util.getConfig().getViews().add(new ViewEntity(fxId));
        }
        this.selectTab(fxId);
    }

    private void openErrorDialog(String msg) {
        Alert alert = new Alert(Alert.AlertType.ERROR, msg, new ButtonType[0]);
        alert.setTitle(this.util.getBundle().getString("ALERT_TITLE"));
        alert.showAndWait();
    }

    private class StateChangeListener
    implements PropertyChangeListener {
        private StateChangeListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent event) {
            SidTune sidTune = JSidPlay2.this.util.getPlayer().getTune();
            Platform.runLater(() -> {
                if (event.getNewValue() == State.START) {
                    boolean doNotSwitch;
                    Tab selectedItem = (Tab)JSidPlay2.this.tabbedPane.getSelectionModel().getSelectedItem();
                    boolean bl = doNotSwitch = selectedItem != null && (MusicCollection.class.isAssignableFrom(selectedItem.getContent().getClass()) || Favorites.class.isAssignableFrom(selectedItem.getContent().getClass()));
                    if (sidTune == SidTune.RESET || !MP3Tune.class.isAssignableFrom(sidTune.getClass()) && sidTune.getInfo().getPlayAddr() == 0 && !doNotSwitch) {
                        JSidPlay2.this.addView("VIDEO");
                    }
                } else if (event.getNewValue().equals((Object)State.END)) {
                    SidPlay2Section sidplay2Section = JSidPlay2.this.util.getConfig().getSidplay2Section();
                    PlaybackType pt = sidplay2Section.getPlaybackType();
                    if ((!sidplay2Section.isLoop() || JSidPlay2.this.util.getPlayer().getAudioDriver().isRecording()) && pt == PlaybackType.RANDOM_HVSC) {
                        JSidPlay2.this.playNextRandomHVSC();
                    }
                }
                if ((event.getNewValue() == State.END || event.getNewValue() == State.QUIT) && JSidPlay2.this.util.getPlayer().getAudioDriver().isRecording() && !Arrays.asList(Audio.LIVE_VIDEO_STREAMING, Audio.LIVE_SID_DUMP, Audio.LIVE_SID_REG).contains((Object)JSidPlay2.this.util.getPlayer().getAudio())) {
                    ResourceBundle bundle = JSidPlay2.this.util.getBundle();
                    C64Window window = JSidPlay2.this.util.getWindow();
                    Player player = JSidPlay2.this.util.getPlayer();
                    String fxId = "VIDEOPLAYER";
                    if (!JSidPlay2.this.tabAlreadyOpen(fxId)) {
                        JSidPlay2.this.addTab(new Tab(bundle.getString(fxId), (Node)new VideoPlayer(window, player)), fxId);
                    }
                    Platform.runLater(() -> JSidPlay2.this.selectTab(fxId));
                }
            });
        }
    }
}

