#include "ByteBufferNative.h"
#include "ByteBuffer.h"
#include "ByteOrder.h"
#include "../lang/UnsupportedOperationException.h"
#include "../../org/teavm/runtime/Allocator.h"
#include "../../org/teavm/runtime/ExceptionHandling.h"
#include "Buffer.h"
#include "BufferUnderflowException.h"
#include "../lang/IndexOutOfBoundsException.h"
#include "ReadOnlyBufferException.h"
#include "../lang/Short.h"
#include "BufferOverflowException.h"
#include "ShortBufferNative.h"
#include "../lang/Integer.h"
#include "IntBufferNative.h"
#include <string.h>
#include "ArrayBufferViewProvider.h"
#include "NativeBuffer.h"
#include "file/AddressBasedBuffer.h"
#include "../../../strings.h"
#include "../lang/Object.h"

void meth_jn_ByteBufferNative__init_(void* teavm_this_, void* teavm_local_1, TeaVM_Array* teavm_local_2, int32_t teavm_local_3, void* teavm_local_4, void* teavm_local_5, int32_t teavm_local_6, int32_t teavm_local_7) {
    TEAVM_ALLOC_STACK(INT32_C(0));
    TEAVM_WITH_CALL_SITE_ID(11667, meth_jn_ByteBuffer__init_(teavm_this_));
    if ((teavm_local_1 == NULL)) {
        teavm_local_1 = teavm_this_;
    }
    teavm_gc_writeBarrier(teavm_this_);
    TEAVM_FIELD(teavm_this_, cls_jn_ByteBufferNative, fld_gcRef) = teavm_local_1;
    TEAVM_FIELD(teavm_this_, cls_jn_ByteBufferNative, fld_array) = teavm_local_2;
    TEAVM_FIELD(teavm_this_, cls_jn_ByteBufferNative, fld_arrayOffset) = teavm_local_3;
    TEAVM_FIELD(teavm_this_, cls_jn_ByteBufferNative, fld_base) = teavm_local_4;
    TEAVM_FIELD(teavm_this_, cls_jn_ByteBufferNative, fld_address) = teavm_local_5;
    TEAVM_FIELD(teavm_this_, cls_jn_ByteBufferNative, fld_capacity) = teavm_local_6;
    TEAVM_FIELD(teavm_this_, cls_jn_ByteBufferNative, fld_readOnly) = teavm_local_7;
    TEAVM_WITH_CALL_SITE_ID(11668, meth_jn_ByteBufferNative_updateSwap(teavm_this_));
    TEAVM_RELEASE_STACK;
}
void meth_jn_ByteBufferNative_onOrderChanged(void* teavm_this_) {
    TEAVM_ALLOC_STACK(INT32_C(0));
    TEAVM_WITH_CALL_SITE_ID(11669, meth_jn_ByteBufferNative_updateSwap(teavm_this_));
    TEAVM_RELEASE_STACK;
}
void meth_jn_ByteBufferNative_updateSwap(void* teavm_this_) {
    void* teavm_local_1;
    TEAVM_ALLOC_STACK(INT32_C(1));
    teavm_local_1 = TEAVM_FIELD(teavm_this_, cls_jn_ByteBuffer, fld_order);
    TEAVM_GC_ROOT(INT32_C(0), teavm_local_1);
    TEAVM_FIELD(teavm_this_, cls_jn_ByteBufferNative, fld_swap) = ((teavm_local_1 == TEAVM_WITH_CALL_SITE_ID(11670, meth_jn_ByteOrder_nativeOrder())) ? INT32_C(0) : INT32_C(1));
    TEAVM_RELEASE_STACK;
}
TeaVM_Array* meth_jn_ByteBufferNative_arrayImpl(void* teavm_this_) {
    TeaVM_Array* teavm_local_1;
    void* teavm_local_2;
    TEAVM_ALLOC_STACK(INT32_C(1));
    if ((TEAVM_FIELD(teavm_this_, cls_jn_ByteBufferNative, fld_array) != NULL)) {
        teavm_local_1 = TEAVM_FIELD(teavm_this_, cls_jn_ByteBufferNative, fld_array);
        TEAVM_RELEASE_STACK;
        return teavm_local_1;
    }
    TEAVM_GC_ROOT_RELEASE(INT32_C(0));
    teavm_local_2 = TEAVM_WITH_CALL_SITE_ID(11671, meth_otr_Allocator_allocate(&jl_UnsupportedOperationException_Cls));
    TEAVM_GC_ROOT(INT32_C(0), teavm_local_2);
    TEAVM_WITH_CALL_SITE_ID(11672, meth_jl_UnsupportedOperationException__init_(teavm_local_2));
    TEAVM_WITH_CALL_SITE_ID(11673, meth_otr_ExceptionHandling_throwException(teavm_local_2));
    TEAVM_UNREACHABLE
}
int32_t meth_jn_ByteBufferNative_arrayOffsetImpl(void* teavm_this_) {
    int32_t teavm_local_1;
    void* teavm_local_2;
    TEAVM_ALLOC_STACK(INT32_C(1));
    if ((TEAVM_FIELD(teavm_this_, cls_jn_ByteBufferNative, fld_array) != NULL)) {
        teavm_local_1 = TEAVM_FIELD(teavm_this_, cls_jn_ByteBufferNative, fld_arrayOffset);
        TEAVM_RELEASE_STACK;
        return teavm_local_1;
    }
    TEAVM_GC_ROOT_RELEASE(INT32_C(0));
    teavm_local_2 = TEAVM_WITH_CALL_SITE_ID(11674, meth_otr_Allocator_allocate(&jl_UnsupportedOperationException_Cls));
    TEAVM_GC_ROOT(INT32_C(0), teavm_local_2);
    TEAVM_WITH_CALL_SITE_ID(11675, meth_jl_UnsupportedOperationException__init_(teavm_local_2));
    TEAVM_WITH_CALL_SITE_ID(11676, meth_otr_ExceptionHandling_throwException(teavm_local_2));
    TEAVM_UNREACHABLE
}
int32_t meth_jn_ByteBufferNative_hasArrayImpl(void* teavm_this_) {
    return ((TEAVM_FIELD(teavm_this_, cls_jn_ByteBufferNative, fld_array) == NULL) ? INT32_C(0) : INT32_C(1));
}
int32_t meth_jn_ByteBufferNative_capacityImpl(void* teavm_this_) {
    return TEAVM_FIELD(teavm_this_, cls_jn_ByteBufferNative, fld_capacity);
}
void meth_jn_ByteBufferNative_getImpl(void* teavm_this_, int32_t teavm_local_1, TeaVM_Array* teavm_local_2, int32_t teavm_local_3, int32_t teavm_local_4) {
    TEAVM_ALLOC_STACK(INT32_C(0));
    TEAVM_WITH_CALL_SITE_ID(11677, TEAVM_METHOD(teavm_this_, jn_ByteBufferNative_VT, virt_copy)(teavm_this_, TEAVM_ADDRESS_ADD(TEAVM_FIELD(teavm_this_, cls_jn_ByteBufferNative, fld_address), teavm_local_1), teavm_local_2, teavm_local_3, teavm_local_4));
    TEAVM_RELEASE_STACK;
}
void meth_jn_ByteBufferNative_putImpl(void* teavm_this_, int32_t teavm_local_1, void* teavm_local_2, int32_t teavm_local_3, int32_t teavm_local_4) {
    void* teavm_local_5;
    void* teavm_local_6;
    void* teavm_local_7;
    TeaVM_Array* teavm_local_8;
    int32_t teavm_local_9;
    void* teavm_local_10;
    int32_t teavm_local_11;
    TEAVM_ALLOC_STACK(INT32_C(2));
    if (teavm_instanceof(teavm_local_2, supertypeof_jn_ByteBufferNative)) {
        TEAVM_GC_ROOT_RELEASE(INT32_C(0));
        TEAVM_GC_ROOT_RELEASE(INT32_C(1));
        teavm_local_5 = TEAVM_WITH_CALL_SITE_ID(11678, teavm_checkcast(teavm_local_2, supertypeof_jn_ByteBufferNative));
        TEAVM_GC_ROOT(INT32_C(0), teavm_local_5);
        teavm_local_5 = TEAVM_WITH_CALL_SITE_ID(11679, teavm_nullCheck(teavm_local_5));
        teavm_local_6 = TEAVM_ADDRESS_ADD(TEAVM_FIELD(teavm_local_5, cls_jn_ByteBufferNative, fld_address), teavm_local_3);
        teavm_local_7 = TEAVM_ADDRESS_ADD(TEAVM_FIELD(teavm_this_, cls_jn_ByteBufferNative, fld_address), teavm_local_1);
        TEAVM_GC_ROOT_RELEASE(INT32_C(0));
        TEAVM_WITH_CALL_SITE_ID(11680, meth_jn_ByteBufferNative_copy(teavm_local_6, teavm_local_7, teavm_local_4));
    } else {
        TEAVM_GC_ROOT_RELEASE(INT32_C(0));
        TEAVM_GC_ROOT_RELEASE(INT32_C(1));
        teavm_local_2 = TEAVM_WITH_CALL_SITE_ID(11681, teavm_nullCheck(teavm_local_2));
        TEAVM_GC_ROOT(INT32_C(0), teavm_local_2);
        if (TEAVM_WITH_CALL_SITE_ID(11682, meth_jn_ByteBuffer_hasArray(teavm_local_2))) {
            teavm_local_8 = TEAVM_WITH_CALL_SITE_ID(11683, meth_jn_ByteBuffer_array(teavm_local_2));
            TEAVM_GC_ROOT(INT32_C(1), teavm_local_8);
            teavm_local_9 = ((teavm_local_3 + TEAVM_WITH_CALL_SITE_ID(11684, meth_jn_ByteBuffer_arrayOffset(teavm_local_2))) + teavm_local_3);
            teavm_local_6 = TEAVM_ADDRESS_ADD(TEAVM_FIELD(teavm_this_, cls_jn_ByteBufferNative, fld_address), teavm_local_1);
            TEAVM_GC_ROOT_RELEASE(INT32_C(0));
            TEAVM_WITH_CALL_SITE_ID(11685, TEAVM_METHOD(teavm_this_, jn_ByteBufferNative_VT, virt_copy_0)(teavm_this_, teavm_local_8, teavm_local_9, teavm_local_6, teavm_local_4));
        } else {
            teavm_local_10 = TEAVM_ADDRESS_ADD(TEAVM_FIELD(teavm_this_, cls_jn_ByteBufferNative, fld_address), teavm_local_1);
            while (1) {
                teavm_local_9 = (teavm_local_4 + -INT32_C(1));
                if ((teavm_local_4 <= INT32_C(0))) {
                    goto teavm_label_1;
                }
                teavm_local_11 = (teavm_local_3 + INT32_C(1));
                (*(int8_t*) teavm_local_10 = (int8_t) TEAVM_WITH_CALL_SITE_ID(11686, TEAVM_METHOD(teavm_local_2, jn_ByteBuffer_VT, virt_get_12)(teavm_local_2, teavm_local_3)));
                teavm_local_10 = TEAVM_ADDRESS_ADD(teavm_local_10, INT32_C(1));
                teavm_local_4 = teavm_local_9;
                teavm_local_3 = teavm_local_11;
            }
        }
    }
teavm_label_1:;
    TEAVM_RELEASE_STACK;
}
void meth_jn_ByteBufferNative_putImpl_0(void* teavm_this_, TeaVM_Array* teavm_local_1, int32_t teavm_local_2, int32_t teavm_local_3, int32_t teavm_local_4) {
    TEAVM_ALLOC_STACK(INT32_C(0));
    TEAVM_WITH_CALL_SITE_ID(11687, TEAVM_METHOD(teavm_this_, jn_ByteBufferNative_VT, virt_copy_0)(teavm_this_, teavm_local_1, teavm_local_2, TEAVM_ADDRESS_ADD(TEAVM_FIELD(teavm_this_, cls_jn_ByteBufferNative, fld_address), teavm_local_3), teavm_local_4));
    TEAVM_RELEASE_STACK;
}
void* meth_jn_ByteBufferNative_asReadOnlyBuffer(void* teavm_this_) {
    void* teavm_local_1;
    void* teavm_local_2;
    TeaVM_Array* teavm_local_3;
    int32_t teavm_local_4;
    void* teavm_local_5;
    void* teavm_local_6;
    int32_t teavm_local_7;
    TEAVM_ALLOC_STACK(INT32_C(4));
    TEAVM_GC_ROOT_RELEASE(INT32_C(0));
    TEAVM_GC_ROOT_RELEASE(INT32_C(1));
    TEAVM_GC_ROOT_RELEASE(INT32_C(2));
    TEAVM_GC_ROOT_RELEASE(INT32_C(3));
    teavm_local_1 = TEAVM_WITH_CALL_SITE_ID(11688, meth_otr_Allocator_allocate(&jn_ByteBufferNative_Cls));
    teavm_local_2 = TEAVM_FIELD(teavm_this_, cls_jn_ByteBufferNative, fld_gcRef);
    teavm_local_3 = TEAVM_FIELD(teavm_this_, cls_jn_ByteBufferNative, fld_array);
    teavm_local_4 = (TEAVM_FIELD(teavm_this_, cls_jn_ByteBufferNative, fld_arrayOffset) + TEAVM_FIELD(teavm_this_, cls_jn_Buffer, fld_position));
    teavm_local_5 = TEAVM_FIELD(teavm_this_, cls_jn_ByteBufferNative, fld_base);
    teavm_local_6 = TEAVM_FIELD(teavm_this_, cls_jn_ByteBufferNative, fld_address);
    teavm_local_7 = TEAVM_FIELD(teavm_this_, cls_jn_ByteBufferNative, fld_capacity);
    TEAVM_GC_ROOT(INT32_C(0), teavm_local_1);
    TEAVM_GC_ROOT(INT32_C(1), teavm_local_2);
    TEAVM_GC_ROOT(INT32_C(2), teavm_local_3);
    TEAVM_GC_ROOT(INT32_C(3), teavm_local_5);
    TEAVM_WITH_CALL_SITE_ID(11689, meth_jn_ByteBufferNative__init_(teavm_local_1, teavm_local_2, teavm_local_3, teavm_local_4, teavm_local_5, teavm_local_6, teavm_local_7, INT32_C(1)));
    TEAVM_FIELD(teavm_local_1, cls_jn_Buffer, fld_position) = TEAVM_FIELD(teavm_this_, cls_jn_Buffer, fld_position);
    TEAVM_FIELD(teavm_local_1, cls_jn_Buffer, fld_limit) = TEAVM_FIELD(teavm_this_, cls_jn_Buffer, fld_limit);
    TEAVM_FIELD(teavm_local_1, cls_jn_Buffer, fld_mark) = TEAVM_FIELD(teavm_this_, cls_jn_Buffer, fld_mark);
    if ((!(((TeaVM_Class *) &jn_ByteOrder_Cls)->flags & INT32_C(1)))) {
        TEAVM_GC_ROOT_RELEASE(INT32_C(1));
        TEAVM_GC_ROOT_RELEASE(INT32_C(2));
        TEAVM_GC_ROOT_RELEASE(INT32_C(3));
        TEAVM_WITH_CALL_SITE_ID(11690, initclass_jn_ByteOrder());
    }
    teavm_local_2 = sfld_jn_ByteOrder_BIG_ENDIAN;
    teavm_gc_writeBarrier(teavm_local_1);
    TEAVM_FIELD(teavm_local_1, cls_jn_ByteBuffer, fld_order) = teavm_local_2;
    TEAVM_RELEASE_STACK;
    return teavm_local_1;
}
int32_t meth_jn_ByteBufferNative_get(void* teavm_this_) {
    void* teavm_local_1;
    int32_t teavm_local_2;
    int32_t teavm_local_3;
    TEAVM_ALLOC_STACK(INT32_C(1));
    if ((TEAVM_FIELD(teavm_this_, cls_jn_Buffer, fld_position) >= TEAVM_FIELD(teavm_this_, cls_jn_Buffer, fld_limit))) {
        TEAVM_GC_ROOT_RELEASE(INT32_C(0));
        teavm_local_1 = TEAVM_WITH_CALL_SITE_ID(11691, meth_otr_Allocator_allocate(&jn_BufferUnderflowException_Cls));
        TEAVM_GC_ROOT(INT32_C(0), teavm_local_1);
        TEAVM_WITH_CALL_SITE_ID(11692, meth_jn_BufferUnderflowException__init_(teavm_local_1));
        TEAVM_WITH_CALL_SITE_ID(11693, meth_otr_ExceptionHandling_throwException(teavm_local_1));
        TEAVM_UNREACHABLE
    }
    teavm_local_1 = TEAVM_FIELD(teavm_this_, cls_jn_ByteBufferNative, fld_address);
    teavm_local_2 = TEAVM_FIELD(teavm_this_, cls_jn_Buffer, fld_position);
    TEAVM_FIELD(teavm_this_, cls_jn_Buffer, fld_position) = (teavm_local_2 + INT32_C(1));
    teavm_local_3 = ((int32_t) *(int8_t*) TEAVM_ADDRESS_ADD(teavm_local_1, teavm_local_2));
    TEAVM_RELEASE_STACK;
    return teavm_local_3;
}
int32_t meth_jn_ByteBufferNative_get_0(void* teavm_this_, int32_t teavm_local_1) {
    int32_t teavm_local_2;
    void* teavm_local_3;
    TEAVM_ALLOC_STACK(INT32_C(1));
    if (((teavm_local_1 >= INT32_C(0)) && (teavm_local_1 < TEAVM_FIELD(teavm_this_, cls_jn_Buffer, fld_limit)))) {
        teavm_local_2 = ((int32_t) *(int8_t*) TEAVM_ADDRESS_ADD(TEAVM_FIELD(teavm_this_, cls_jn_ByteBufferNative, fld_address), teavm_local_1));
        TEAVM_RELEASE_STACK;
        return teavm_local_2;
    }
    TEAVM_GC_ROOT_RELEASE(INT32_C(0));
    teavm_local_3 = TEAVM_WITH_CALL_SITE_ID(11694, meth_otr_Allocator_allocate(&jl_IndexOutOfBoundsException_Cls));
    TEAVM_GC_ROOT(INT32_C(0), teavm_local_3);
    TEAVM_WITH_CALL_SITE_ID(11695, meth_jl_IndexOutOfBoundsException__init_(teavm_local_3));
    TEAVM_WITH_CALL_SITE_ID(11696, meth_otr_ExceptionHandling_throwException(teavm_local_3));
    TEAVM_UNREACHABLE
}
void* meth_jn_ByteBufferNative_compact(void* teavm_this_) {
    void* teavm_local_1;
    int32_t teavm_local_2;
    TEAVM_ALLOC_STACK(INT32_C(1));
    if (TEAVM_FIELD(teavm_this_, cls_jn_ByteBufferNative, fld_readOnly)) {
        TEAVM_GC_ROOT_RELEASE(INT32_C(0));
        teavm_local_1 = TEAVM_WITH_CALL_SITE_ID(11697, meth_otr_Allocator_allocate(&jn_ReadOnlyBufferException_Cls));
        TEAVM_GC_ROOT(INT32_C(0), teavm_local_1);
        TEAVM_WITH_CALL_SITE_ID(11698, meth_jn_ReadOnlyBufferException__init_(teavm_local_1));
        TEAVM_WITH_CALL_SITE_ID(11699, meth_otr_ExceptionHandling_throwException(teavm_local_1));
        TEAVM_UNREACHABLE
    }
    TEAVM_GC_ROOT_RELEASE(INT32_C(0));
    teavm_local_2 = TEAVM_WITH_CALL_SITE_ID(11700, meth_jn_Buffer_remaining(teavm_this_));
    if ((TEAVM_FIELD(teavm_this_, cls_jn_Buffer, fld_position) > INT32_C(0))) {
        TEAVM_WITH_CALL_SITE_ID(11701, meth_jn_ByteBufferNative_copy(TEAVM_ADDRESS_ADD(TEAVM_FIELD(teavm_this_, cls_jn_ByteBufferNative, fld_address), TEAVM_FIELD(teavm_this_, cls_jn_Buffer, fld_position)), TEAVM_FIELD(teavm_this_, cls_jn_ByteBufferNative, fld_address), teavm_local_2));
    }
    TEAVM_FIELD(teavm_this_, cls_jn_Buffer, fld_position) = teavm_local_2;
    TEAVM_FIELD(teavm_this_, cls_jn_Buffer, fld_limit) = TEAVM_WITH_CALL_SITE_ID(11702, meth_jn_Buffer_capacity(teavm_this_));
    TEAVM_FIELD(teavm_this_, cls_jn_Buffer, fld_mark) = -INT32_C(1);
    TEAVM_RELEASE_STACK;
    return teavm_this_;
}
int32_t meth_jn_ByteBufferNative_isReadOnly(void* teavm_this_) {
    return TEAVM_FIELD(teavm_this_, cls_jn_ByteBufferNative, fld_readOnly);
}
int32_t meth_jn_ByteBufferNative_getShort(void* teavm_this_) {
    void* teavm_local_1;
    int32_t teavm_local_2;
    TEAVM_ALLOC_STACK(INT32_C(1));
    if (((TEAVM_FIELD(teavm_this_, cls_jn_Buffer, fld_position) + INT32_C(1)) >= TEAVM_FIELD(teavm_this_, cls_jn_Buffer, fld_limit))) {
        TEAVM_GC_ROOT_RELEASE(INT32_C(0));
        teavm_local_1 = TEAVM_WITH_CALL_SITE_ID(11703, meth_otr_Allocator_allocate(&jn_BufferUnderflowException_Cls));
        TEAVM_GC_ROOT(INT32_C(0), teavm_local_1);
        TEAVM_WITH_CALL_SITE_ID(11704, meth_jn_BufferUnderflowException__init_(teavm_local_1));
        TEAVM_WITH_CALL_SITE_ID(11705, meth_otr_ExceptionHandling_throwException(teavm_local_1));
        TEAVM_UNREACHABLE
    }
    teavm_local_2 = ((int32_t) *(int16_t*) TEAVM_ADDRESS_ADD(TEAVM_FIELD(teavm_this_, cls_jn_ByteBufferNative, fld_address), TEAVM_FIELD(teavm_this_, cls_jn_Buffer, fld_position)));
    TEAVM_FIELD(teavm_this_, cls_jn_Buffer, fld_position) = (TEAVM_FIELD(teavm_this_, cls_jn_Buffer, fld_position) + INT32_C(2));
    if (TEAVM_FIELD(teavm_this_, cls_jn_ByteBufferNative, fld_swap)) {
        TEAVM_GC_ROOT_RELEASE(INT32_C(0));
        teavm_local_2 = TEAVM_WITH_CALL_SITE_ID(11706, meth_jl_Short_reverseBytes(teavm_local_2));
    }
    TEAVM_RELEASE_STACK;
    return teavm_local_2;
}
void* meth_jn_ByteBufferNative_putShort(void* teavm_this_, int32_t teavm_local_1) {
    void* teavm_local_2;
    TEAVM_ALLOC_STACK(INT32_C(1));
    if (TEAVM_FIELD(teavm_this_, cls_jn_ByteBufferNative, fld_readOnly)) {
        TEAVM_GC_ROOT_RELEASE(INT32_C(0));
        teavm_local_2 = TEAVM_WITH_CALL_SITE_ID(11707, meth_otr_Allocator_allocate(&jn_ReadOnlyBufferException_Cls));
        TEAVM_GC_ROOT(INT32_C(0), teavm_local_2);
        TEAVM_WITH_CALL_SITE_ID(11708, meth_jn_ReadOnlyBufferException__init_(teavm_local_2));
        TEAVM_WITH_CALL_SITE_ID(11709, meth_otr_ExceptionHandling_throwException(teavm_local_2));
        TEAVM_UNREACHABLE
    }
    if (((TEAVM_FIELD(teavm_this_, cls_jn_Buffer, fld_position) + INT32_C(1)) >= TEAVM_FIELD(teavm_this_, cls_jn_Buffer, fld_limit))) {
        TEAVM_GC_ROOT_RELEASE(INT32_C(0));
        teavm_local_2 = TEAVM_WITH_CALL_SITE_ID(11710, meth_otr_Allocator_allocate(&jn_BufferOverflowException_Cls));
        TEAVM_GC_ROOT(INT32_C(0), teavm_local_2);
        TEAVM_WITH_CALL_SITE_ID(11711, meth_jn_BufferOverflowException__init_(teavm_local_2));
        TEAVM_WITH_CALL_SITE_ID(11712, meth_otr_ExceptionHandling_throwException(teavm_local_2));
        TEAVM_UNREACHABLE
    }
    teavm_local_2 = TEAVM_ADDRESS_ADD(TEAVM_FIELD(teavm_this_, cls_jn_ByteBufferNative, fld_address), TEAVM_FIELD(teavm_this_, cls_jn_Buffer, fld_position));
    if (TEAVM_FIELD(teavm_this_, cls_jn_ByteBufferNative, fld_swap)) {
        TEAVM_GC_ROOT_RELEASE(INT32_C(0));
        teavm_local_1 = TEAVM_WITH_CALL_SITE_ID(11713, meth_jl_Short_reverseBytes(teavm_local_1));
    }
    (*(int16_t*) teavm_local_2 = (int16_t) teavm_local_1);
    TEAVM_FIELD(teavm_this_, cls_jn_Buffer, fld_position) = (TEAVM_FIELD(teavm_this_, cls_jn_Buffer, fld_position) + INT32_C(2));
    TEAVM_RELEASE_STACK;
    return teavm_this_;
}
void* meth_jn_ByteBufferNative_asShortBuffer(void* teavm_this_) {
    int32_t teavm_local_1;
    void* teavm_local_2;
    void* teavm_local_3;
    void* teavm_local_4;
    int32_t teavm_local_5;
    void* teavm_local_6;
    void* teavm_local_7;
    int32_t teavm_local_8;
    TEAVM_ALLOC_STACK(INT32_C(3));
    TEAVM_GC_ROOT_RELEASE(INT32_C(0));
    TEAVM_GC_ROOT_RELEASE(INT32_C(1));
    TEAVM_GC_ROOT_RELEASE(INT32_C(2));
    teavm_local_1 = (TEAVM_WITH_CALL_SITE_ID(11714, meth_jn_Buffer_remaining(teavm_this_)) / INT32_C(2));
    teavm_local_2 = TEAVM_WITH_CALL_SITE_ID(11715, meth_otr_Allocator_allocate(&jn_ShortBufferNative_Cls));
    teavm_local_3 = TEAVM_FIELD(teavm_this_, cls_jn_ByteBufferNative, fld_gcRef);
    teavm_local_4 = NULL;
    teavm_local_5 = TEAVM_FIELD(teavm_this_, cls_jn_ByteBufferNative, fld_readOnly);
    teavm_local_6 = TEAVM_FIELD(teavm_this_, cls_jn_ByteBufferNative, fld_base);
    teavm_local_7 = TEAVM_ADDRESS_ADD(TEAVM_FIELD(teavm_this_, cls_jn_ByteBufferNative, fld_address), TEAVM_FIELD(teavm_this_, cls_jn_Buffer, fld_position));
    teavm_local_8 = TEAVM_FIELD(teavm_this_, cls_jn_ByteBufferNative, fld_swap);
    TEAVM_GC_ROOT(INT32_C(0), teavm_local_2);
    TEAVM_GC_ROOT(INT32_C(1), teavm_local_3);
    TEAVM_GC_ROOT(INT32_C(2), teavm_local_6);
    TEAVM_WITH_CALL_SITE_ID(11716, meth_jn_ShortBufferNative__init_(teavm_local_2, teavm_local_3, teavm_local_4, INT32_C(0), teavm_local_1, teavm_local_5, teavm_local_6, teavm_local_7, teavm_local_1, teavm_local_8));
    TEAVM_RELEASE_STACK;
    return teavm_local_2;
}
int32_t meth_jn_ByteBufferNative_getInt(void* teavm_this_) {
    void* teavm_local_1;
    int32_t teavm_local_2;
    TEAVM_ALLOC_STACK(INT32_C(1));
    if (((TEAVM_FIELD(teavm_this_, cls_jn_Buffer, fld_position) + INT32_C(3)) >= TEAVM_FIELD(teavm_this_, cls_jn_Buffer, fld_limit))) {
        TEAVM_GC_ROOT_RELEASE(INT32_C(0));
        teavm_local_1 = TEAVM_WITH_CALL_SITE_ID(11717, meth_otr_Allocator_allocate(&jn_BufferUnderflowException_Cls));
        TEAVM_GC_ROOT(INT32_C(0), teavm_local_1);
        TEAVM_WITH_CALL_SITE_ID(11718, meth_jn_BufferUnderflowException__init_(teavm_local_1));
        TEAVM_WITH_CALL_SITE_ID(11719, meth_otr_ExceptionHandling_throwException(teavm_local_1));
        TEAVM_UNREACHABLE
    }
    teavm_local_2 = (*(int32_t*) TEAVM_ADDRESS_ADD(TEAVM_FIELD(teavm_this_, cls_jn_ByteBufferNative, fld_address), TEAVM_FIELD(teavm_this_, cls_jn_Buffer, fld_position)));
    TEAVM_FIELD(teavm_this_, cls_jn_Buffer, fld_position) = (TEAVM_FIELD(teavm_this_, cls_jn_Buffer, fld_position) + INT32_C(4));
    if (TEAVM_FIELD(teavm_this_, cls_jn_ByteBufferNative, fld_swap)) {
        TEAVM_GC_ROOT_RELEASE(INT32_C(0));
        teavm_local_2 = TEAVM_WITH_CALL_SITE_ID(11720, meth_jl_Integer_reverseBytes(teavm_local_2));
    }
    TEAVM_RELEASE_STACK;
    return teavm_local_2;
}
void* meth_jn_ByteBufferNative_putInt(void* teavm_this_, int32_t teavm_local_1) {
    void* teavm_local_2;
    TEAVM_ALLOC_STACK(INT32_C(1));
    if (TEAVM_FIELD(teavm_this_, cls_jn_ByteBufferNative, fld_readOnly)) {
        TEAVM_GC_ROOT_RELEASE(INT32_C(0));
        teavm_local_2 = TEAVM_WITH_CALL_SITE_ID(11721, meth_otr_Allocator_allocate(&jn_ReadOnlyBufferException_Cls));
        TEAVM_GC_ROOT(INT32_C(0), teavm_local_2);
        TEAVM_WITH_CALL_SITE_ID(11722, meth_jn_ReadOnlyBufferException__init_(teavm_local_2));
        TEAVM_WITH_CALL_SITE_ID(11723, meth_otr_ExceptionHandling_throwException(teavm_local_2));
        TEAVM_UNREACHABLE
    }
    if (((TEAVM_FIELD(teavm_this_, cls_jn_Buffer, fld_position) + INT32_C(3)) >= TEAVM_FIELD(teavm_this_, cls_jn_Buffer, fld_limit))) {
        TEAVM_GC_ROOT_RELEASE(INT32_C(0));
        teavm_local_2 = TEAVM_WITH_CALL_SITE_ID(11724, meth_otr_Allocator_allocate(&jn_BufferOverflowException_Cls));
        TEAVM_GC_ROOT(INT32_C(0), teavm_local_2);
        TEAVM_WITH_CALL_SITE_ID(11725, meth_jn_BufferOverflowException__init_(teavm_local_2));
        TEAVM_WITH_CALL_SITE_ID(11726, meth_otr_ExceptionHandling_throwException(teavm_local_2));
        TEAVM_UNREACHABLE
    }
    teavm_local_2 = TEAVM_ADDRESS_ADD(TEAVM_FIELD(teavm_this_, cls_jn_ByteBufferNative, fld_address), TEAVM_FIELD(teavm_this_, cls_jn_Buffer, fld_position));
    if (TEAVM_FIELD(teavm_this_, cls_jn_ByteBufferNative, fld_swap)) {
        TEAVM_GC_ROOT_RELEASE(INT32_C(0));
        teavm_local_1 = TEAVM_WITH_CALL_SITE_ID(11727, meth_jl_Integer_reverseBytes(teavm_local_1));
    }
    (*(int32_t*) teavm_local_2 = teavm_local_1);
    TEAVM_FIELD(teavm_this_, cls_jn_Buffer, fld_position) = (TEAVM_FIELD(teavm_this_, cls_jn_Buffer, fld_position) + INT32_C(4));
    TEAVM_RELEASE_STACK;
    return teavm_this_;
}
void* meth_jn_ByteBufferNative_asIntBuffer(void* teavm_this_) {
    int32_t teavm_local_1;
    void* teavm_local_2;
    void* teavm_local_3;
    void* teavm_local_4;
    int32_t teavm_local_5;
    void* teavm_local_6;
    void* teavm_local_7;
    int32_t teavm_local_8;
    TEAVM_ALLOC_STACK(INT32_C(3));
    TEAVM_GC_ROOT_RELEASE(INT32_C(0));
    TEAVM_GC_ROOT_RELEASE(INT32_C(1));
    TEAVM_GC_ROOT_RELEASE(INT32_C(2));
    teavm_local_1 = (TEAVM_WITH_CALL_SITE_ID(11728, meth_jn_Buffer_remaining(teavm_this_)) / INT32_C(4));
    teavm_local_2 = TEAVM_WITH_CALL_SITE_ID(11729, meth_otr_Allocator_allocate(&jn_IntBufferNative_Cls));
    teavm_local_3 = TEAVM_FIELD(teavm_this_, cls_jn_ByteBufferNative, fld_gcRef);
    teavm_local_4 = NULL;
    teavm_local_5 = TEAVM_FIELD(teavm_this_, cls_jn_ByteBufferNative, fld_readOnly);
    teavm_local_6 = TEAVM_FIELD(teavm_this_, cls_jn_ByteBufferNative, fld_base);
    teavm_local_7 = TEAVM_ADDRESS_ADD(TEAVM_FIELD(teavm_this_, cls_jn_ByteBufferNative, fld_address), TEAVM_FIELD(teavm_this_, cls_jn_Buffer, fld_position));
    teavm_local_8 = TEAVM_FIELD(teavm_this_, cls_jn_ByteBufferNative, fld_swap);
    TEAVM_GC_ROOT(INT32_C(0), teavm_local_2);
    TEAVM_GC_ROOT(INT32_C(1), teavm_local_3);
    TEAVM_GC_ROOT(INT32_C(2), teavm_local_6);
    TEAVM_WITH_CALL_SITE_ID(11730, meth_jn_IntBufferNative__init_(teavm_local_2, teavm_local_3, teavm_local_4, INT32_C(0), teavm_local_1, teavm_local_5, teavm_local_6, teavm_local_7, teavm_local_1, teavm_local_8));
    TEAVM_RELEASE_STACK;
    return teavm_local_2;
}
void meth_jn_ByteBufferNative_copy_0(void* teavm_this_, TeaVM_Array* teavm_local_1, int32_t teavm_local_2, void* teavm_local_3, int32_t teavm_local_4) {
    TEAVM_ALLOC_STACK(INT32_C(0));
    TEAVM_WITH_CALL_SITE_ID(11731, meth_jn_ByteBufferNative_copy(TEAVM_ADDRESS_ADD(TEAVM_ARRAY_DATA(teavm_local_1, int32_t), teavm_local_2), teavm_local_3, teavm_local_4));
    TEAVM_RELEASE_STACK;
}
void meth_jn_ByteBufferNative_copy_1(void* teavm_this_, void* teavm_local_1, TeaVM_Array* teavm_local_2, int32_t teavm_local_3, int32_t teavm_local_4) {
    TEAVM_ALLOC_STACK(INT32_C(0));
    TEAVM_WITH_CALL_SITE_ID(11732, meth_jn_ByteBufferNative_copy(teavm_local_1, TEAVM_ADDRESS_ADD(TEAVM_ARRAY_DATA(teavm_local_2, int32_t), teavm_local_3), teavm_local_4));
    TEAVM_RELEASE_STACK;
}
void meth_jn_ByteBufferNative_copy(void* teavm_local_1, void* teavm_local_2, int32_t teavm_local_3) {
    memmove(teavm_local_2, teavm_local_1, teavm_local_3);
}
int32_t supertypeof_jn_ByteBufferNative(TeaVM_Class* cls) {
    int32_t tag = cls->tag;
    if (tag < 135 || tag >= 137) return INT32_C(0);
    return INT32_C(1);
}
static int16_t teavm_classLayouts_jn_ByteBufferNative_Cls[4];
alignas(8) jn_ByteBufferNative_VT jn_ByteBufferNative_Cls = {
    .parent = {
        .parent = {
            .size = (int32_t) (intptr_t) TEAVM_ALIGN(sizeof(cls_jn_ByteBufferNative), sizeof(void*)),
            .flags = 0,
            .tag = 135,
            .canary = 0,
            .name = NULL,
            .simpleName = NULL,
            .arrayType = NULL,
            .itemType = NULL,
            .isSupertypeOf = &supertypeof_jn_ByteBufferNative,
            .superclass = (TeaVM_Class*) &jn_ByteBuffer_Cls,
            .superinterfaceCount = 3,
            .superinterfaces = (TeaVM_Class*[]) { (TeaVM_Class*) &jn_ArrayBufferViewProvider_Cls, (TeaVM_Class*) &jn_NativeBuffer_Cls, (TeaVM_Class*) &jnf_AddressBasedBuffer_Cls },
            .layout = teavm_classLayouts_jn_ByteBufferNative_Cls,
            .enumValues = (void*) offsetof(cls_jn_ByteBufferNative, fld_base),
            .declaringClass = NULL,
            .enclosingClass = NULL,
            .init = NULL
        },
        .virt_hashCode = &meth_jl_Object_hashCode,
        .virt_equals = &meth_jn_ByteBuffer_equals,
        .virt_clone = &meth_jl_Object_clone,
        .virt_toString = &meth_jl_Object_toString,
        .virt_isEmptyMonitor = &meth_jl_Object_isEmptyMonitor,
        .virt_getClass = &meth_jl_Object_getClass,
        .virt_identity = &meth_jl_Object_identity,
        .virt_putInt = &meth_jn_ByteBufferNative_putInt,
        .virt_asReadOnlyBuffer = &meth_jn_ByteBufferNative_asReadOnlyBuffer,
        .virt_isReadOnly = &meth_jn_ByteBufferNative_isReadOnly,
        .virt_clear = &meth_jn_ByteBuffer_clear_0,
        .virt_reset_1 = &meth_jn_ByteBuffer_reset,
        .virt_get_7 = &meth_jn_ByteBuffer_get,
        .virt_arrayImpl = &meth_jn_ByteBufferNative_arrayImpl,
        .virt_array_0 = &meth_jn_ByteBuffer_array,
        .virt_remaining = &meth_jn_Buffer_remaining,
        .virt_position = &meth_jn_ByteBuffer_position,
        .virt_capacityImpl = &meth_jn_ByteBufferNative_capacityImpl,
        .virt_flip = &meth_jn_ByteBuffer_flip_0,
        .virt_limit = &meth_jn_Buffer_limit,
        .virt_put_9 = &meth_jn_ByteBuffer_put_0,
        .virt_capacity = &meth_jn_Buffer_capacity,
        .virt_hasArray = &meth_jn_ByteBuffer_hasArray,
        .virt_get_13 = &meth_jn_ByteBufferNative_get,
        .virt_getInt = &meth_jn_ByteBufferNative_getInt,
        .virt_position_0 = &meth_jn_Buffer_position,
        .virt_compact_0 = &meth_jn_ByteBufferNative_compact,
        .virt_mark = &meth_jn_ByteBuffer_mark,
        .virt_putShort = &meth_jn_ByteBufferNative_putShort,
        .virt_position_2 = &meth_jn_ByteBuffer_position_0,
        .virt_putImpl_3 = &meth_jn_ByteBufferNative_putImpl,
        .virt_arrayOffsetImpl = &meth_jn_ByteBufferNative_arrayOffsetImpl,
        .virt_getShort = &meth_jn_ByteBufferNative_getShort,
        .virt_onOrderChanged = &meth_jn_ByteBufferNative_onOrderChanged,
        .virt_get_14 = &meth_jn_ByteBuffer_get_0,
        .virt_hasRemaining = &meth_jn_Buffer_hasRemaining,
        .virt_hasArrayImpl = &meth_jn_ByteBufferNative_hasArrayImpl,
        .virt_asIntBuffer = &meth_jn_ByteBufferNative_asIntBuffer,
        .virt_put_8 = &meth_jn_ByteBuffer_put_1,
        .virt_get_12 = &meth_jn_ByteBufferNative_get_0,
        .virt_asShortBuffer = &meth_jn_ByteBufferNative_asShortBuffer,
        .virt_getImpl_1 = &meth_jn_ByteBufferNative_getImpl,
        .virt_putImpl_4 = &meth_jn_ByteBufferNative_putImpl_0,
        .virt_put_10 = &meth_jn_ByteBuffer_put,
        .virt_arrayOffset = &meth_jn_ByteBuffer_arrayOffset,
        .virt_order = &meth_jn_ByteBuffer_order_0,
        .virt_order_0 = &meth_jn_ByteBuffer_order,
        .virt_mark_0 = &meth_jn_ByteBuffer_mark_0,
        .virt_reset_5 = &meth_jn_ByteBuffer_reset_0,
        .virt_clear_5 = &meth_jn_ByteBuffer_clear,
        .virt_flip_2 = &meth_jn_ByteBuffer_flip
    },
    .virt_copy_0 = &meth_jn_ByteBufferNative_copy_0,
    .virt_copy = &meth_jn_ByteBufferNative_copy_1
};
static int16_t teavm_classLayouts_jn_ByteBufferNative_Cls[4] = {
INT16_C(3), (int16_t) offsetof(cls_jn_ByteBufferNative, fld_gcRef), (int16_t) offsetof(cls_jn_ByteBufferNative, fld_array), (int16_t) offsetof(cls_jn_ByteBufferNative, fld_base)
};
void sysinitclass_jn_ByteBufferNative() {
}
