/*
 * Decompiled with CFR 0.152.
 */
package ui.whatssidsettings;

import javafx.beans.binding.Bindings;
import javafx.beans.property.Property;
import javafx.fxml.FXML;
import javafx.scene.control.CheckBox;
import javafx.scene.control.TextField;
import javafx.util.StringConverter;
import javafx.util.converter.IntegerStringConverter;
import javafx.util.converter.NumberStringConverter;
import sidplay.Player;
import sidplay.fingerprinting.FingerprintJsonClient;
import sidplay.ini.IniDefaults;
import ui.common.C64Window;
import ui.entities.config.EmulationSection;
import ui.entities.config.WhatsSidSection;

public class WhatsSidSettings
extends C64Window {
    @FXML
    private CheckBox enable;
    @FXML
    private TextField url;
    @FXML
    private TextField username;
    @FXML
    private TextField password;
    @FXML
    private TextField connectionTimeout;
    @FXML
    private TextField captureTime;
    @FXML
    private TextField matchStartTime;
    @FXML
    private TextField matchRetryTime;
    @FXML
    private TextField minimumRelativeConfidence;
    @FXML
    private CheckBox detectWhatsSidChipModel;

    public WhatsSidSettings() {
    }

    public WhatsSidSettings(Player player) {
        super(player);
    }

    @Override
    @FXML
    protected void initialize() {
        WhatsSidSection whatsSidSection = this.util.getConfig().getWhatsSidSection();
        this.enable.selectedProperty().bindBidirectional((Property)whatsSidSection.enableProperty());
        this.url.textProperty().bindBidirectional((Property)whatsSidSection.urlProperty());
        this.url.textProperty().addListener((s, o, n) -> this.updateWhatsSid());
        this.username.textProperty().bindBidirectional((Property)whatsSidSection.usernameProperty());
        this.username.textProperty().addListener((s, o, n) -> this.updateWhatsSid());
        this.password.textProperty().bindBidirectional((Property)whatsSidSection.passwordProperty());
        this.password.textProperty().addListener((s, o, n) -> this.updateWhatsSid());
        Bindings.bindBidirectional((Property)this.connectionTimeout.textProperty(), whatsSidSection.connectionTimeoutProperty(), (StringConverter)new IntegerStringConverter());
        this.connectionTimeout.textProperty().addListener((s, o, n) -> this.updateWhatsSid());
        Bindings.bindBidirectional((Property)this.captureTime.textProperty(), whatsSidSection.captureTimeProperty(), (StringConverter)new IntegerStringConverter());
        Bindings.bindBidirectional((Property)this.matchStartTime.textProperty(), whatsSidSection.matchStartTimeProperty(), (StringConverter)new IntegerStringConverter());
        Bindings.bindBidirectional((Property)this.matchRetryTime.textProperty(), whatsSidSection.matchRetryTimeProperty(), (StringConverter)new IntegerStringConverter());
        Bindings.bindBidirectional((Property)this.minimumRelativeConfidence.textProperty(), (Property)whatsSidSection.minimumRelativeConfidenceProperty(), (StringConverter)new NumberStringConverter());
        this.detectWhatsSidChipModel.selectedProperty().bindBidirectional((Property)whatsSidSection.detectChipModelProperty());
        this.detectWhatsSidChipModel.selectedProperty().addListener((s, o, n) -> this.resetChipModel());
    }

    @FXML
    private void restoreDefaults() {
        WhatsSidSection whatsSidSection = this.util.getConfig().getWhatsSidSection();
        whatsSidSection.setEnable(IniDefaults.DEFAULT_WHATSSID_ENABLE);
        whatsSidSection.setUrl(IniDefaults.DEFAULT_WHATSSID_URL);
        whatsSidSection.setUsername(IniDefaults.DEFAULT_WHATSSID_USERNAME);
        whatsSidSection.setPassword(IniDefaults.DEFAULT_WHATSSID_PASSWORD);
        whatsSidSection.setConnectionTimeout(IniDefaults.DEFAULT_WHATSSID_CONNECTION_TIMEOUT);
        whatsSidSection.setCaptureTime(IniDefaults.DEFAULT_WHATSSID_CAPTURE_TIME);
        whatsSidSection.setMatchStartTime(IniDefaults.DEFAULT_WHATSSID_MATCH_START_TIME);
        whatsSidSection.setMatchRetryTime(IniDefaults.DEFAULT_WHATSSID_MATCH_RETRY_TIME);
        whatsSidSection.setMinimumRelativeConfidence(IniDefaults.DEFAULT_WHATSSID_MINIMUM_RELATIVE_CONFIDENCE);
        whatsSidSection.setDetectChipModel(IniDefaults.DEFAULT_WHATSSID_DETECT_CHIP_MODEL);
    }

    private void updateWhatsSid() {
        WhatsSidSection whatsSidSection = this.util.getConfig().getWhatsSidSection();
        String url = whatsSidSection.getUrl();
        String username = whatsSidSection.getUsername();
        String password = whatsSidSection.getPassword();
        int connectionTimeout = whatsSidSection.getConnectionTimeout();
        this.util.getPlayer().setFingerPrintMatcher(new FingerprintJsonClient(url, username, password, connectionTimeout));
    }

    private void resetChipModel() {
        EmulationSection emulationSection = this.util.getConfig().getEmulationSection();
        emulationSection.getOverrideSection().reset();
        this.util.getPlayer().updateSIDChipConfiguration();
    }
}

