/*
 * Decompiled with CFR 0.152.
 */
package ui.entities.collection.service;

import java.io.File;
import java.io.IOException;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.Year;
import java.time.YearMonth;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;
import javax.persistence.EntityManager;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Join;
import javax.persistence.criteria.JoinType;
import javax.persistence.criteria.Path;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Selection;
import javax.persistence.metamodel.SingularAttribute;
import libsidplay.sidtune.SidTune;
import libsidplay.sidtune.SidTuneError;
import sidplay.Player;
import ui.entities.collection.HVSCEntry;
import ui.entities.collection.HVSCEntry_;
import ui.entities.collection.StilEntry;
import ui.entities.collection.StilEntry_;

public class HVSCEntryService {
    private EntityManager em;

    public HVSCEntryService(EntityManager em) {
        this.em = em;
    }

    public HVSCEntry add(Player player, String path, File tuneFile) throws IOException, SidTuneError {
        SidTune tune = tuneFile.isFile() ? SidTune.load(tuneFile) : null;
        HVSCEntry hvscEntry = new HVSCEntry(() -> player.getSidDatabaseInfo(db -> db.getTuneLength(tune), 0.0), tuneFile.getName(), path, tuneFile.length(), tuneFile.lastModified(), tune, tune.identify().stream().collect(Collectors.joining(",")));
        try {
            this.em.persist((Object)hvscEntry);
        }
        catch (Throwable e) {
            System.err.println("Tune: " + path);
            System.err.println(e.getMessage());
        }
        return hvscEntry;
    }

    public HVSCEntries search(SingularAttribute<?, ?> field, Object fieldValue, boolean caseSensitive, boolean fForward) {
        Predicate predicate;
        Class entityType = field.getDeclaringType().getJavaType();
        Class fieldType = field.getJavaType();
        assert (entityType == HVSCEntry.class || entityType == StilEntry.class);
        CriteriaBuilder cb = this.em.getCriteriaBuilder();
        CriteriaQuery q = cb.createQuery(String.class);
        if (entityType == HVSCEntry.class) {
            Root h = q.from(HVSCEntry.class);
            Path path = h.get(HVSCEntry_.path);
            q.select((Selection)path).distinct(true);
            if (fieldType == LocalDateTime.class) {
                assert (fieldValue.getClass() == LocalDateTime.class);
                Path fieldName = h.get(field);
                if (fieldValue instanceof LocalDate) {
                    LocalDate localDate = (LocalDate)fieldValue;
                    Expression yearFunction = cb.function("YEAR", Integer.class, new Expression[]{fieldName});
                    Expression monthFunction = cb.function("MONTH", Integer.class, new Expression[]{fieldName});
                    Expression dayFunction = cb.function("DAYOFMONTH", Integer.class, new Expression[]{fieldName});
                    predicate = cb.and(new Predicate[]{cb.equal(yearFunction, (Object)localDate.getYear()), cb.equal(monthFunction, (Object)localDate.getMonthValue()), cb.equal(dayFunction, (Object)localDate.getDayOfMonth())});
                } else if (fieldValue instanceof YearMonth) {
                    YearMonth yearMonth = (YearMonth)fieldValue;
                    Expression yearFunction = cb.function("YEAR", Integer.class, new Expression[]{fieldName});
                    Expression monthFunction = cb.function("MONTH", Integer.class, new Expression[]{fieldName});
                    predicate = cb.and((Expression)cb.equal(yearFunction, (Object)yearMonth.getYear()), (Expression)cb.equal(monthFunction, (Object)yearMonth.getMonthValue()));
                } else if (fieldValue instanceof Year) {
                    Expression yearFunction = cb.function("YEAR", Integer.class, new Expression[]{fieldName});
                    Year year = (Year)fieldValue;
                    predicate = cb.equal(yearFunction, (Object)year.getValue());
                } else {
                    predicate = cb.and(new Predicate[0]);
                }
            } else if (fieldType == String.class) {
                assert (fieldValue.getClass() == String.class);
                Path fieldName = h.get(field);
                predicate = this.fieldNameLikeFieldValue(cb, (Path<String>)fieldName, fieldValue.toString(), caseSensitive, fieldType);
            } else {
                Path fieldName = h.get(field);
                predicate = cb.equal((Expression)fieldName, fieldValue);
            }
        } else {
            assert (fieldValue.getClass() == String.class);
            Root s = q.from(StilEntry.class);
            Join h = s.join(StilEntry_.hvscEntry, JoinType.INNER);
            Path path = h.get(HVSCEntry_.path);
            q.select((Selection)path).distinct(true);
            if (fieldType == String.class) {
                assert (fieldValue.getClass() == String.class);
                Path fieldName = s.get(field);
                predicate = this.fieldNameLikeFieldValue(cb, (Path<String>)fieldName, fieldValue.toString(), caseSensitive, fieldType);
            } else {
                Path fieldName = s.get(field);
                predicate = cb.equal((Expression)fieldName, fieldValue);
            }
        }
        return new HVSCEntries(this.em.createQuery(q.where((Expression)predicate)).getResultList(), fForward);
    }

    private Predicate fieldNameLikeFieldValue(CriteriaBuilder cb, Path<String> fieldNm, String fieldValue, boolean caseSensitive, Class<?> type) {
        if (!caseSensitive) {
            return cb.like(cb.lower(fieldNm), "%" + fieldValue.toLowerCase(Locale.GERMAN) + "%");
        }
        return cb.like(fieldNm, "%" + fieldValue + "%");
    }

    public void clear() {
        this.em.createQuery("DELETE from HVSCEntry").executeUpdate();
    }

    public class HVSCEntries {
        private int listIdx;
        private List<String> list;

        HVSCEntries(List<String> list, boolean fForward) {
            this.list = list;
            this.listIdx = fForward ? -1 : list.size();
        }

        public boolean prev() {
            if (this.listIdx - 1 < 0) {
                return false;
            }
            --this.listIdx;
            return true;
        }

        public boolean next() {
            if (this.listIdx + 1 == this.list.size()) {
                return false;
            }
            ++this.listIdx;
            return true;
        }

        public String getPath() {
            return this.list.get(this.listIdx);
        }
    }
}

