/*
 * Decompiled with CFR 0.152.
 */
package server.restful.servlets;

import com.beust.jcommander.Parameters;
import jakarta.servlet.AsyncContext;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.annotation.HttpConstraint;
import jakarta.servlet.annotation.ServletSecurity;
import jakarta.servlet.annotation.WebServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.File;
import java.io.IOException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import libsidutils.IOUtils;
import libsidutils.ZipFileUtils;
import server.restful.common.ContentTypeAndFileExtensions;
import server.restful.common.IServletSystemProperties;
import server.restful.common.JSIDPlay2Servlet;
import server.restful.common.ServletUtil;
import server.restful.common.async.DefaultThreadFactory;
import server.restful.common.async.HttpAsyncContextRunnable;
import server.restful.common.parameter.ServletParameterParser;
import server.restful.common.parameter.requestpath.FileRequestPathServletParameters;

@WebServlet(name="DownloadServlet", displayName="DownloadServlet", asyncSupported=true, urlPatterns={"/jsidplay2service/JSIDPlay2REST/download/*"}, description="Download SID")
@ServletSecurity(value=@HttpConstraint(rolesAllowed={"user", "admin"}))
public class DownloadServlet
extends JSIDPlay2Servlet {
    private ExecutorService executorService;

    public void init() throws ServletException {
        this.executorService = Executors.newFixedThreadPool(IServletSystemProperties.DownloadServlet.MAX_DOWNLOAD_IN_PARALLEL, new DefaultThreadFactory("/download"));
    }

    public void destroy() {
        this.executorService.shutdown();
    }

    @Override
    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        AsyncContext asyncContext = request.startAsync((ServletRequest)request, (ServletResponse)response);
        asyncContext.setTimeout((long)IServletSystemProperties.DownloadServlet.DOWNLOAD_ASYNC_TIMEOUT);
        this.executorService.execute(new HttpAsyncContextRunnable(asyncContext, this.getServletContext()){

            @Override
            public void run(HttpServletRequest request, HttpServletResponse response) throws IOException {
                block4: {
                    try {
                        DownloadServletParameters servletParameters = new DownloadServletParameters();
                        ServletParameterParser parser = new ServletParameterParser(request, response, servletParameters);
                        File file = servletParameters.fetchFile(DownloadServlet.this.configuration, DownloadServlet.this.directoryProperties, parser, DownloadServlet.this.hasAdminAccess(request));
                        if (file == null || servletParameters.getHelp().booleanValue() || parser.hasException()) {
                            parser.usage();
                            return;
                        }
                        if (!this.isComplete()) {
                            response.addHeader("Content-disposition", "attachment; filename=" + URLEncoder.encode(file.getName(), StandardCharsets.UTF_8.name()));
                            response.setContentLength((int)file.length());
                            DownloadServlet.this.setOutput(ContentTypeAndFileExtensions.getMimeType(IOUtils.getFilenameSuffix(file.getName())), response, ZipFileUtils.newFileInputStream(file));
                        }
                    }
                    catch (Throwable t) {
                        ServletUtil.error(DownloadServlet.this.getServletContext(), t, this.parentThread);
                        if (this.isComplete()) break block4;
                        response.setStatus(500);
                        DownloadServlet.this.setOutput(response, t);
                    }
                }
            }
        });
    }

    @Parameters(resourceBundle="server.restful.servlets.DownloadServletParameters")
    public static class DownloadServletParameters
    extends FileRequestPathServletParameters {
    }
}

