/*
 * Decompiled with CFR 0.152.
 */
package builder.jexsid;

import builder.jexsid.ChipSelect;
import builder.jexsid.ExSIDEmu;
import builder.jexsid.HardwareModel;
import exsid.ExSID;
import java.util.ArrayList;
import java.util.List;
import libsidplay.common.CPUClock;
import libsidplay.common.ChipModel;
import libsidplay.common.Event;
import libsidplay.common.EventScheduler;
import libsidplay.common.HardwareSIDBuilder;
import libsidplay.common.Mixer;
import libsidplay.common.OS;
import libsidplay.common.SIDEmu;
import libsidplay.config.IAudioSection;
import libsidplay.config.IConfig;
import libsidplay.config.IEmulationSection;
import libsidplay.config.ISidPlay2SystemProperties;
import libsidplay.sidtune.SidTune;

public class JExSIDBuilder
implements HardwareSIDBuilder,
Mixer {
    private static final short REGULAR_DELAY = 512;
    private EventScheduler context;
    private IConfig config;
    private CPUClock cpuClock;
    private static ExSID exSID;
    private static int deviceCount;
    private static String[] deviceNames;
    private List<ExSIDEmu> sids = new ArrayList<ExSIDEmu>();
    private long lastSIDWriteTime;
    private int fastForwardFactor;
    private int[] delayInCycles = new int[ISidPlay2SystemProperties.MAX_SIDS];
    protected int lastSidNum = -1;

    public JExSIDBuilder(EventScheduler context, IConfig config, CPUClock cpuClock) {
        this.context = context;
        this.config = config;
        this.cpuClock = cpuClock;
        if (exSID == null) {
            exSID = new ExSID();
            this.init();
        }
    }

    private void init() {
        Runtime.getRuntime().addShutdownHook(new Thread(() -> exSID.exSID_exit()));
        if (exSID.exSID_init() < 0) {
            deviceNames = new String[0];
            return;
        }
        String hardwareRevision = HardwareModel.get(exSID.exSID_hwmodel()).name();
        String firmwareVersion = String.format(" fw%c%d", exSID.exSID_hwversion() >> 8 & 0xFF, exSID.exSID_hwversion() & 0xFF);
        deviceCount = 2;
        deviceNames = new String[deviceCount];
        JExSIDBuilder.deviceNames[0] = hardwareRevision + " " + firmwareVersion + " #1";
        JExSIDBuilder.deviceNames[1] = hardwareRevision + " " + firmwareVersion + " #2";
    }

    public static void printInstallationHint() {
        if (OS.get() == OS.LINUX) {
            JExSIDBuilder.printLinuxInstallationHint();
        }
        System.err.println("Maybe you just forgot to plug-in your USB devices?");
        System.err.println();
    }

    private static void printLinuxInstallationHint() {
        System.err.println("If device cannot be used, please use this workaround (we grant access to the USB device)...");
        System.err.println();
        System.err.println("... On Ubuntu you do:");
        System.err.println("$ sudo vi /etc/udev/rules.d/93-exsid.rules");
        System.err.println("ACTION==\"add\", ATTRS{idVendor}==\"0403\", ATTRS{idProduct}==\"6001\", MODE=\"0666\", RUN+=\"/bin/sh -c 'rmmod ftdi_sio && rmmod usbserial'\"");
        System.err.println("$ sudo udevadm control --reload-rules && sudo udevadm trigger && sudo chmod -R 777 /dev/bus/usb/");
        System.err.println("For ExSID+ you have to replace idProduct 6001 with 6015!");
        System.err.println();
        System.err.println("... and on Fedora you do:");
        System.err.println("$ sudo vi /etc/udev/rules.d/93-exsid.rules");
        System.err.println("ACTION==\"add\", ATTRS{idVendor}==\"0403\", ATTRS{idProduct}==\"6001\", MODE=\"0666\", RUN+=\"/bin/sh -c 'echo -n $id:1.0 > /sys/bus/usb/drivers/ftdi_sio/unbind; echo -n $id:1.1 > /sys/bus/usb/drivers/ftdi_sio/unbind'\"");
        System.err.println("For ExSID+ you have to replace idProduct 6001 with 6015!");
    }

    @Override
    public SIDEmu lock(SIDEmu oldSIDEmu, int sidNum, SidTune tune) {
        ExSIDEmu sid;
        Integer deviceId;
        IAudioSection audioSection = this.config.getAudioSection();
        IEmulationSection emulationSection = this.config.getEmulationSection();
        ChipModel chipModel = ChipModel.getChipModel(emulationSection, tune, sidNum);
        ChipModel defaultSidModel = emulationSection.getDefaultSidModel();
        boolean stereo = SidTune.isSIDUsed(emulationSection, tune, 1);
        if (oldSIDEmu != null) {
            return oldSIDEmu;
        }
        if (emulationSection.isExsidFakeStereo()) {
            if (sidNum == 0 && SidTune.isFakeStereoSid(emulationSection, tune, 1)) {
                this.lastSidNum = sidNum;
                exSID.exSID_chipselect(ChipSelect.XS_CS_BOTH.getChipSelect());
            }
            if (sidNum == 1 && SidTune.isFakeStereoSid(emulationSection, tune, 1)) {
                return SIDEmu.NONE;
            }
        }
        if (sidNum == 1 && !this.sids.isEmpty() && this.sids.get(0).getChipModel() == chipModel) {
            ChipModel chipModel2 = chipModel = chipModel == ChipModel.MOS6581 ? ChipModel.MOS8580 : ChipModel.MOS6581;
        }
        if ((deviceId = Integer.valueOf(sidNum)) < deviceCount && (sid = this.createSID(deviceId.byteValue(), sidNum, tune, chipModel, defaultSidModel, stereo)).lock()) {
            sid.setFilterEnable(emulationSection, sidNum);
            sid.setDigiBoost(emulationSection.isDigiBoosted8580());
            for (int voice = 0; voice < 4; ++voice) {
                sid.setVoiceMute(voice, emulationSection.isMuteVoice(sidNum, voice));
            }
            this.sids.add(sid);
            this.setDeviceName(sidNum, deviceNames[deviceId]);
            this.setDelay(sidNum, audioSection.getDelay(sidNum));
            return sid;
        }
        System.err.printf("EXSID ERROR: System doesn't have enough SID chips. Requested: (sidNum=%d)\n", sidNum);
        if (deviceCount == 0) {
            JExSIDBuilder.printInstallationHint();
        }
        return SIDEmu.NONE;
    }

    @Override
    public void unlock(SIDEmu sidEmu) {
        ExSIDEmu sid = (ExSIDEmu)sidEmu;
        this.sids.remove(sid);
        sid.unlock();
    }

    @Override
    public int getDeviceCount() {
        return deviceCount;
    }

    public static String[] getDeviceNames() {
        return deviceNames;
    }

    @Override
    public Integer getDeviceId(int sidNum) {
        return sidNum < this.sids.size() ? Integer.valueOf(this.sids.get(sidNum).getDeviceId()) : null;
    }

    @Override
    public String getDeviceName(int sidNum) {
        return sidNum < this.sids.size() ? this.sids.get(sidNum).getDeviceName() : null;
    }

    public void setDeviceName(int sidNum, String serialNo) {
        if (sidNum < this.sids.size()) {
            this.sids.get(sidNum).setDeviceName(serialNo);
        }
    }

    @Override
    public ChipModel getDeviceChipModel(int sidNum) {
        return sidNum < this.sids.size() ? this.sids.get(sidNum).getChipModel() : null;
    }

    @Override
    public void start() {
    }

    @Override
    public void fadeIn(double fadeIn) {
        System.err.println("Fade-in unsupported by ExSID");
    }

    @Override
    public void fadeOut(double fadeOut) {
        System.err.println("Fade-out unsupported by ExSID");
    }

    @Override
    public void setVolume(int sidNum, float volume) {
        System.err.println("Volume unsupported by ExSID");
    }

    @Override
    public void setBalance(int sidNum, float balance) {
        System.err.println("Balance unsupported by ExSID");
    }

    public int getDelay(int sidNum) {
        return this.delayInCycles[sidNum];
    }

    @Override
    public void setDelay(int sidNum, int delay) {
        this.delayInCycles[sidNum] = (int)(this.cpuClock.getCpuFrequency() / 1000.0 * (double)delay);
    }

    @Override
    public void fastForward() {
        ++this.fastForwardFactor;
    }

    @Override
    public void normalSpeed() {
        this.fastForwardFactor = 0;
    }

    @Override
    public boolean isFastForward() {
        return this.fastForwardFactor != 0;
    }

    @Override
    public int getFastForwardBitMask() {
        return (1 << this.fastForwardFactor) - 1;
    }

    @Override
    public void pause() {
    }

    private ExSIDEmu createSID(byte deviceId, int sidNum, SidTune tune, ChipModel chipModel, ChipModel defaultChipModel, boolean stereo) {
        IEmulationSection emulationSection = this.config.getEmulationSection();
        if (SidTune.isFakeStereoSid(emulationSection, tune, sidNum)) {
            return new ExSIDEmu.FakeStereo(this, this.context, this.cpuClock, exSID, deviceId, sidNum, chipModel, defaultChipModel, stereo, this.sids, emulationSection);
        }
        return new ExSIDEmu(this, this.context, this.cpuClock, exSID, deviceId, sidNum, chipModel, defaultChipModel, stereo);
    }

    int clocksSinceLastAccess() {
        long now = this.context.getTime(Event.Phase.PHI2);
        int diff = (int)(now - this.lastSIDWriteTime);
        this.lastSIDWriteTime = now;
        return diff >> this.fastForwardFactor;
    }

    long eventuallyDelay() {
        long now = this.context.getTime(Event.Phase.PHI2);
        int diff = (int)(now - this.lastSIDWriteTime);
        if (diff > 512) {
            this.lastSIDWriteTime += 512L;
            exSID.exSID_delay((long)((short)(512 >> this.fastForwardFactor)));
        }
        return 512L;
    }
}

