/*
 * Decompiled with CFR 0.152.
 */
package builder.jhardsid;

import builder.jhardsid.JHardSIDBuilder;
import builder.resid.residfp.ReSIDfp;
import com.hardsid.usb.driver.HardSIDUSB;
import com.hardsid.usb.driver.WState;
import java.util.List;
import libsidplay.common.CPUClock;
import libsidplay.common.ChipModel;
import libsidplay.common.Event;
import libsidplay.common.EventScheduler;
import libsidplay.config.IEmulationSection;
import libsidplay.config.ISidPlay2SystemProperties;

public class JHardSIDEmu
extends ReSIDfp {
    private static final short SHORTEST_DELAY = 4;
    private final EventScheduler context;
    private final JHardSIDBuilder hardSIDBuilder;
    private final Event event;
    private final HardSIDUSB hardSID;
    private final byte deviceID;
    private final byte chipNum;
    private boolean doReadWriteDelayed;
    private String deviceName;
    private int sidNum;
    private final ChipModel chipModel;
    private boolean[] voiceMute = new boolean[4];
    private boolean[] filterDisable = new boolean[ISidPlay2SystemProperties.MAX_SIDS];

    public JHardSIDEmu(JHardSIDBuilder hardSIDBuilder, EventScheduler context, CPUClock cpuClock, HardSIDUSB hardSID, byte deviceID, int chipNum, int sidNum, ChipModel model, ChipModel defaultChipModel) {
        super(context);
        this.hardSIDBuilder = hardSIDBuilder;
        this.context = context;
        this.hardSID = hardSID;
        this.deviceID = deviceID;
        this.chipNum = (byte)chipNum;
        this.sidNum = sidNum;
        this.chipModel = model;
        this.event = Event.of("HardSID Delay", event -> context.schedule((Event)event, hardSIDBuilder.eventuallyDelay(), Event.Phase.PHI2));
        super.setChipModel(model == ChipModel.AUTO ? defaultChipModel : model);
        super.setClockFrequency(cpuClock.getCpuFrequency());
    }

    @Override
    public void write(int addr, byte data) {
        switch (addr & 0x1F) {
            case 4: 
            case 11: 
            case 18: {
                if (this.voiceMute[(addr - 4) / 7]) {
                    data = (byte)(data & 0xFE);
                }
                super.write(addr, data);
                break;
            }
            case 23: {
                if (this.filterDisable[this.sidNum]) {
                    data = (byte)(data & 0xF0);
                }
                super.write(addr, data);
                break;
            }
            case 24: {
                if (this.voiceMute[3] && (data & 0xF) < (this.readInternalRegister(addr) & 0xF)) {
                    return;
                }
                super.write(addr, data);
                break;
            }
            default: {
                super.write(addr, data);
            }
        }
        byte dataByte = data;
        if (addr > 24) {
            return;
        }
        this.doReadWriteDelayed = true;
        this.doWriteDelayed(() -> {
            while (this.hardSID.hardsid_usb_write((int)this.deviceID, (byte)(this.chipNum << 5 | addr), dataByte) == WState.BUSY) {
                try {
                    Thread.sleep(0L);
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
            }
        });
    }

    @Override
    public void clock() {
        super.clock();
        short clocksSinceLastAccess = (short)this.hardSIDBuilder.clocksSinceLastAccess();
        this.doWriteDelayed(() -> {
            if (clocksSinceLastAccess > 0) {
                while (this.hardSID.hardsid_usb_delay((int)this.deviceID, clocksSinceLastAccess & 0xFFFF) == WState.BUSY) {
                    try {
                        Thread.sleep(0L);
                    }
                    catch (InterruptedException e) {
                        throw new RuntimeException(e);
                    }
                }
            }
        });
    }

    private void doWriteDelayed(Runnable runnable) {
        if (this.hardSIDBuilder.getDelay(this.sidNum) > 0) {
            this.context.schedule(Event.of("Delayed SID output", event -> {
                if (this.doReadWriteDelayed) {
                    runnable.run();
                }
            }), this.hardSIDBuilder.getDelay(this.sidNum));
        } else {
            runnable.run();
        }
    }

    protected void lock() {
        this.deviceReset((byte)15);
        this.reset((byte)15);
        this.context.schedule(this.event, 0L, Event.Phase.PHI2);
    }

    protected void unlock() {
        this.deviceReset((byte)0);
        this.reset((byte)0);
        this.context.cancel(this.event);
        this.doReadWriteDelayed = false;
    }

    private void deviceReset(byte volume) {
        this.hardSID.hardsid_usb_abortplay((int)this.deviceID);
        for (int reg = 0; reg < 32; reg = (int)((byte)(reg + 1))) {
            while (this.hardSID.hardsid_usb_write((int)this.deviceID, (byte)(this.chipNum << 5 | reg), (byte)0) == WState.BUSY) {
                try {
                    Thread.sleep(0L);
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
            }
            while (this.hardSID.hardsid_usb_delay((int)this.deviceID, 4) == WState.BUSY) {
                try {
                    Thread.sleep(0L);
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
            }
        }
        while (this.hardSID.hardsid_usb_write((int)this.deviceID, (byte)(this.chipNum << 5 | 0xF), volume) == WState.BUSY) {
            try {
                Thread.sleep(0L);
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }
        while (this.hardSID.hardsid_usb_flush((int)this.deviceID) == WState.BUSY) {
            try {
                Thread.sleep(0L);
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }
    }

    @Override
    public void setVoiceMute(int num, boolean mute) {
        super.setVoiceMute(num, mute);
        if (num < 4) {
            this.voiceMute[num] = mute;
        }
    }

    @Override
    public void setFilterEnable(IEmulationSection emulation, int sidNum) {
        super.setFilterEnable(emulation, sidNum);
        this.filterDisable[sidNum] = !emulation.isFilterEnable(sidNum);
    }

    public String getDeviceName() {
        return this.deviceName;
    }

    public void setDeviceName(String deviceName) {
        this.deviceName = deviceName;
    }

    protected ChipModel getChipModel() {
        return this.chipModel;
    }

    public byte getChipNum() {
        return this.chipNum;
    }

    public static final String credits() {
        StringBuffer credits = new StringBuffer();
        credits.append("HardSID Java version by Ken H\u00e4ndel <kschwiersch@yahoo.de> Copyright (\u00a9) 2022\n");
        credits.append("\tSupported by official HardSID support\n");
        credits.append("\tbased on hardsid.dll, api calls Written by Sandor T\u00e9li\n");
        return credits.toString();
    }

    public static class FakeStereo
    extends JHardSIDEmu {
        private final IEmulationSection emulationSection;
        private final int prevNum;
        private final List<JHardSIDEmu> sids;

        public FakeStereo(JHardSIDBuilder hardSIDBuilder, EventScheduler context, CPUClock cpuClock, HardSIDUSB hardSID, byte deviceId, int chipNum, int sidNum, ChipModel chipModel, ChipModel defaultChipModel, List<JHardSIDEmu> sids, IEmulationSection emulationSection) {
            super(hardSIDBuilder, context, cpuClock, hardSID, deviceId, chipNum, sidNum, chipModel, defaultChipModel);
            this.prevNum = sidNum - 1;
            this.sids = sids;
            this.emulationSection = emulationSection;
        }

        @Override
        public byte read(int addr) {
            if (this.emulationSection.getSidToRead().getSidNum() <= this.prevNum) {
                return this.sids.get(this.prevNum).read(addr);
            }
            return super.read(addr);
        }

        @Override
        public byte readInternalRegister(int addr) {
            if (this.emulationSection.getSidToRead().getSidNum() <= this.prevNum) {
                return this.sids.get(this.prevNum).readInternalRegister(addr);
            }
            return super.readInternalRegister(addr);
        }

        @Override
        public void write(int addr, byte data) {
            super.write(addr, data);
            this.sids.get(this.prevNum).write(addr, data);
        }
    }
}

