/*
 * Decompiled with CFR 0.152.
 */
package client.teavm.common;

import builder.resid.resid.FilterModelConfig;
import client.teavm.common.IExportedUtilities;
import client.teavm.common.ILogger;
import client.teavm.common.MainArgs;
import java.util.logging.Logger;
import libsidplay.common.Emulation;
import libsidplay.config.IFilterSection;

public class ExportedUtilitiesApi
implements IExportedUtilities,
ILogger {
    private static final Logger LOG_IMPL = Logger.getLogger(ExportedUtilitiesApi.class.getName());
    private final ILogger LOG = this;
    private final MainArgs mainArgs;

    public ExportedUtilitiesApi(String[] args) {
        this.mainArgs = new MainArgs(this.LOG, args);
    }

    @Override
    public double[] filterCurve(Emulation emulation, IFilterSection filter) {
        this.LOG.fine(String.format("filterCurve: %s, filter: %s", new Object[]{emulation, filter}));
        double[] result = new double[2048];
        for (int fc = 0; fc < 2048; ++fc) {
            result[fc] = emulation == Emulation.RESIDFP ? builder.resid.residfp.FilterModelConfig.estimateFrequency(filter, fc) : FilterModelConfig.estimateFrequency(filter, fc);
        }
        return result;
    }

    @Override
    public void finest(String message) {
        if (!this.mainArgs.isQuiet() && this.mainArgs.isDebug() && this.mainArgs.getVerbose() > 1) {
            LOG_IMPL.finest(message);
        }
    }

    @Override
    public void fine(String message) {
        if (!this.mainArgs.isQuiet() && this.mainArgs.isDebug()) {
            LOG_IMPL.fine(message);
        }
    }

    @Override
    public void info(String message) {
        if (!this.mainArgs.isQuiet()) {
            LOG_IMPL.info(message);
        }
    }

    @Override
    public void severe(String message) {
        if (!this.mainArgs.isQuiet()) {
            LOG_IMPL.severe(message);
        }
    }
}

