/*
 * Decompiled with CFR 0.152.
 */
package client.teavm.common.compiletime;

import java.io.DataInputStream;
import java.io.IOException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import libsidutils.sidid.SidIdBase;
import org.teavm.metaprogramming.CompileTime;
import org.teavm.metaprogramming.Meta;
import org.teavm.metaprogramming.Metaprogramming;
import org.teavm.metaprogramming.Value;

@CompileTime
public class SidIdInfoTeaVM {
    private static final String SID_ID_INFO_CFG = "/libsidutils/sidid/sidid.nfo";

    @Meta
    public static native String getSidIdInfoCfg(boolean var0);

    private static void getSidIdInfoCfg(Value<Boolean> b) {
        try (DataInputStream is = new DataInputStream(SidIdBase.class.getResourceAsStream(SID_ID_INFO_CFG));){
            URL url = SidIdBase.class.getResource(SID_ID_INFO_CFG);
            byte[] sidIdInfoCfgBin = new byte[url.openConnection().getContentLength()];
            is.readFully(sidIdInfoCfgBin);
            String sidIdInfoCfg = new String(Base64.getEncoder().encode(sidIdInfoCfgBin), StandardCharsets.US_ASCII);
            Value sidIdInfoCfgValue = Metaprogramming.emit(() -> sidIdInfoCfg);
            Metaprogramming.exit(() -> sidIdInfoCfgValue.get());
        }
        catch (IOException e) {
            throw new RuntimeException("Load failed for resource: /libsidutils/sidid/sidid.nfo");
        }
    }
}

