/*
 * Decompiled with CFR 0.152.
 */
package libsidplay;

import java.io.DataInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.IntFunction;
import libsidplay.common.CIAChipModel;
import libsidplay.common.CPUClock;
import libsidplay.common.Event;
import libsidplay.common.EventScheduler;
import libsidplay.common.SIDEmu;
import libsidplay.common.SIDListener;
import libsidplay.common.VICChipModel;
import libsidplay.components.c1530.DatasetteEnvironment;
import libsidplay.components.c1541.C1541Environment;
import libsidplay.components.c1541.IParallelCable;
import libsidplay.components.cart.Cartridge;
import libsidplay.components.cart.CartridgeType;
import libsidplay.components.joystick.IJoystick;
import libsidplay.components.keyboard.Keyboard;
import libsidplay.components.mos6510.IMOS6510Extension;
import libsidplay.components.mos6510.MOS6510;
import libsidplay.components.mos6526.MOS6526;
import libsidplay.components.mos656x.MOS6567;
import libsidplay.components.mos656x.MOS6569;
import libsidplay.components.mos656x.PALEmulation;
import libsidplay.components.mos656x.VIC;
import libsidplay.components.pla.Bank;
import libsidplay.components.pla.PLA;
import libsidplay.components.printer.UserportPrinterEnvironment;
import libsidplay.components.ram.SystemRAMBank;
import libsidplay.config.ISidPlay2SystemProperties;

public abstract class C64
implements DatasetteEnvironment,
C1541Environment,
UserportPrinterEnvironment {
    protected CPUClock clock = CPUClock.PAL;
    private final PLA pla;
    private final MOS6510 cpu;
    protected final MOS6526 cia1;
    protected final MOS6526 cia2;
    protected final Keyboard keyboard;
    protected IParallelCable parallelCable;
    protected final VIC palVic;
    protected final VIC ntscVic;
    protected final SystemRAMBank ramBank = new SystemRAMBank();
    protected final EventScheduler context;
    protected int callsToPlayRoutine;
    private long lastUpdate;
    private double tuneSpeed;
    protected IMOS6510Extension playRoutineObserver;
    protected final IJoystick[] joystickPort = new IJoystick[2];
    private final IJoystick disconnectedJoystick = () -> -1;
    private final ZeroRAMBank zeroRAMBank = new ZeroRAMBank();

    public void setPlayAddr(int playAddr) {
        this.cpu.setJmpJsrHandler(Register_ProgramCounter -> {
            if (Register_ProgramCounter == playAddr) {
                if (this.playRoutineObserver != null) {
                    this.playRoutineObserver.jmpJsr();
                }
                ++this.callsToPlayRoutine;
            }
        });
    }

    public final double determineTuneSpeed() {
        double cpuFreq = this.clock.getCpuFrequency();
        long now = this.context.getTime(Event.Phase.PHI1);
        double interval = now - this.lastUpdate;
        if (interval >= cpuFreq) {
            this.lastUpdate = now;
            this.tuneSpeed = (double)this.callsToPlayRoutine * cpuFreq / (interval * this.clock.getScreenRefresh());
            this.callsToPlayRoutine = 0;
        }
        return this.tuneSpeed;
    }

    public final void setParallelCable(IParallelCable parallelCable) {
        this.parallelCable = parallelCable;
    }

    public C64(byte[] charBin, byte[] basicBin, byte[] kernalBin) {
        this(context -> new MOS6510((EventScheduler)context), charBin, basicBin, kernalBin);
    }

    public C64(Function<EventScheduler, MOS6510> cpuCreator, byte[] charBin, byte[] basicBin, byte[] kernalBin) {
        this.context = new EventScheduler();
        this.cpu = cpuCreator.apply(this.context);
        this.pla = new PLA(this.context, this.zeroRAMBank, this.ramBank, charBin, basicBin, kernalBin);
        this.cpu.setMemoryHandler(address -> this.pla.cpuRead(address), (address, value) -> this.pla.cpuWrite(address, value));
        this.pla.setCpu(this.cpu);
        this.palVic = new MOS6569(this.pla, this.context);
        this.palVic.setPalEmulation(new PALEmulation(VICChipModel.MOS6567R8));
        this.ntscVic = new MOS6567(this.pla, this.context);
        this.ntscVic.setPalEmulation(new PALEmulation(VICChipModel.MOS6567R8));
        this.pla.setVic(this.palVic);
        this.cia1 = new MOS6526(this.context, CIAChipModel.MOS6526){

            @Override
            public void interrupt(boolean state) {
                C64.this.pla.setIRQ(state);
            }

            @Override
            public void writePRA(byte data) {
            }

            @Override
            public void writePRB(byte data) {
                if ((data & 0x10) == 0) {
                    C64.this.getVIC().triggerLightpen();
                } else {
                    C64.this.getVIC().clearLightpen();
                }
            }

            @Override
            public byte readPRA() {
                byte prbOut = (byte)(this.regs[1] | ~this.regs[3]);
                prbOut = (byte)(prbOut & C64.this.joystickPort[0].getValue());
                byte kbd = C64.this.keyboard.readColumn(prbOut);
                byte joy = C64.this.joystickPort[1].getValue();
                return (byte)(kbd & joy);
            }

            @Override
            public byte readPRB() {
                byte praOut = (byte)(this.regs[0] | ~this.regs[2]);
                praOut = (byte)(praOut & C64.this.joystickPort[1].getValue());
                byte kbd = C64.this.keyboard.readRow(praOut);
                byte joy = C64.this.joystickPort[0].getValue();
                return (byte)(kbd & joy);
            }

            @Override
            public void pulse() {
            }
        };
        this.pla.setCia1(this.cia1);
        this.cia2 = new MOS6526(this.context, CIAChipModel.MOS6526){

            @Override
            public void interrupt(boolean state) {
                C64.this.pla.setNMI(state);
            }

            @Override
            public void writePRA(byte data) {
                C64.this.pla.setVicMemBase((~data & 3) << 14);
                C64.this.writeToIECBus(~data);
                C64.this.printerUserportWriteStrobe((~data & 4) != 0);
            }

            @Override
            public void writePRB(byte data) {
                C64.this.parallelCable.c64Write(data);
            }

            @Override
            public byte readPRA() {
                return (byte)(C64.this.readFromIECBus() | 0x3F);
            }

            @Override
            public byte readPRB() {
                return C64.this.parallelCable.c64Read();
            }

            @Override
            public void pulse() {
                C64.this.parallelCable.pulse();
                C64.this.printerUserportWriteData(this.regs[1]);
            }
        };
        this.pla.setCia2(this.cia2);
        this.keyboard = new Keyboard(){

            @Override
            public void restore() {
                C64.this.pla.setNMI(true);
                C64.this.pla.setNMI(false);
            }
        };
        this.setJoystick(0, null);
        this.setJoystick(1, null);
    }

    public void reset() {
        this.context.reset();
        this.keyboard.reset();
        this.pla.reset();
        this.cpu.setJmpJsrHandler(null);
        this.cpu.triggerRST();
        this.cia1.reset();
        this.cia2.reset();
        this.getVIC().reset();
        this.zeroRAMBank.reset();
        this.ramBank.reset();
        this.callsToPlayRoutine = 0;
        this.lastUpdate = 0L;
        this.tuneSpeed = 0.0;
    }

    public byte[] getRAM() {
        return this.ramBank.array();
    }

    public MOS6510 getCPU() {
        return this.cpu;
    }

    public void setPlayRoutineObserver(IMOS6510Extension observer) {
        this.playRoutineObserver = observer;
    }

    public VIC getVIC() {
        return this.clock == CPUClock.NTSC ? this.ntscVic : this.palVic;
    }

    public int getVicMemBase() {
        return this.pla.getVicMemBase();
    }

    public final void insertSIDChips(BiFunction<Integer, SIDEmu, SIDEmu> sidCreator, IntFunction<Integer> sidLocator) {
        for (int sidNum = 0; sidNum < ISidPlay2SystemProperties.MAX_SIDS; ++sidNum) {
            SIDEmu newSid;
            SIDEmu oldSid = this.pla.getSIDBank().getSID(sidNum);
            if (oldSid != SIDEmu.NONE) {
                this.pla.getSIDBank().unplugSID(sidNum, oldSid, sidLocator.apply(sidNum));
            }
            if ((newSid = sidCreator.apply(sidNum, oldSid)) == SIDEmu.NONE) continue;
            this.pla.getSIDBank().plugInSID(sidNum, newSid, sidLocator.apply(sidNum));
        }
    }

    public void configureVICs(Consumer<VIC> action) {
        action.accept(this.palVic);
        action.accept(this.ntscVic);
    }

    public final void configureSIDs(BiConsumer<Integer, SIDEmu> action) {
        for (int chipNum = 0; chipNum < ISidPlay2SystemProperties.MAX_SIDS; ++chipNum) {
            SIDEmu sid = this.pla.getSIDBank().getSID(chipNum);
            if (sid == SIDEmu.NONE) continue;
            action.accept(chipNum, sid);
        }
    }

    public final void configureSID(int chipNum, Consumer<SIDEmu> action) {
        SIDEmu sid = this.pla.getSIDBank().getSID(chipNum);
        if (sid != SIDEmu.NONE) {
            action.accept(sid);
        }
    }

    public void setSIDListener(SIDListener listener) {
        this.pla.getSIDBank().setSIDListener(listener);
    }

    protected void setClock(CPUClock clock) {
        this.clock = clock;
        this.context.setCyclesPerSecond(clock.getCpuFrequency());
        this.cia1.setDayOfTimeRate(clock.getCpuFrequency() / clock.getScreenRefresh());
        this.cia2.setDayOfTimeRate(clock.getCpuFrequency() / clock.getScreenRefresh());
        this.pla.setVic(this.getVIC());
    }

    public CPUClock getClock() {
        return this.clock;
    }

    public EventScheduler getEventScheduler() {
        return this.context;
    }

    public void setCustomKernal(final byte[] kernalRom) {
        if (kernalRom == null) {
            this.pla.setCustomKernalRomBank(null);
        } else {
            this.pla.setCustomKernalRomBank(new Bank(){

                @Override
                public byte read(int address) {
                    return kernalRom[address & 0x1FFF];
                }

                @Override
                public void write(int address, byte value) {
                    throw new RuntimeException("This bank should never be mapped to W mode");
                }
            });
        }
    }

    public Keyboard getKeyboard() {
        return this.keyboard;
    }

    public final void setJoystick(int portNumber, IJoystick joystickReader) {
        this.joystickPort[portNumber] = joystickReader == null ? this.disconnectedJoystick : joystickReader;
    }

    public final boolean isJoystickConnected(int portNumber) {
        return !this.joystickPort[portNumber].equals(this.disconnectedJoystick);
    }

    public final void setCartridge(CartridgeType type, int sizeKB) throws IOException {
        this.pla.setCartridge(Cartridge.create(this.pla, type, sizeKB));
    }

    public final void setCartridge(CartridgeType type, File file) throws IOException {
        this.pla.setCartridge(Cartridge.read(this.pla, type, file));
    }

    public final void setCartridgeCRT(InputStream is) throws IOException {
        this.pla.setCartridge(Cartridge.readCRT(this.pla, new DataInputStream(is)));
    }

    public final Cartridge getCartridge() {
        return this.pla.getCartridge();
    }

    public boolean isCartridge() {
        return this.pla.isCartridge();
    }

    public final void ejectCartridge() {
        this.pla.setCartridge(null);
    }

    protected class ZeroRAMBank
    extends Bank {
        private byte dir;
        private byte data;
        private byte dataRead;
        private byte dataOut;
        private static final long C64_CPU_DATA_PORT_FALL_OFF_CYCLES = 350000L;
        private long dataSetClkBit6;
        private long dataSetClkBit7;
        private boolean dataSetBit6;
        private boolean dataSetBit7;
        private boolean dataFalloffBit6;
        private boolean dataFalloffBit7;
        private byte oldPortDataOut;
        private byte oldPortWriteBit;

        protected ZeroRAMBank() {
        }

        public void reset() {
            this.oldPortDataOut = (byte)-1;
            this.oldPortWriteBit = (byte)-1;
            this.data = (byte)63;
            this.dataOut = (byte)63;
            this.dataRead = (byte)63;
            this.dir = 0;
            this.dataSetBit6 = false;
            this.dataSetBit7 = false;
            this.dataFalloffBit6 = false;
            this.dataFalloffBit7 = false;
            this.updateCpuPort();
        }

        private void updateCpuPort() {
            this.dataOut = (byte)(this.dataOut & ~this.dir | this.data & this.dir);
            this.dataRead = (byte)((this.data | ~this.dir) & (this.dataOut | 0x17));
            C64.this.pla.setCpuPort(this.dataRead);
            if (0 == (this.dir & 0x20)) {
                this.dataRead = (byte)(this.dataRead & 0xDF);
            }
            if (0 == (this.dir & 0x10) && C64.this.getTapeSense()) {
                this.dataRead = (byte)(this.dataRead & 0xEF);
            }
            if ((this.dir & this.data & 0x20) != this.oldPortDataOut) {
                this.oldPortDataOut = (byte)(this.dir & this.data & 0x20);
                C64.this.setMotor(0 == this.oldPortDataOut);
            }
            if (((~this.dir | this.data) & 8) != this.oldPortWriteBit) {
                this.oldPortWriteBit = (byte)((~this.dir | this.data) & 8);
                C64.this.toggleWriteBit(((~this.dir | this.data) & 8) != 0);
            }
        }

        @Override
        public byte read(int address) {
            if (address == 0) {
                return this.dir;
            }
            if (address == 1) {
                if (this.dataFalloffBit6 || this.dataFalloffBit7) {
                    if (this.dataSetClkBit6 < C64.this.context.getTime(Event.Phase.PHI2)) {
                        this.dataFalloffBit6 = false;
                        this.dataSetBit6 = false;
                    }
                    if (this.dataSetClkBit7 < C64.this.context.getTime(Event.Phase.PHI2)) {
                        this.dataSetBit7 = false;
                        this.dataFalloffBit7 = false;
                    }
                }
                return (byte)(this.dataRead & 255 - (((!this.dataSetBit6 ? 1 : 0) << 6) + ((!this.dataSetBit7 ? 1 : 0) << 7)));
            }
            return C64.this.ramBank.read(address);
        }

        @Override
        public void write(int address, byte value) {
            if (address == 0) {
                if (this.dataSetBit7 && (value & 0x80) == 0 && !this.dataFalloffBit7) {
                    this.dataFalloffBit7 = true;
                    this.dataSetClkBit7 = C64.this.context.getTime(Event.Phase.PHI2) + 350000L;
                }
                if (this.dataSetBit6 && (value & 0x40) == 0 && !this.dataFalloffBit6) {
                    this.dataFalloffBit6 = true;
                    this.dataSetClkBit6 = C64.this.context.getTime(Event.Phase.PHI2) + 350000L;
                }
                if (this.dataSetBit7 && (value & 0x80) != 0 && this.dataFalloffBit7) {
                    this.dataFalloffBit7 = false;
                }
                if (this.dataSetBit6 && (value & 0x40) != 0 && this.dataFalloffBit6) {
                    this.dataFalloffBit6 = false;
                }
                this.dir = value;
                this.updateCpuPort();
                value = C64.this.pla.getDisconnectedBusBank().read(address);
            } else if (address == 1) {
                if ((this.dir & 0x80) != 0 && (value & 0x80) != 0) {
                    this.dataSetBit7 = true;
                }
                if ((this.dir & 0x40) != 0 && (value & 0x40) != 0) {
                    this.dataSetBit6 = true;
                }
                this.data = value;
                this.updateCpuPort();
                value = C64.this.pla.getDisconnectedBusBank().read(address);
            }
            C64.this.ramBank.write(address, value);
        }
    }
}

