/*
 * Decompiled with CFR 0.152.
 */
package libsidplay.components.c1541;

import java.util.concurrent.Semaphore;
import libsidplay.common.Event;
import libsidplay.common.EventScheduler;
import libsidplay.components.c1541.C1541Runner;

public class SeparateThreadC1541Runner
extends C1541Runner {
    private Thread c1541Thread;
    private final Semaphore semaphore = new Semaphore(0, false);
    private final Event slaveWaitsForMaster = new Event("Slave waits for master"){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void event() throws InterruptedException {
            int allowedTicks = SeparateThreadC1541Runner.this.semaphore.drainPermits();
            if (allowedTicks == 0) {
                Semaphore semaphore = SeparateThreadC1541Runner.this.semaphore;
                synchronized (semaphore) {
                    SeparateThreadC1541Runner.this.semaphore.notify();
                }
                SeparateThreadC1541Runner.this.semaphore.acquire(1);
                allowedTicks = 1 + SeparateThreadC1541Runner.this.semaphore.drainPermits();
            }
            SeparateThreadC1541Runner.this.c1541Context.schedule(this, allowedTicks, Event.Phase.PHI2);
        }
    };

    public SeparateThreadC1541Runner(EventScheduler c64Context, EventScheduler c1541Context) {
        super(c64Context, c1541Context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clockC1541Context(long offset) {
        Semaphore semaphore = this.semaphore;
        synchronized (semaphore) {
            int targetTime = this.updateSlaveTicks(offset);
            if (targetTime <= 0) {
                targetTime = 1;
            }
            this.semaphore.release(targetTime);
            try {
                this.semaphore.wait();
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }
    }

    @Override
    public void reset() {
        this.cancel();
        super.reset();
        this.c64Context.schedule(this, 0L, Event.Phase.PHI2);
        this.startThread();
    }

    @Override
    public void cancel() {
        this.c64Context.cancel(this);
        this.stopThread();
    }

    @Override
    public void synchronize(long offset) {
        this.clockC1541Context(offset);
    }

    @Override
    public void event() throws InterruptedException {
        this.synchronize(0L);
        this.c64Context.schedule(this, 2000L);
    }

    private void startThread() {
        this.c1541Context.schedule(this.slaveWaitsForMaster, 0L, Event.Phase.PHI2);
        this.c1541Thread = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    while (true) {
                        SeparateThreadC1541Runner.this.c1541Context.clock();
                    }
                }
                catch (InterruptedException e) {
                    return;
                }
            }
        });
        this.c1541Thread.start();
    }

    private void stopThread() {
        this.c1541Context.cancel(this.slaveWaitsForMaster);
        this.semaphore.drainPermits();
        while (this.c1541Thread != null && this.c1541Thread.isAlive()) {
            this.c1541Thread.interrupt();
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

