/*
 * Decompiled with CFR 0.152.
 */
package libsidplay.components.cart.supported;

import java.io.DataInputStream;
import java.io.IOException;
import java.util.Arrays;
import libsidplay.common.Event;
import libsidplay.components.cart.Cartridge;
import libsidplay.components.pla.Bank;
import libsidplay.components.pla.PLA;

public class ActionReplay
extends Cartridge {
    boolean isActive;
    protected int currentRomBank;
    protected final byte[][] romLBanks;
    protected boolean exportRam;
    protected final byte[] ram = new byte[8192];
    protected final Bank io1Bank = new Bank(){

        @Override
        public byte read(int address) {
            return ActionReplay.this.pla.getDisconnectedBusBank().read(address);
        }

        @Override
        public void write(int address, byte value) {
            if (ActionReplay.this.isActive) {
                ActionReplay.this.pla.setGameExrom((value & 1) == 0, (value & 2) != 0);
                ActionReplay.this.currentRomBank = value >> 3 & 3;
                boolean bl = ActionReplay.this.exportRam = (value & 0x20) != 0;
                if ((value & 0x40) != 0) {
                    ActionReplay.this.setNMI(false);
                }
                if ((value & 4) != 0) {
                    ActionReplay.this.isActive = false;
                }
            }
        }
    };
    protected final Bank io2Bank = new Bank(){

        @Override
        public byte read(int address) {
            if (!ActionReplay.this.isActive) {
                return ActionReplay.this.pla.getDisconnectedBusBank().read(address);
            }
            if (ActionReplay.this.exportRam) {
                return ActionReplay.this.ram[address & 0x1FFF];
            }
            return ActionReplay.this.romLBanks[ActionReplay.this.currentRomBank][address & 0x1FFF];
        }

        @Override
        public void write(int address, byte value) {
            if (ActionReplay.this.isActive && ActionReplay.this.exportRam) {
                ActionReplay.this.ram[address & 0x1FFF] = value;
            }
        }
    };
    protected final Bank romlBank = new Bank(){

        @Override
        public byte read(int address) {
            if (ActionReplay.this.exportRam) {
                return ActionReplay.this.ram[address & 0x1FFF];
            }
            return ActionReplay.this.romLBanks[ActionReplay.this.currentRomBank][address & 0x1FFF];
        }

        @Override
        public void write(int address, byte value) {
            if (ActionReplay.this.exportRam) {
                ActionReplay.this.ram[address & 0x1FFF] = value;
            }
        }
    };
    protected final Bank romhBank = new Bank(){

        @Override
        public byte read(int address) {
            return ActionReplay.this.romLBanks[ActionReplay.this.currentRomBank][address & 0x1FFF];
        }

        @Override
        public void write(int address, byte value) {
        }
    };
    private final Event newCartRomConfig = Event.of("ActionReplay freeze", event -> {
        this.isActive = true;
        this.io1Bank.write(56832, (byte)35);
    });

    public ActionReplay(DataInputStream dis, PLA pla) throws IOException {
        super(pla);
        byte[] chipHeader = new byte[16];
        this.romLBanks = new byte[4][];
        for (int i = 0; i < 4; ++i) {
            this.romLBanks[i] = new byte[8192];
            dis.readFully(chipHeader);
            if ((chipHeader[11] & 0xFF) > 3) {
                throw new RuntimeException("Unexpected Chip header!");
            }
            int bank = chipHeader[11] & 0xFF;
            dis.readFully(this.romLBanks[bank]);
        }
    }

    @Override
    public Bank getRomh() {
        return this.romhBank;
    }

    @Override
    public Bank getRoml() {
        return this.romlBank;
    }

    @Override
    public Bank getIO1() {
        return this.io1Bank;
    }

    @Override
    public Bank getIO2() {
        return this.io2Bank;
    }

    @Override
    public void reset() {
        super.reset();
        this.isActive = true;
        this.io1Bank.write(56832, (byte)0);
        Arrays.fill(this.ram, (byte)0);
    }

    @Override
    public void installBankHooks(Bank[] cpuReadMap, Bank[] cpuWriteMap) {
        if (!this.exportRam) {
            return;
        }
        for (int i = 8; i < 10; ++i) {
            final Bank origBank = cpuWriteMap[i];
            if (origBank == this.romlBank) continue;
            cpuWriteMap[i] = new Bank(){

                @Override
                public void write(int address, byte value) {
                    origBank.write(address, value);
                    ActionReplay.this.romlBank.write(address, value);
                }
            };
        }
    }

    @Override
    public void doFreeze() {
        this.pla.setNMI(true);
        this.pla.getCPU().getEventScheduler().schedule(this.newCartRomConfig, 3L, Event.Phase.PHI1);
    }
}

