/*
 * Decompiled with CFR 0.152.
 */
package libsidplay.components.cart.supported;

import java.io.DataInputStream;
import java.io.IOException;
import libsidplay.components.cart.Cartridge;
import libsidplay.components.pla.Bank;
import libsidplay.components.pla.PLA;

public class Comal80
extends Cartridge {
    protected int currentRomBank;
    protected final byte[][] romLBanks;
    protected final byte[][] romHBanks;
    private final Bank romlBank = new Bank(){

        @Override
        public byte read(int address) {
            return Comal80.this.romLBanks[Comal80.this.currentRomBank][address & 0x1FFF];
        }
    };
    private final Bank romhBank = new Bank(){

        @Override
        public byte read(int address) {
            return Comal80.this.romHBanks[Comal80.this.currentRomBank][address & 0x1FFF];
        }
    };
    private final Bank io1Bank = new Bank(){

        @Override
        public byte read(int address) {
            return Comal80.this.pla.getDisconnectedBusBank().read(address);
        }

        @Override
        public void write(int address, byte value) {
            int iv = value & 0xFF;
            if (iv >= 128 && iv <= 131) {
                Comal80.this.currentRomBank = value & 3;
            }
        }
    };

    public Comal80(DataInputStream dis, PLA pla) throws IOException {
        super(pla);
        byte[] chipHeader = new byte[16];
        this.romLBanks = new byte[4][];
        this.romHBanks = new byte[4][];
        for (int i = 0; i < 4; ++i) {
            this.romLBanks[i] = new byte[8192];
            this.romHBanks[i] = new byte[8192];
            dis.readFully(chipHeader);
            if (chipHeader[12] != -96 && chipHeader[14] != 64 && chipHeader[11] > 3) {
                throw new RuntimeException("Unexpected Chip header!");
            }
            int bank = chipHeader[11] & 0xFF;
            dis.readFully(this.romLBanks[bank]);
            dis.readFully(this.romHBanks[bank]);
        }
    }

    @Override
    public Bank getRoml() {
        return this.romlBank;
    }

    @Override
    public Bank getRomh() {
        return this.romhBank;
    }

    @Override
    public Bank getIO1() {
        return this.io1Bank;
    }

    @Override
    public void reset() {
        super.reset();
        this.io1Bank.write(56832, (byte)-128);
        this.pla.setGameExrom(false, false);
    }
}

