/*
 * Decompiled with CFR 0.152.
 */
package libsidplay.sidtune;

import java.io.FileOutputStream;
import java.io.IOException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Collection;
import libsidplay.sidtune.MD5Method;
import libsidplay.sidtune.SidTune;
import libsidplay.sidtune.SidTuneError;
import libsidutils.IOUtils;
import libsidutils.sidid.SidIdInfo;
import libsidutils.sidid.SidIdV2;

class Prg
extends SidTune {
    private static SidIdV2 SID_ID;
    private static SidIdInfo SID_ID_INFO;
    protected int programOffset;
    protected byte[] program;

    Prg() {
    }

    protected static SidTune load(String name, byte[] dataBuf) throws SidTuneError {
        if (!IOUtils.getFilenameSuffix(name).equalsIgnoreCase(".prg") || dataBuf.length < 2) {
            throw new SidTuneError("PRG: Bad file extension expected: .prg and length > 2");
        }
        Prg prg = new Prg();
        prg.program = dataBuf;
        prg.programOffset = 2;
        prg.info.c64dataLen = dataBuf.length - prg.programOffset;
        prg.info.loadAddr = (dataBuf[0] & 0xFF) + ((dataBuf[1] & 0xFF) << 8);
        prg.info.infoString.add(IOUtils.getFilenameWithoutSuffix(name));
        return prg;
    }

    @Override
    public void save(String name) throws IOException {
        try (FileOutputStream fos = new FileOutputStream(!name.endsWith(".prg") ? name + ".prg" : name);){
            fos.write(this.program);
        }
    }

    @Override
    public Integer placeProgramInMemory(byte[] mem) {
        int start = this.info.loadAddr;
        int end = start + this.info.c64dataLen;
        mem[45] = (byte)(end & 0xFF);
        mem[46] = (byte)(end >> 8);
        mem[47] = (byte)(end & 0xFF);
        mem[48] = (byte)(end >> 8);
        mem[49] = (byte)(end & 0xFF);
        mem[50] = (byte)(end >> 8);
        mem[172] = (byte)(start & 0xFF);
        mem[173] = (byte)(start >> 8);
        mem[174] = (byte)(end & 0xFF);
        mem[175] = (byte)(end >> 8);
        System.arraycopy(this.program, this.programOffset, mem, start, end - start);
        return null;
    }

    @Override
    public Integer placeProgramInMemory(byte[] mem, byte[] driver) {
        int start = this.info.loadAddr;
        int end = start + this.info.c64dataLen;
        mem[45] = (byte)(end & 0xFF);
        mem[46] = (byte)(end >> 8);
        mem[47] = (byte)(end & 0xFF);
        mem[48] = (byte)(end >> 8);
        mem[49] = (byte)(end & 0xFF);
        mem[50] = (byte)(end >> 8);
        mem[172] = (byte)(start & 0xFF);
        mem[173] = (byte)(start >> 8);
        mem[174] = (byte)(end & 0xFF);
        mem[175] = (byte)(end >> 8);
        System.arraycopy(this.program, this.programOffset, mem, start, end - start);
        return null;
    }

    @Override
    public Collection<String> identify() {
        if (SID_ID == null) {
            try {
                SID_ID = new SidIdV2();
                SID_ID.readconfig();
                SID_ID.setMultiScan(true);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return SID_ID.identify(this.program);
    }

    @Override
    public Collection<String> identify(byte[] sidIdCfgBin) {
        if (SID_ID == null) {
            try {
                SID_ID = new SidIdV2();
                SID_ID.readconfig(sidIdCfgBin);
                SID_ID.setMultiScan(true);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return SID_ID.identify(this.program);
    }

    @Override
    public SidIdInfo.PlayerInfoSection getPlayerInfo(String playerName) {
        if (SID_ID_INFO == null) {
            try {
                SID_ID_INFO = new SidIdInfo();
                SID_ID_INFO.readconfig();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return SID_ID_INFO.getPlayerInfo(playerName);
    }

    @Override
    public SidIdInfo.PlayerInfoSection getPlayerInfo(String playerName, byte[] sidIdInfoBin) {
        if (SID_ID_INFO == null) {
            try {
                SID_ID_INFO = new SidIdInfo();
                SID_ID_INFO.readconfig(sidIdInfoBin);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return SID_ID_INFO.getPlayerInfo(playerName);
    }

    @Override
    public String getMD5Digest(MD5Method md5Method) {
        StringBuilder md5 = new StringBuilder();
        try {
            byte[] encryptMsg;
            for (byte anEncryptMsg : encryptMsg = MessageDigest.getInstance("MD5").digest(this.program)) {
                md5.append(Character.forDigit(anEncryptMsg >> 4 & 0xF, 16));
                md5.append(Character.forDigit(anEncryptMsg & 0xF, 16));
            }
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
        return md5.toString();
    }

    @Override
    protected long getInitDelay() {
        return 2500000L;
    }
}

