/*
 * Decompiled with CFR 0.152.
 */
package libsidutils.directory;

import java.io.File;
import java.io.IOException;
import libsidplay.components.c1541.DiskImage;
import libsidplay.components.c1541.GCR;
import libsidutils.directory.DirEntry;
import libsidutils.directory.Directory;

public class DiskDirectory
extends Directory {
    private static final int NR_ENTRIES_PER_BLOCK = 7;
    private static final int DIR_ENTRY_SIZE = 32;

    public DiskDirectory(File file) throws IOException {
        final DiskImage img = DiskImage.attach(new GCR(), file);
        int[] arrCyclicAccessInfo = new int[1260];
        byte[] sectorBytes = new byte[260];
        img.getDiskSector(18, 0, sectorBytes);
        int afterBamInfos = 145;
        int freeBlocks = 0;
        for (int i = 1; i <= 35; ++i) {
            if (i == 18) continue;
            freeBlocks += sectorBytes[5 + (i - 1) * 4] & 0xFF;
        }
        byte[] diskName = new byte[16];
        byte[] diskID = new byte[5];
        System.arraycopy(sectorBytes, afterBamInfos, diskName, 0, diskName.length);
        System.arraycopy(sectorBytes, afterBamInfos + 18, diskID, 0, diskID.length);
        this.singleSided = (sectorBytes[4] & 0x80) == 0;
        this.title = diskName;
        this.id = diskID;
        this.statusLine = String.format("%-3d BLOCKS FREE.", freeBlocks);
        byte[] currSector = new byte[260];
        int nextTrack = 18;
        int nextSector = 1;
        int currNextSector = 0;
        int currNextTrack = 0;
        int nextEntry = -1;
        while (true) {
            if (nextEntry < 7) {
                ++nextEntry;
            } else {
                if (currNextTrack == 0) break;
                nextTrack = currNextTrack;
                nextSector = currNextSector;
                nextEntry = 0;
            }
            if (!img.getDiskSector(nextTrack, nextSector, currSector) || nextEntry == 0 && currNextTrack != 0 && arrCyclicAccessInfo[nextSector] != 0) break;
            int n = nextSector;
            arrCyclicAccessInfo[n] = arrCyclicAccessInfo[n] + 1;
            currNextTrack = currSector[1] & 0xFF;
            currNextSector = currSector[2] & 0xFF;
            byte[] entryBytes = new byte[32];
            System.arraycopy(currSector, 1 + nextEntry * 32, entryBytes, 0, 32);
            byte fileType = entryBytes[2];
            if (fileType == 0) continue;
            final byte firstFileTrack = entryBytes[3];
            final byte firstFileSector = entryBytes[4];
            byte[] fn = new byte[16];
            System.arraycopy(entryBytes, 5, fn, 0, 16);
            byte lowByte = entryBytes[30];
            byte highByte = entryBytes[31];
            int nrSectors = (lowByte & 0xFF) + ((highByte & 0xFF) << 8);
            this.dirEntries.add(new DirEntry(nrSectors, fn, fileType){

                @Override
                public void save(File autostartFile) throws IOException {
                    img.save(autostartFile, firstFileTrack, firstFileSector);
                }
            });
        }
        img.detach();
    }
}

