/*
 * Decompiled with CFR 0.152.
 */
package libsidutils.fingerprinting.ini;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import libsidutils.fingerprinting.ini.IFingerprintConfig;
import libsidutils.fingerprinting.ini.IFingerprintSection;
import libsidutils.fingerprinting.ini.IniFingerprintSection;
import sidplay.ini.IniReader;
import sidplay.ini.converter.BeanToStringConverter;

public class IniFingerprintConfig
implements IFingerprintConfig {
    private static final String FILE_NAME = "fingerprint.ini";
    private static IniFingerprintConfig singleInstance;
    private final File iniPath;
    private IFingerprintSection fingerPrintSection;
    protected IniReader iniReader;

    private void clear() {
        this.fingerPrintSection = new IniFingerprintSection(this.iniReader);
    }

    public static IniFingerprintConfig getDefault() {
        if (singleInstance == null) {
            singleInstance = new IniFingerprintConfig();
        }
        return singleInstance;
    }

    public IniFingerprintConfig() {
        this(false, null);
    }

    public IniFingerprintConfig(boolean createIfNotExists) {
        this(createIfNotExists, IniFingerprintConfig.getINIPath());
    }

    private IniFingerprintConfig(boolean createIfNotExists, File iniPath) {
        this.iniPath = iniPath;
        if (iniPath != null && iniPath.exists()) {
            try (FileInputStream is = new FileInputStream(iniPath);){
                this.iniReader = new IniReader(is);
                this.clear();
                if (this.fingerPrintSection.getVersion() == 1) {
                    if (createIfNotExists) {
                        System.out.println("Use INI file: " + iniPath);
                    }
                    return;
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            this.createINIBackup(iniPath);
            System.out.println("Use internal INI file: fingerprint.ini");
        }
        this.readInternal();
        if (iniPath != null && !iniPath.exists() && createIfNotExists) {
            this.write();
        }
    }

    public static File getINIPath() {
        for (String parent : new String[]{System.getProperty("user.dir"), System.getProperty("user.home")}) {
            File configPlace = new File(parent, FILE_NAME);
            if (!configPlace.exists()) continue;
            return configPlace;
        }
        return new File(System.getProperty("user.home"), FILE_NAME);
    }

    private void createINIBackup(File iniFile) {
        File bakFile = new File(iniFile.getParentFile(), "fingerprint.ini.bak");
        iniFile.renameTo(bakFile);
        int currentVersion = this.fingerPrintSection.getVersion();
        System.out.println("Configuration file version=" + currentVersion + " is older than expected version=" + 1 + ", a backup has been created: " + bakFile);
    }

    private void readInternal() {
        try (InputStream is = this.getClass().getClassLoader().getResourceAsStream("libsidutils/fingerprinting/ini/fingerprint.ini");){
            this.iniReader = new IniReader(is);
            this.clear();
            this.fingerPrintSection.setVersion(1);
        }
        catch (IOException e) {
            e.printStackTrace();
            return;
        }
    }

    public final void write() {
        if (!this.iniReader.isDirty()) {
            return;
        }
        System.out.println("Save INI file: " + this.iniPath);
        try {
            this.iniReader.save(this.iniPath.getAbsolutePath());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public final IFingerprintSection getFingerPrintSection() {
        return this.fingerPrintSection;
    }

    public final String toString() {
        return BeanToStringConverter.toString(this);
    }
}

