/*
 * Decompiled with CFR 0.152.
 */
package libsidutils.vicesync;

import java.io.IOException;
import libsidplay.common.Event;
import libsidplay.common.EventScheduler;
import libsidplay.components.mos6510.MOS6510;
import libsidutils.vicesync.ViceSync;

public class MOS6510ViceSync
extends MOS6510 {
    private final int cmpPC = 7681;
    private final byte cmpAcc = 0;
    private final byte cmpX = (byte)120;
    private final byte cmpY = (byte)4;
    private final byte cmpSP = (byte)-22;
    private ViceSync sync = new ViceSync();
    private long syncClk;
    private boolean sockedStarted;
    private boolean startComparison;

    public MOS6510ViceSync(EventScheduler context) {
        super(context);
    }

    @Override
    protected void fetchNextOpcode() {
        if (!this.sockedStarted) {
            try {
                this.sync.connect(6510);
                this.sockedStarted = true;
                this.sync.send(String.format("%04X,%02X,%02X,%02X,%02X", 7681, (byte)0, (byte)120, (byte)4, (byte)-22));
            }
            catch (IOException e) {
                e.printStackTrace();
                System.exit(0);
            }
        }
        if (this.sockedStarted) {
            try {
                if (!this.startComparison && this.Register_ProgramCounter == 7681 && this.Register_Accumulator == 0 && this.Register_X == 120 && this.Register_Y == 4 && this.Register_StackPointer == -22) {
                    this.syncClk = this.context.getTime(Event.Phase.PHI2);
                    this.startComparison = true;
                }
                if (this.startComparison) {
                    String received = this.sync.receive();
                    ViceSync.MOS6510State viceState = this.sync.getState(received);
                    this.sync.send("");
                    System.out.println(viceState.toString());
                    ViceSync.MOS6510State jsidplay2State = new ViceSync.MOS6510State(this.context.getTime(Event.Phase.PHI2) - this.syncClk, this.Register_ProgramCounter, this.Register_Accumulator, this.Register_X, this.Register_Y, this.Register_StackPointer);
                    System.out.println(jsidplay2State.toString());
                    if (this.Register_ProgramCounter == 7681 && (this.Register_Accumulator & 0xFF) == 0 && (this.Register_X & 0xFF) == 120 && (this.Register_Y & 0xFF) == 4 && (this.Register_StackPointer & 0xFF) == 234) {
                        this.sync.send("break");
                        System.out.println("Until here we have exactly the same state!!!");
                    }
                    if (this.cycleCount > 7 && !jsidplay2State.equals(viceState)) {
                        System.out.println("This is the first point where they differ, do some analysis here!!!");
                        System.err.println("Differs: " + jsidplay2State.equals(viceState));
                    }
                }
            }
            catch (IOException e) {
                e.printStackTrace();
                System.exit(0);
            }
        }
        super.fetchNextOpcode();
    }
}

