/*
 * Decompiled with CFR 0.152.
 */
package server.netsiddev;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.nio.charset.StandardCharsets;
import server.netsiddev.SIDDeviceSettings;
import server.netsiddev.ini.JSIDDeviceConfig;

public class DetectionThread
extends Thread {
    private static final String MAGIC_ID = "SidDevice";
    private DatagramSocket socket;
    private byte[] buf = new byte[512];
    private String localIp;
    private String systemName;

    public DetectionThread(JSIDDeviceConfig config) {
        try {
            InetAddress inetAddress = InetAddress.getLocalHost();
            this.localIp = inetAddress.getHostAddress();
            this.systemName = inetAddress.getHostName();
            this.socket = new DatagramSocket(config.jsiddevice().getPort());
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    @Override
    public void run() {
        boolean running = true;
        String osName = System.getProperty("os.name");
        String osArch = DetectionThread.is64Bit() ? "64-bit" : "32-bit";
        byte[] responseData = (MAGIC_ID + "," + this.systemName + "," + osName + " " + osArch).getBytes(StandardCharsets.US_ASCII);
        SIDDeviceSettings settings = SIDDeviceSettings.getInstance();
        DatagramPacket incomingPacket = new DatagramPacket(this.buf, this.buf.length);
        DatagramPacket responsePacket = new DatagramPacket(responseData, responseData.length);
        while (running) {
            try {
                this.socket.receive(incomingPacket);
                String received = new String(incomingPacket.getData(), 0, incomingPacket.getLength(), StandardCharsets.US_ASCII.name());
                if (!received.startsWith(MAGIC_ID) || !this.isLocalIp(incomingPacket) && !settings.getAllowExternalConnections()) continue;
                responsePacket.setAddress(incomingPacket.getAddress());
                responsePacket.setPort(incomingPacket.getPort());
                this.socket.send(responsePacket);
            }
            catch (IOException ex) {
                ex.printStackTrace();
                running = false;
            }
        }
        this.socket.close();
    }

    private boolean isLocalIp(DatagramPacket incomingPacket) {
        return incomingPacket.getAddress().getHostAddress().equals(this.localIp);
    }

    private static boolean is64Bit() {
        String arch = System.getProperty("os.arch");
        String wow64Arch = System.getenv("PROCESSOR_ARCHITEW6432");
        return arch != null && arch.contains("64") || wow64Arch != null && wow64Arch.contains("64");
    }
}

