/*
 * Decompiled with CFR 0.152.
 */
package server.restful.common.text2speech;

import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Locale;
import java.util.Optional;
import java.util.ResourceBundle;
import libsidutils.IOUtils;
import libsidutils.stil.STIL;
import sidplay.Player;

public class TextToSpeechBean {
    private File tuneFile;
    private Player player;
    private Locale textToSpeechLocale;
    private double volume;
    private Integer songNo;
    private String title;
    private String author;
    private String released;
    private String songName;
    private String basedOnTitle;
    private String basedOnArtist;
    private boolean andMore;

    public Integer getSongNo() {
        return this.songNo;
    }

    public String getTitle() {
        return this.title;
    }

    public String getAuthor() {
        return this.author;
    }

    public String getReleased() {
        return this.released;
    }

    public String getName() {
        return this.songName;
    }

    public String getBasedOnTitle() {
        return this.basedOnTitle;
    }

    public String getBasedOnArtist() {
        return this.basedOnArtist;
    }

    public boolean isAndMore() {
        return this.andMore;
    }

    public Locale getTextToSpeechLocale() {
        return this.textToSpeechLocale;
    }

    public void setVolume(double volume) {
        this.volume = volume;
    }

    public double getVolume() {
        return this.volume;
    }

    public TextToSpeechBean(File tuneFile, Player player, Locale textToSpeechLocale) {
        this.tuneFile = tuneFile;
        this.player = player;
        this.textToSpeechLocale = textToSpeechLocale;
    }

    protected void determineText2Speak(ResourceBundle resourceBundle) {
        Iterator<STIL.Info> subTuneInfoIt;
        Optional<STIL.TuneEntry> subTune;
        STIL.STILEntry stilEntry;
        Iterator infoIt;
        String next;
        Iterator<String> it;
        if (this.player.getTune().getInfo().getSongs() > 1) {
            this.songNo = this.player.getTune().getInfo().getCurrentSong();
        }
        if ((it = this.player.getTune().getInfo().getInfoString().iterator()).hasNext()) {
            next = it.next().replace("<?>", "");
            String string = this.title = next.isEmpty() ? resourceBundle.getString("UNKNOWN_TITLE") : next;
        }
        if (it.hasNext() && !(next = it.next().replace("<?>", "")).isEmpty()) {
            this.author = next;
        }
        if (it.hasNext() && !(next = it.next().replace("<?>", "")).isEmpty()) {
            this.released = next;
        }
        if ((infoIt = Optional.ofNullable(stilEntry = this.player.getStilEntry(this.getCollectionName(this.player, this.tuneFile))).map(STIL.STILEntry::getInfos).orElse(new ArrayList()).iterator()).hasNext()) {
            STIL.Info next2 = (STIL.Info)infoIt.next();
            this.basedOnTitle = Optional.ofNullable(next2.title).map(title -> title.replace("<?>", "")).orElse(null);
            this.basedOnArtist = Optional.ofNullable(next2.artist).map(artist -> artist.replace("<?>", "")).orElse(null);
        }
        if ((this.basedOnTitle == null || this.basedOnTitle.isEmpty()) && (this.basedOnArtist == null || this.basedOnArtist.isEmpty()) && this.songNo != null && (subTune = Optional.ofNullable(stilEntry).map(STIL.STILEntry::getSubTunes).orElse(new ArrayList()).stream().filter(e -> this.songNo.equals(e.tuneNo)).findFirst()).isPresent() && (subTuneInfoIt = subTune.get().infos.iterator()).hasNext()) {
            STIL.Info nextSubTuneInfo = subTuneInfoIt.next();
            String next3 = Optional.ofNullable(nextSubTuneInfo.name).map(name -> name.replace("<?>", "")).orElse("");
            this.songName = next3.isEmpty() ? null : next3;
            next3 = Optional.ofNullable(nextSubTuneInfo.author).map(author -> author.replace("<?>", "")).orElse("");
            this.author = next3.isEmpty() ? this.author : next3;
            next3 = Optional.ofNullable(nextSubTuneInfo.title).map(title -> title.replace("<?>", "")).orElse("");
            this.basedOnTitle = next3.isEmpty() ? null : next3;
            next3 = Optional.ofNullable(nextSubTuneInfo.artist).map(artist -> artist.replace("<?>", "")).orElse("");
            this.basedOnArtist = next3.isEmpty() ? null : next3;
            this.andMore = subTuneInfoIt.hasNext();
        }
    }

    private String getCollectionName(Player player, File file) {
        String result = "";
        File hvscRoot = player.getConfig().getSidplay2Section().getHvsc();
        if (hvscRoot != null && (result = IOUtils.getCollectionName(hvscRoot, file)).isEmpty()) {
            result = player.getSidDatabaseInfo(sidDatabase -> sidDatabase.getPath(player.getTune()), "");
        }
        return result;
    }
}

