/*
 * Decompiled with CFR 0.152.
 */
package server.restful.servlets;

import com.beust.jcommander.Parameters;
import jakarta.servlet.AsyncContext;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.annotation.HttpConstraint;
import jakarta.servlet.annotation.ServletSecurity;
import jakarta.servlet.annotation.WebServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import java.util.Optional;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import jsidplay2.Photos;
import libsidplay.sidtune.SidTune;
import libsidplay.sidtune.SidTuneError;
import libsidplay.sidtune.SidTuneInfo;
import server.restful.common.ContentTypeAndFileExtensions;
import server.restful.common.IServletSystemProperties;
import server.restful.common.JSIDPlay2Servlet;
import server.restful.common.ServletUtil;
import server.restful.common.async.DefaultThreadFactory;
import server.restful.common.async.HttpAsyncContextRunnable;
import server.restful.common.parameter.ServletParameterParser;
import server.restful.common.parameter.requestpath.FileRequestPathServletParameters;

@WebServlet(name="PhotoServlet", displayName="PhotoServlet", asyncSupported=true, urlPatterns={"/jsidplay2service/JSIDPlay2REST/photo/*"}, description="Get photo of composer")
@ServletSecurity(value=@HttpConstraint(rolesAllowed={"user", "admin"}))
public class PhotoServlet
extends JSIDPlay2Servlet {
    private ExecutorService executorService;

    public void init() throws ServletException {
        this.executorService = Executors.newFixedThreadPool(IServletSystemProperties.PhotoServlet.MAX_PHOTO_IN_PARALLEL, new DefaultThreadFactory("/photo"));
    }

    public void destroy() {
        this.executorService.shutdown();
    }

    @Override
    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        AsyncContext asyncContext = request.startAsync((ServletRequest)request, (ServletResponse)response);
        asyncContext.setTimeout((long)IServletSystemProperties.PhotoServlet.PHOTO_ASYNC_TIMEOUT);
        this.executorService.execute(new HttpAsyncContextRunnable(asyncContext, this.getServletContext()){

            @Override
            public void run(HttpServletRequest request, HttpServletResponse response) throws IOException {
                block4: {
                    try {
                        PhotoServletParameters servletParameters = new PhotoServletParameters();
                        ServletParameterParser parser = new ServletParameterParser(request, response, servletParameters);
                        File file = servletParameters.fetchFile(PhotoServlet.this.configuration, PhotoServlet.this.directoryProperties, parser, PhotoServlet.this.hasAdminAccess(request));
                        if (file == null || servletParameters.getHelp().booleanValue() || parser.hasException()) {
                            parser.usage();
                            return;
                        }
                        byte[] photo = PhotoServlet.this.getPhoto(file);
                        if (!this.isComplete()) {
                            response.setContentLength(photo.length);
                            PhotoServlet.this.setOutput(ContentTypeAndFileExtensions.MIME_TYPE_JPG, response, new ByteArrayInputStream(photo));
                        }
                    }
                    catch (Throwable t) {
                        ServletUtil.error(PhotoServlet.this.getServletContext(), t, this.parentThread);
                        if (this.isComplete()) break block4;
                        response.setStatus(500);
                        PhotoServlet.this.setOutput(response, t);
                    }
                }
            }
        });
    }

    private byte[] getPhoto(File file) throws IOException, SidTuneError {
        SidTuneInfo info;
        String authorDirectory = this.getCollectionName(file);
        if (!authorDirectory.isEmpty()) {
            authorDirectory = new File(authorDirectory).getParent();
        }
        String author = null;
        if (file != null && (info = SidTune.load(file).getInfo()).getInfoString().size() > 1) {
            Iterator<String> iterator = info.getInfoString().iterator();
            iterator.next();
            author = iterator.next();
        }
        return Optional.ofNullable(Photos.getPhoto((String)authorDirectory, author)).orElse(new byte[0]);
    }

    @Parameters(resourceBundle="server.restful.servlets.PhotoServletParameters")
    public static class PhotoServletParameters
    extends FileRequestPathServletParameters {
    }
}

