/*
 * Decompiled with CFR 0.152.
 */
package server.restful.servlets.rtmp;

import com.beust.jcommander.Parameter;
import com.beust.jcommander.Parameters;
import jakarta.servlet.ServletException;
import jakarta.servlet.annotation.HttpConstraint;
import jakarta.servlet.annotation.ServletSecurity;
import jakarta.servlet.annotation.WebServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.UUID;
import server.restful.common.JSIDPlay2Servlet;
import server.restful.common.ServletUtil;
import server.restful.common.parameter.ServletParameterParser;
import server.restful.common.parameter.requestparam.VideoRequestParamServletParameters;
import server.restful.common.rtmp.PlayerCleanupTimerTask;
import server.restful.common.validator.JoystickNumberValidator;
import server.restful.common.validator.JoystickValueValidator;

@WebServlet(name="JoystickServlet", displayName="JoystickServlet", urlPatterns={"/static/joystick"}, description="Press joystick 1/2 for emulator running as a RTMP live video stream")
@ServletSecurity(value=@HttpConstraint(rolesAllowed={"user", "admin"}))
public class JoystickServlet
extends JSIDPlay2Servlet {
    @Override
    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        try {
            JoystickServletParameters servletParameters = new JoystickServletParameters();
            ServletParameterParser parser = new ServletParameterParser(request, response, servletParameters);
            if (servletParameters.getHelp().booleanValue() || parser.hasException()) {
                parser.usage();
                return;
            }
            UUID uuid = servletParameters.getUuid();
            int number = servletParameters.getNumber();
            int value = servletParameters.getValue();
            ServletUtil.info(this.getServletContext(), String.format("joystick: RTMP stream of: %s, number=%d, value=%d", uuid, number, value), new Thread[0]);
            PlayerCleanupTimerTask.update(uuid, rtmpPlayerWithStatus -> rtmpPlayerWithStatus.joystick(number, value));
        }
        catch (Throwable t) {
            response.setStatus(500);
            ServletUtil.error(this.getServletContext(), t, new Thread[0]);
            this.setOutput(response, t);
        }
    }

    @Parameters(resourceBundle="server.restful.servlets.rtmp.JoystickServletParameters")
    public static class JoystickServletParameters
    extends VideoRequestParamServletParameters {
        private int number;
        private int value;

        public int getNumber() {
            return this.number;
        }

        @Parameter(names={"--number"}, descriptionKey="NUMBER", validateWith={JoystickNumberValidator.class}, order=-2147483646)
        public void setNumber(int number) {
            this.number = number;
        }

        public int getValue() {
            return this.value;
        }

        @Parameter(names={"--value"}, descriptionKey="VALUE", validateWith={JoystickValueValidator.class}, order=-2147483645)
        public void setValue(int value) {
            this.value = value;
        }
    }
}

