/*
 * Decompiled with CFR 0.152.
 */
package sidplay.audio;

import com.xuggle.xuggler.ICodec;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.List;
import libsidplay.common.SamplingRate;
import sidplay.audio.xuggle.XuggleAudioDriver;

public abstract class FLACDriver
extends XuggleAudioDriver {
    @Override
    protected List<SamplingRate> getSupportedSamplingRates() {
        return Arrays.asList(SamplingRate.VERY_LOW, SamplingRate.LOW, SamplingRate.MEDIUM, SamplingRate.HIGH);
    }

    @Override
    protected SamplingRate getDefaultSamplingRate() {
        return SamplingRate.LOW;
    }

    @Override
    protected ICodec.ID getAudioCodec() {
        return ICodec.ID.CODEC_ID_FLAC;
    }

    @Override
    protected String getOutputFormatName() {
        return "flac";
    }

    @Override
    public String getExtension() {
        return ".flac";
    }

    public static class FLACStreamDriver
    extends FLACDriver {
        public FLACStreamDriver(OutputStream out) {
            this.out = out;
        }

        @Override
        protected OutputStream getOut(String recordingFilename) {
            return this.out;
        }
    }

    public static class FLACFileDriver
    extends FLACDriver {
        @Override
        protected OutputStream getOut(String recordingFilename) throws IOException {
            System.out.println("Recording, file=" + recordingFilename);
            return new FileOutputStream(recordingFilename);
        }

        @Override
        public void close() {
            super.close();
            if (this.out != null) {
                try {
                    this.out.close();
                }
                catch (IOException e) {
                    throw new RuntimeException("Error closing FLAC audio stream", e);
                }
                finally {
                    this.out = null;
                }
            }
        }
    }
}

