/*
 * Decompiled with CFR 0.152.
 */
package sidplay.audio.processors.reverb;

public class AllpassNetwork {
    private int sampleBufferSize;
    private int sampleRate;
    private int numberOfChannels;
    private double delayInMs;
    private double sustainTimeInMs;
    private double gain1;
    private double gain2;
    private double gain3;
    private int sustainSampleCount;
    private double[] delayBuffer;
    private int delayBufferSize;
    private int writeIndex;
    private int readIndex;

    public AllpassNetwork(int sampleRate, int numberOfChannels, double delayInMs, int sampleBufferSize) {
        this.sampleRate = sampleRate;
        this.numberOfChannels = numberOfChannels;
        this.sampleBufferSize = sampleBufferSize;
        double networkGain = 0.7;
        this.gain1 = -networkGain;
        this.gain2 = 1.0 - networkGain * networkGain;
        this.gain3 = networkGain;
        this.sustainTimeInMs = 65.0;
        this.setDelayInMs(delayInMs);
    }

    public void setDelayInMs(double delayInMs) {
        this.delayInMs = delayInMs;
        int delayOffset = (int)((delayInMs + 0.5) * (double)this.sampleRate * (double)this.numberOfChannels) / 1000;
        this.delayBufferSize = this.sampleBufferSize + delayOffset;
        this.delayBuffer = new double[this.delayBufferSize];
        this.writeIndex = 0;
        this.readIndex = this.sampleBufferSize;
        this.calcGain();
    }

    public double getDelayInMs() {
        return this.delayInMs;
    }

    private void calcGain() {
        double gain = Math.pow(0.001, this.delayInMs / this.sustainTimeInMs);
        this.gain1 = -gain;
        this.gain2 = 1.0 - gain * gain;
        this.gain3 = gain;
    }

    public void setSustainTimeInMs(double sustainTimeInMs) {
        this.sustainTimeInMs = sustainTimeInMs;
        this.sustainSampleCount = (int)(sustainTimeInMs * (double)this.sampleRate * (double)this.numberOfChannels / 1000.0);
        this.calcGain();
    }

    public double getSustainTimeInMs() {
        return this.sustainTimeInMs;
    }

    public int doFilter(double[] inBuf, double[] outBuf, int length) {
        if (length != -1) {
            for (int i = 0; i < length; ++i) {
                double inSample = inBuf[i];
                double outSample = inSample * this.gain1;
                double delaySample = this.delayBuffer[this.readIndex++];
                outBuf[i] = outSample += delaySample * this.gain2;
                this.delayBuffer[this.writeIndex++] = inSample += delaySample * this.gain3;
                if (this.readIndex == this.delayBufferSize) {
                    this.readIndex = 0;
                }
                if (this.writeIndex != this.delayBufferSize) continue;
                this.writeIndex = 0;
            }
            return length;
        }
        int samplesToMove = Math.min(outBuf.length, this.sustainSampleCount);
        if (samplesToMove <= 0) {
            return -1;
        }
        for (int i = 0; i < samplesToMove; ++i) {
            double outSample;
            double delaySample = this.delayBuffer[this.readIndex++];
            outBuf[i] = outSample = delaySample * this.gain2;
            double inSample = delaySample * this.gain3;
            this.delayBuffer[this.writeIndex++] = inSample;
            if (this.readIndex == this.delayBufferSize) {
                this.readIndex = 0;
            }
            if (this.writeIndex == this.delayBufferSize) {
                this.writeIndex = 0;
            }
            --this.sustainSampleCount;
        }
        return samplesToMove;
    }
}

