/*
 * Decompiled with CFR 0.152.
 */
package sidplay.fingerprinting;

import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.Scanner;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import libsidutils.fingerprinting.IFingerprintMatcher;
import libsidutils.fingerprinting.rest.beans.MusicInfoBean;
import libsidutils.fingerprinting.rest.beans.MusicInfoWithConfidenceBean;
import libsidutils.fingerprinting.rest.beans.WAVBean;

public class FingerprintJsonClient
implements IFingerprintMatcher {
    private static final Pattern JSON_STRING_PATTERN = Pattern.compile("\"[^\"]*\":\"[^\"]*\"");
    private static final Pattern JSON_NUMERIC_PATTERN = Pattern.compile("\"[^\"]*\":[0-9.]+");
    private String url;
    private String username;
    private String password;
    private int connectionTimeout;

    public FingerprintJsonClient(String url, String username, String password, int connectionTimeout) {
        this.url = url;
        this.username = username;
        this.password = password;
        this.connectionTimeout = connectionTimeout;
    }

    @Override
    public MusicInfoWithConfidenceBean match(WAVBean wavBean) throws IOException {
        try {
            HttpURLConnection connection = this.sendJson(wavBean);
            if (connection != null && connection.getResponseCode() == 200 && connection.getContentLength() > 0) {
                return this.receiveJson(connection);
            }
        }
        catch (IOException | URISyntaxException e) {
            e.printStackTrace();
        }
        return null;
    }

    private HttpURLConnection sendJson(WAVBean wavBean) throws IOException, URISyntaxException {
        String header = Base64.getEncoder().encodeToString((this.username + ":" + this.password).getBytes(StandardCharsets.UTF_8));
        String wavBytes = Base64.getEncoder().encodeToString(wavBean.getWav());
        HttpURLConnection connection = (HttpURLConnection)new URI(this.url + "/whatssid").toURL().openConnection();
        connection.setConnectTimeout(this.connectionTimeout);
        connection.setDoOutput(true);
        connection.setInstanceFollowRedirects(false);
        connection.setRequestMethod("POST");
        connection.setRequestProperty("Authorization", "Basic " + header);
        connection.setRequestProperty("Content-Type", "application/json");
        connection.setRequestProperty("Accept", "application/json");
        connection.getOutputStream().write(("{\"wav\": \"" + wavBytes + "\"}").getBytes(StandardCharsets.UTF_8));
        connection.getOutputStream().flush();
        return connection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MusicInfoWithConfidenceBean receiveJson(HttpURLConnection connection) throws IOException {
        try {
            String[] keyValue;
            String response = null;
            try (Scanner scanner = new Scanner(connection.getInputStream(), StandardCharsets.UTF_8.name());){
                response = scanner.useDelimiter("\\A").next();
            }
            MusicInfoWithConfidenceBean match = new MusicInfoWithConfidenceBean();
            match.setMusicInfo(new MusicInfoBean());
            Matcher m = JSON_STRING_PATTERN.matcher(response);
            while (m.find()) {
                keyValue = m.group().split(":");
                this.setMatch(keyValue[0], keyValue[1], match);
            }
            m = JSON_NUMERIC_PATTERN.matcher(response);
            while (m.find()) {
                keyValue = m.group().split(":");
                this.setMatch(keyValue[0], keyValue[1], match);
            }
            MusicInfoWithConfidenceBean musicInfoWithConfidenceBean = match;
            return musicInfoWithConfidenceBean;
        }
        finally {
            connection.disconnect();
        }
    }

    private void setMatch(String key, String value, MusicInfoWithConfidenceBean match) {
        switch (key) {
            case "\"songNo\"": {
                match.getMusicInfo().setSongNo(Integer.parseInt(value));
                break;
            }
            case "\"title\"": {
                match.getMusicInfo().setTitle(value.substring(1, value.length() - 1));
                break;
            }
            case "\"artist\"": {
                match.getMusicInfo().setArtist(value.substring(1, value.length() - 1));
                break;
            }
            case "\"album\"": {
                match.getMusicInfo().setAlbum(value.substring(1, value.length() - 1));
                break;
            }
            case "\"fileDir\"": {
                match.getMusicInfo().setFileDir(value.substring(1, value.length() - 1));
                break;
            }
            case "\"infoDir\"": {
                match.getMusicInfo().setInfoDir(value.substring(1, value.length() - 1));
                break;
            }
            case "\"audioLength\"": {
                match.getMusicInfo().setAudioLength(Double.parseDouble(value));
                break;
            }
            case "\"confidence\"": {
                match.setConfidence(Integer.parseInt(value));
                break;
            }
            case "\"relativeConfidence\"": {
                match.setRelativeConfidence(Double.parseDouble(value));
                break;
            }
            case "\"offset\"": {
                match.setOffset(Integer.parseInt(value));
                break;
            }
            case "\"offsetSeconds\"": {
                match.setOffsetSeconds(Double.parseDouble(value));
                break;
            }
        }
    }
}

