/*
 * Decompiled with CFR 0.152.
 */
package sidplay.ini;

import com.beust.jcommander.ParametersDelegate;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import libsidplay.config.IAudioSection;
import libsidplay.config.IC1541Section;
import libsidplay.config.IConfig;
import libsidplay.config.IConsoleSection;
import libsidplay.config.IEmulationSection;
import libsidplay.config.IFilterSection;
import libsidplay.config.IPrinterSection;
import libsidplay.config.ISidPlay2Section;
import libsidplay.config.IWhatsSidSection;
import sidplay.ini.IniAudioSection;
import sidplay.ini.IniC1541Section;
import sidplay.ini.IniConsoleSection;
import sidplay.ini.IniEmulationSection;
import sidplay.ini.IniFilterSection;
import sidplay.ini.IniPrinterSection;
import sidplay.ini.IniReader;
import sidplay.ini.IniSidplay2Section;
import sidplay.ini.IniWhatsSidSection;
import sidplay.ini.converter.BeanToStringConverter;

public class IniConfig
implements IConfig {
    private static final String FILE_NAME = "jsidplay2.ini";
    private static IniConfig singleInstance;
    private final File iniPath;
    @ParametersDelegate
    private ISidPlay2Section sidplay2Section;
    @ParametersDelegate
    private IC1541Section c1541Section;
    @ParametersDelegate
    private IPrinterSection printerSection;
    @ParametersDelegate
    private IConsoleSection consoleSection;
    @ParametersDelegate
    private IAudioSection audioSection;
    @ParametersDelegate
    private IEmulationSection emulationSection;
    @ParametersDelegate
    private IWhatsSidSection whatsSidSection;
    protected IniReader iniReader;

    private void clear() {
        this.sidplay2Section = new IniSidplay2Section(this.iniReader);
        this.c1541Section = new IniC1541Section(this.iniReader);
        this.printerSection = new IniPrinterSection(this.iniReader);
        this.consoleSection = new IniConsoleSection(this.iniReader);
        this.audioSection = new IniAudioSection(this.iniReader);
        this.emulationSection = new IniEmulationSection(this.iniReader);
        this.whatsSidSection = new IniWhatsSidSection(this.iniReader);
    }

    @Override
    public final List<? extends IFilterSection> getFilterSection() {
        ArrayList<IniFilterSection> filters = new ArrayList<IniFilterSection>();
        for (String heading : this.iniReader.listSections()) {
            if (!heading.matches("Filter.*")) continue;
            filters.add(new IniFilterSection(this.iniReader, heading));
        }
        return filters;
    }

    public static final IniConfig getDefault() {
        if (singleInstance == null) {
            singleInstance = new IniConfig();
        }
        return singleInstance;
    }

    public IniConfig() {
        this(false, null);
    }

    public IniConfig(boolean createIfNotExists) {
        this(createIfNotExists, IniConfig.getINIPath());
    }

    private IniConfig(boolean createIfNotExists, File iniPath) {
        this.iniPath = iniPath;
        if (iniPath != null && iniPath.exists()) {
            try (FileInputStream is = new FileInputStream(iniPath);){
                this.iniReader = new IniReader(is);
                this.clear();
                if (this.sidplay2Section.getVersion() == 25) {
                    if (createIfNotExists) {
                        System.out.println("Use INI file: " + iniPath);
                    }
                    return;
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            this.createINIBackup(iniPath);
            System.out.println("Use internal INI file: jsidplay2.ini");
        }
        this.readInternal();
        if (iniPath != null && !iniPath.exists() && createIfNotExists) {
            this.write();
        }
    }

    public static File getINIPath() {
        for (String parent : new String[]{System.getProperty("user.dir"), System.getProperty("user.home")}) {
            File configPlace = new File(parent, FILE_NAME);
            File oldConfig = new File(parent, "sidplay2.ini");
            if (oldConfig.exists()) {
                System.err.println(String.format("Warning, %s is NOT used anymore, please use the new name %s!", oldConfig, configPlace));
            }
            if (!configPlace.exists()) continue;
            return configPlace;
        }
        return new File(System.getProperty("user.home"), FILE_NAME);
    }

    private void createINIBackup(File iniFile) {
        File bakFile = new File(iniFile.getParentFile(), "jsidplay2.ini.bak");
        iniFile.renameTo(bakFile);
        int currentVersion = this.sidplay2Section.getVersion();
        System.out.println("Configuration file version=" + currentVersion + " is older than expected version=" + 25 + ", a backup has been created: " + bakFile);
    }

    private void readInternal() {
        try (InputStream is = this.getClass().getClassLoader().getResourceAsStream("sidplay/ini/jsidplay2.ini");){
            this.iniReader = new IniReader(is);
            this.clear();
            this.sidplay2Section.setVersion(25);
        }
        catch (IOException e) {
            e.printStackTrace();
            return;
        }
    }

    public final void write() {
        if (!this.iniReader.isDirty()) {
            return;
        }
        System.out.println("Save INI file: " + this.iniPath);
        try {
            this.iniReader.save(this.iniPath.getAbsolutePath());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public final ISidPlay2Section getSidplay2Section() {
        return this.sidplay2Section;
    }

    @Override
    public final IC1541Section getC1541Section() {
        return this.c1541Section;
    }

    @Override
    public final IPrinterSection getPrinterSection() {
        return this.printerSection;
    }

    @Override
    public final IConsoleSection getConsoleSection() {
        return this.consoleSection;
    }

    @Override
    public final IAudioSection getAudioSection() {
        return this.audioSection;
    }

    @Override
    public final IEmulationSection getEmulationSection() {
        return this.emulationSection;
    }

    @Override
    public final IWhatsSidSection getWhatsSidSection() {
        return this.whatsSidSection;
    }

    public final String toString() {
        return BeanToStringConverter.toString(this);
    }
}

