/*
 * Decompiled with CFR 0.152.
 */
package sidplay.player;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;

public class ObjectProperty<T> {
    private final String name;
    private final PropertyChangeSupport propertyChangeSupport;
    private T value;

    public ObjectProperty(String name, T initialValue) {
        this.name = name;
        this.value = initialValue;
        this.propertyChangeSupport = new PropertyChangeSupport(this);
    }

    public T get() {
        return this.value;
    }

    public void set(T value) {
        this.propertyChangeSupport.firePropertyChange(this.name, this.value, value);
        this.value = value;
    }

    public void addListener(PropertyChangeListener propertyChangeListener) {
        this.propertyChangeSupport.addPropertyChangeListener(propertyChangeListener);
    }

    public void removeListener(PropertyChangeListener propertyChangeListener) {
        this.propertyChangeSupport.removePropertyChangeListener(propertyChangeListener);
    }
}

